/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileEditor.impl;

import com.intellij.lang.properties.charset.Native2AsciiCharset;
import com.intellij.openapi.fileTypes.BinaryFileDecompiler;
import com.intellij.openapi.fileTypes.BinaryFileTypeDecompilers;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.encoding.EncodingManager;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.ArrayUtil;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class LoadTextUtil {
    static final Key<String> DETECTED_LINE_SEPARATOR_KEY = Key.create((String)"DETECTED_LINE_SEPARATOR_KEY");
    private static final Key<Boolean> UTF_CHARSET_WAS_DETECTED_FROM_BYTES = new Key("UTF_CHARSET_WAS_DETECTED_FROM_BYTES");

    private LoadTextUtil() {
    }

    private static Pair<CharSequence, String> convertLineSeparators(CharBuffer buffer) {
        boolean LF = true;
        int CR = 2;
        int line_separator = 0;
        int dst = 0;
        int prev = 32;
        int length = buffer.length();
        for (int src = 0; src < length; ++src) {
            char c = buffer.charAt(src);
            switch (c) {
                case '\r': {
                    buffer.put(dst++, '\n');
                    line_separator = 2;
                    break;
                }
                case '\n': {
                    if (prev == 13) {
                        line_separator = 3;
                        break;
                    }
                    buffer.put(dst++, '\n');
                    line_separator = 1;
                    break;
                }
                default: {
                    buffer.put(dst++, c);
                }
            }
            prev = c;
        }
        String detectedLineSeparator = null;
        switch (line_separator) {
            case 2: {
                detectedLineSeparator = "\r";
                break;
            }
            case 1: {
                detectedLineSeparator = "\n";
                break;
            }
            case 3: {
                detectedLineSeparator = "\r\n";
            }
        }
        CharSequence result = buffer.length() == dst ? buffer : buffer.subSequence(0, dst);
        return Pair.create((Object)result, (Object)detectedLineSeparator);
    }

    public static Charset detectCharset(VirtualFile virtualFile, byte[] content) {
        Charset charset = LoadTextUtil.dodetectCharset(virtualFile, content);
        Charset charset2 = charset = charset == null ? EncodingManager.getInstance().getDefaultCharset() : charset;
        if (virtualFile.getFileType() == StdFileTypes.PROPERTIES && EncodingManager.getInstance().isNative2AsciiForPropertiesFiles(virtualFile)) {
            charset = Native2AsciiCharset.wrap((Charset)charset);
        }
        virtualFile.setCharset(charset);
        return charset;
    }

    private static Charset dodetectCharset(VirtualFile virtualFile, byte[] content) {
        Charset saved;
        FileType fileType;
        String charsetName;
        EncodingManager settings = EncodingManager.getInstance();
        boolean shouldGuess = settings != null && settings.isUseUTFGuessing(virtualFile);
        CharsetToolkit toolkit = shouldGuess ? new CharsetToolkit(content, EncodingManager.getInstance().getDefaultCharset()) : null;
        LoadTextUtil.setUtfCharsetWasDetectedFromBytes(virtualFile, false);
        if (shouldGuess) {
            toolkit.setEnforce8Bit(true);
            Charset charset = toolkit.guessFromBOM();
            if (charset != null) {
                LoadTextUtil.setUtfCharsetWasDetectedFromBytes(virtualFile, true);
                return charset;
            }
            CharsetToolkit.GuessedEncoding guessed = toolkit.guessFromContent(content.length);
            if (guessed == CharsetToolkit.GuessedEncoding.VALID_UTF8) {
                LoadTextUtil.setUtfCharsetWasDetectedFromBytes(virtualFile, true);
                return CharsetToolkit.UTF8_CHARSET;
            }
        }
        if ((charsetName = (fileType = virtualFile.getFileType()).getCharset(virtualFile, content)) == null && (saved = EncodingManager.getInstance().getEncoding(virtualFile, true)) != null) {
            return saved;
        }
        return CharsetToolkit.forName((String)charsetName);
    }

    private static int skipBOM(VirtualFile virtualFile, byte[] content) {
        byte[] bom = LoadTextUtil.getBOM(content, virtualFile.getCharset());
        if (bom.length != 0) {
            virtualFile.setBOM(bom);
        }
        return bom.length;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    private static byte[] getBOM(byte[] content, Charset charset) {
        byte[] byArray;
        if (charset != null && charset.name().contains("UTF-8") && CharsetToolkit.hasUTF8Bom((byte[])content)) {
            byArray = CharsetToolkit.UTF8_BOM;
            if (CharsetToolkit.UTF8_BOM == null) throw new IllegalStateException("@NotNull method com/intellij/openapi/fileEditor/impl/LoadTextUtil.getBOM must not return null");
            return byArray;
        }
        if (CharsetToolkit.hasUTF16LEBom((byte[])content)) {
            byArray = CharsetToolkit.UTF16LE_BOM;
            if (CharsetToolkit.UTF16LE_BOM == null) throw new IllegalStateException("@NotNull method com/intellij/openapi/fileEditor/impl/LoadTextUtil.getBOM must not return null");
            return byArray;
        }
        if (CharsetToolkit.hasUTF16BEBom((byte[])content)) {
            byArray = CharsetToolkit.UTF16BE_BOM;
            if (CharsetToolkit.UTF16BE_BOM == null) throw new IllegalStateException("@NotNull method com/intellij/openapi/fileEditor/impl/LoadTextUtil.getBOM must not return null");
            return byArray;
        }
        byArray = ArrayUtil.EMPTY_BYTE_ARRAY;
        if (ArrayUtil.EMPTY_BYTE_ARRAY != null) return byArray;
        throw new IllegalStateException("@NotNull method com/intellij/openapi/fileEditor/impl/LoadTextUtil.getBOM must not return null");
    }

    public static Writer getWriter(@Nullable Project project, VirtualFile virtualFile, Object requestor, String text, long newModificationStamp) throws IOException {
        Charset specified;
        Charset existing = virtualFile.getCharset();
        Charset charset = LoadTextUtil.chooseMostlyHarmlessCharset(existing, specified = LoadTextUtil.extractCharsetFromFileContent(project, virtualFile, text), text);
        if (charset != null && !charset.equals(existing)) {
            virtualFile.setCharset(charset);
            if (virtualFile.getBOM() != null) {
                LoadTextUtil.setUtfCharsetWasDetectedFromBytes(virtualFile, true);
            }
        }
        OutputStream outputStream = virtualFile.getOutputStream(requestor, newModificationStamp, -1L);
        return new BufferedWriter(charset == null ? new OutputStreamWriter(outputStream) : new OutputStreamWriter(outputStream, charset));
    }

    private static Charset chooseMostlyHarmlessCharset(Charset existing, Charset specified, String text) {
        if (existing == null) {
            return specified;
        }
        if (specified == null) {
            return existing;
        }
        if (specified.equals(existing)) {
            return specified;
        }
        if (LoadTextUtil.isSupported(specified, text)) {
            return specified;
        }
        if (LoadTextUtil.isSupported(existing, text)) {
            return existing;
        }
        return specified;
    }

    private static boolean isSupported(Charset charset, String str) {
        if (!charset.canEncode()) {
            return false;
        }
        ByteBuffer out = charset.encode(str);
        CharBuffer buffer = charset.decode(out);
        return str.equals(buffer.toString());
    }

    public static Charset extractCharsetFromFileContent(@Nullable Project project, VirtualFile virtualFile, String text) {
        Charset charset = LoadTextUtil.charsetFromContentOrNull(project, virtualFile, text);
        if (charset == null) {
            charset = virtualFile.getCharset();
        }
        return charset;
    }

    @Nullable(value="returns null if cannot determine from content")
    public static Charset charsetFromContentOrNull(@Nullable Project project, @NotNull VirtualFile virtualFile, @NotNull String text) {
        if (virtualFile == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/fileEditor/impl/LoadTextUtil.charsetFromContentOrNull must not be null");
        }
        if (text == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/openapi/fileEditor/impl/LoadTextUtil.charsetFromContentOrNull must not be null");
        }
        FileType fileType = virtualFile.getFileType();
        if (fileType instanceof LanguageFileType) {
            return ((LanguageFileType)fileType).extractCharsetFromFileContent(project, virtualFile, text);
        }
        return null;
    }

    public static CharSequence loadText(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/fileEditor/impl/LoadTextUtil.loadText must not be null");
        }
        return LoadTextUtil.loadText(file, false);
    }

    public static CharSequence loadText(@NotNull VirtualFile file, boolean allowMissingDecompiler) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/fileEditor/impl/LoadTextUtil.loadText must not be null");
        }
        if (file instanceof LightVirtualFile) {
            CharSequence content = ((LightVirtualFile)file).getContent();
            if (StringUtil.indexOf((CharSequence)content, (char)'\r') == -1) {
                return content;
            }
            CharBuffer buffer = CharBuffer.allocate(content.length());
            buffer.append(content);
            buffer.rewind();
            return (CharSequence)LoadTextUtil.convertLineSeparators((CharBuffer)buffer).first;
        }
        assert (!file.isDirectory()) : "'" + file.getPresentableUrl() + "' is directory";
        FileType fileType = file.getFileType();
        if (fileType.isBinary()) {
            BinaryFileDecompiler decompiler = (BinaryFileDecompiler)BinaryFileTypeDecompilers.INSTANCE.forFileType(fileType);
            if (decompiler != null) {
                CharSequence text = decompiler.decompile(file);
                StringUtil.assertValidSeparators((CharSequence)text);
                return text;
            }
            if (allowMissingDecompiler) {
                return null;
            }
            throw new IllegalArgumentException("Attempt to load text for binary file, that doesn't have decompiler plugged in: " + file.getPresentableUrl());
        }
        try {
            byte[] bytes = file.contentsToByteArray();
            return LoadTextUtil.getTextByBinaryPresentation(bytes, file);
        }
        catch (IOException e) {
            return ArrayUtil.EMPTY_CHAR_SEQUENCE;
        }
    }

    @NotNull
    public static CharSequence getTextByBinaryPresentation(@NotNull byte[] bytes, @NotNull VirtualFile virtualFile) {
        if (bytes == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/fileEditor/impl/LoadTextUtil.getTextByBinaryPresentation must not be null");
        }
        if (virtualFile == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/fileEditor/impl/LoadTextUtil.getTextByBinaryPresentation must not be null");
        }
        CharSequence charSequence = LoadTextUtil.getTextByBinaryPresentation(bytes, virtualFile, true);
        if (charSequence == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/fileEditor/impl/LoadTextUtil.getTextByBinaryPresentation must not return null");
        }
        return charSequence;
    }

    @NotNull
    public static CharSequence getTextByBinaryPresentation(@NotNull byte[] bytes, @NotNull VirtualFile virtualFile, boolean rememberDetectedSeparators) {
        if (bytes == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/fileEditor/impl/LoadTextUtil.getTextByBinaryPresentation must not be null");
        }
        if (virtualFile == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/fileEditor/impl/LoadTextUtil.getTextByBinaryPresentation must not be null");
        }
        Charset charset = LoadTextUtil.detectCharset(virtualFile, bytes);
        int offset = LoadTextUtil.skipBOM(virtualFile, bytes);
        Pair<CharSequence, String> result = LoadTextUtil.convertBytes(bytes, charset, offset);
        if (rememberDetectedSeparators) {
            virtualFile.putUserData(DETECTED_LINE_SEPARATOR_KEY, result.getSecond());
        }
        CharSequence charSequence = (CharSequence)result.getFirst();
        if (charSequence == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/fileEditor/impl/LoadTextUtil.getTextByBinaryPresentation must not return null");
        }
        return charSequence;
    }

    @Nullable
    public static String detectLineSeparator(@NotNull VirtualFile file, boolean checkFile) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/fileEditor/impl/LoadTextUtil.detectLineSeparator must not be null");
        }
        String lineSeparator = (String)file.getUserData(DETECTED_LINE_SEPARATOR_KEY);
        if (lineSeparator == null && checkFile) {
            try {
                LoadTextUtil.getTextByBinaryPresentation(file.contentsToByteArray(), file);
                lineSeparator = (String)file.getUserData(DETECTED_LINE_SEPARATOR_KEY);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return lineSeparator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void changeLineSeparator(@Nullable Project project, @Nullable Object requestor, @NotNull VirtualFile file, @NotNull String newLineSeparator) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/openapi/fileEditor/impl/LoadTextUtil.changeLineSeparator must not be null");
        }
        if (newLineSeparator == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of com/intellij/openapi/fileEditor/impl/LoadTextUtil.changeLineSeparator must not be null");
        }
        String lineSeparator = (String)file.getUserData(DETECTED_LINE_SEPARATOR_KEY);
        if (lineSeparator != null && lineSeparator.equals(newLineSeparator)) {
            return;
        }
        CharSequence cs = LoadTextUtil.getTextByBinaryPresentation(file.contentsToByteArray(), file);
        lineSeparator = (String)file.getUserData(DETECTED_LINE_SEPARATOR_KEY);
        if (lineSeparator == null || lineSeparator.equals(newLineSeparator)) {
            return;
        }
        if (!newLineSeparator.equals("\n")) {
            cs = StringUtil.convertLineSeparators((String)((Object)cs).toString(), (String)newLineSeparator);
        }
        String text = ((Object)cs).toString();
        file.putUserData(DETECTED_LINE_SEPARATOR_KEY, (Object)newLineSeparator);
        Writer w = LoadTextUtil.getWriter(project, file, requestor, text, System.currentTimeMillis());
        try {
            w.write(text);
        }
        finally {
            w.close();
        }
    }

    @NotNull
    public static CharSequence getTextByBinaryPresentation(@NotNull byte[] bytes, Charset charset) {
        if (bytes == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/fileEditor/impl/LoadTextUtil.getTextByBinaryPresentation must not be null");
        }
        int offset = LoadTextUtil.getBOM(bytes, charset).length;
        CharSequence charSequence = (CharSequence)LoadTextUtil.convertBytes(bytes, charset, offset).getFirst();
        if (charSequence == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/fileEditor/impl/LoadTextUtil.getTextByBinaryPresentation must not return null");
        }
        return charSequence;
    }

    @NotNull
    private static Pair<CharSequence, String> convertBytes(@NotNull byte[] bytes, Charset charset, int startOffset) {
        if (bytes == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/fileEditor/impl/LoadTextUtil.convertBytes must not be null");
        }
        ByteBuffer byteBuffer = ByteBuffer.wrap(bytes, startOffset, bytes.length - startOffset);
        if (charset == null) {
            charset = CharsetToolkit.getDefaultSystemCharset();
        }
        if (charset == null) {
            charset = Charset.forName("ISO-8859-1");
        }
        CharBuffer charBuffer = charset.decode(byteBuffer);
        Pair<CharSequence, String> pair = LoadTextUtil.convertLineSeparators(charBuffer);
        if (pair == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/fileEditor/impl/LoadTextUtil.convertBytes must not return null");
        }
        return pair;
    }

    public static boolean utfCharsetWasDetectedFromBytes(@NotNull VirtualFile virtualFile) {
        if (virtualFile == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/fileEditor/impl/LoadTextUtil.utfCharsetWasDetectedFromBytes must not be null");
        }
        return virtualFile.getUserData(UTF_CHARSET_WAS_DETECTED_FROM_BYTES) != null;
    }

    private static void setUtfCharsetWasDetectedFromBytes(@NotNull VirtualFile virtualFile, boolean flag) {
        if (virtualFile == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/fileEditor/impl/LoadTextUtil.setUtfCharsetWasDetectedFromBytes must not be null");
        }
        virtualFile.putUserData(UTF_CHARSET_WAS_DETECTED_FROM_BYTES, (Object)(flag ? Boolean.TRUE : null));
    }
}

