/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.actions;

import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.editor.actionSystem.EditorAction;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.actionSystem.EditorWriteActionHandler;
import com.intellij.openapi.editor.actions.EditorActionUtil;
import com.intellij.openapi.util.text.StringUtil;

public class DeleteAction
extends EditorAction {
    public DeleteAction() {
        super((EditorActionHandler)new Handler());
    }

    private static int getCaretLineLength(Editor editor) {
        Document document = editor.getDocument();
        if (document.getLineCount() == 0) {
            return 0;
        }
        int lineNumber = editor.getCaretModel().getLogicalPosition().line;
        if (lineNumber >= document.getLineCount()) {
            return 0;
        }
        return document.getLineEndOffset(lineNumber) - document.getLineStartOffset(lineNumber);
    }

    private static int getCaretLineStart(Editor editor) {
        Document document = editor.getDocument();
        if (document.getLineCount() == 0) {
            return 0;
        }
        int lineNumber = editor.getCaretModel().getLogicalPosition().line;
        if (lineNumber >= document.getLineCount()) {
            return document.getLineStartOffset(document.getLineCount() - 1);
        }
        return document.getLineStartOffset(lineNumber);
    }

    public static void deleteCharAtCaret(Editor editor) {
        int lineNumber = editor.getCaretModel().getLogicalPosition().line;
        int afterLineEnd = EditorModificationUtil.calcAfterLineEnd((Editor)editor);
        Document document = editor.getDocument();
        if (afterLineEnd < 0) {
            int offset = editor.getCaretModel().getOffset();
            document.deleteString(offset, offset + 1);
            return;
        }
        if (lineNumber + 1 >= document.getLineCount()) {
            return;
        }
        CommandProcessor commandProcessor = CommandProcessor.getInstance();
        commandProcessor.setCurrentCommandGroupId(null);
        int nextLineStart = document.getLineStartOffset(lineNumber + 1);
        int nextLineEnd = document.getLineEndOffset(lineNumber + 1);
        if (nextLineEnd - nextLineStart > 0) {
            StringBuilder buf = new StringBuilder();
            StringUtil.repeatSymbol((Appendable)buf, (char)' ', (int)afterLineEnd);
            document.insertString(DeleteAction.getCaretLineStart(editor) + DeleteAction.getCaretLineLength(editor), (CharSequence)buf.toString());
            nextLineStart = document.getLineStartOffset(lineNumber + 1);
        }
        int thisLineEnd = document.getLineEndOffset(lineNumber);
        document.deleteString(thisLineEnd, nextLineStart);
    }

    public static class Handler
    extends EditorWriteActionHandler {
        public void executeWriteAction(Editor editor, DataContext dataContext) {
            CommandProcessor.getInstance().setCurrentCommandGroupId(EditorActionUtil.DELETE_COMMAND_GROUP);
            SelectionModel selectionModel = editor.getSelectionModel();
            if (selectionModel.hasBlockSelection()) {
                LogicalPosition start = selectionModel.getBlockStart();
                LogicalPosition end = selectionModel.getBlockEnd();
                if (start.column == end.column) {
                    int column = start.column;
                    int startLine = Math.min(start.line, end.line);
                    int endLine = Math.max(start.line, end.line);
                    for (int i = startLine; i <= endLine; ++i) {
                        editor.getCaretModel().moveToLogicalPosition(new LogicalPosition(i, column));
                        DeleteAction.deleteCharAtCaret(editor);
                    }
                    selectionModel.setBlockSelection(new LogicalPosition(startLine, column), new LogicalPosition(endLine, column));
                    return;
                }
                EditorModificationUtil.deleteBlockSelection((Editor)editor);
            } else if (!selectionModel.hasSelection()) {
                DeleteAction.deleteCharAtCaret(editor);
            } else {
                EditorModificationUtil.deleteSelectedText((Editor)editor);
            }
        }
    }
}

