/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.impl.incrementalMerge;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.impl.incrementalMerge.Change;
import com.intellij.openapi.diff.impl.incrementalMerge.ChangeList;
import com.intellij.openapi.diff.impl.incrementalMerge.MergeList;
import com.intellij.openapi.util.Key;
import java.util.ArrayList;
import java.util.Iterator;

public class ChangeCounter
implements ChangeList.Listener {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.diff.impl.incrementalMerge.ChangeCounter");
    private static final Key<ChangeCounter> ourKey = Key.create((String)"ChangeCounter");
    private final MergeList myMergeList;
    private final ArrayList<Listener> myListeners = new ArrayList();
    private int myChangeCounter = 0;
    private int myConflictCounter = 0;

    private ChangeCounter(MergeList mergeList) {
        this.myMergeList = mergeList;
        this.myMergeList.addListener(this);
        this.updateCounters();
    }

    @Override
    public void onChangeRemoved(ChangeList source) {
        this.updateCounters();
    }

    public void addListener(Listener listener) {
        this.myListeners.add(listener);
    }

    public void removeListener(Listener listener) {
        this.myListeners.remove(listener);
    }

    private void updateCounters() {
        int conflictCounter = 0;
        int changeCounter = 0;
        Iterator<Change> allChanges = this.myMergeList.getAllChanges();
        while (allChanges.hasNext()) {
            Change change = allChanges.next();
            if (MergeList.NOT_CONFLICTS.value((Object)change)) {
                ++changeCounter;
                continue;
            }
            ++conflictCounter;
        }
        if (this.myChangeCounter != changeCounter || this.myConflictCounter != conflictCounter) {
            this.myChangeCounter = changeCounter;
            this.myConflictCounter = conflictCounter;
            this.fireCountersChanged();
        }
    }

    private void fireCountersChanged() {
        Listener[] listeners = this.myListeners.toArray(new Listener[this.myListeners.size()]);
        for (int i = 0; i < listeners.length; ++i) {
            Listener listener = listeners[i];
            listener.onCountersChanged(this);
        }
    }

    public int getChangeCounter() {
        return this.myChangeCounter;
    }

    public int getConflictCounter() {
        return this.myConflictCounter;
    }

    public static ChangeCounter getOrCreate(MergeList mergeList) {
        ChangeCounter data = mergeList.getUserData(ourKey);
        if (data == null) {
            data = new ChangeCounter(mergeList);
            mergeList.putUserData(ourKey, data);
        }
        return data;
    }

    public static interface Listener {
        public void onCountersChanged(ChangeCounter var1);
    }
}

