/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.treeView;

import com.intellij.ide.projectView.impl.nodes.PsiDirectoryNode;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vcs.FileStatusManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.util.PsiUtilBase;
import java.awt.Color;
import javax.swing.Icon;

public class SmartElementDescriptor
extends NodeDescriptor {
    protected PsiElement myElement;
    private final SmartPsiElementPointer mySmartPointer;

    public SmartElementDescriptor(Project project, NodeDescriptor parentDescriptor, PsiElement element) {
        super(project, parentDescriptor);
        this.myElement = element;
        this.mySmartPointer = SmartPointerManager.getInstance((Project)this.myProject).createSmartPsiElementPointer(element);
    }

    public Object getElement() {
        return this.myElement;
    }

    protected boolean isMarkReadOnly() {
        return this.getParentDescriptor() instanceof PsiDirectoryNode;
    }

    protected boolean isMarkModified() {
        return this.getParentDescriptor() instanceof PsiDirectoryNode;
    }

    public boolean update() {
        VirtualFile virtualFile;
        this.myElement = this.mySmartPointer.getElement();
        if (this.myElement == null) {
            return true;
        }
        int flags = 1;
        if (this.isMarkReadOnly()) {
            flags |= 2;
        }
        Icon icon = null;
        try {
            icon = this.myElement.getIcon(flags);
        }
        catch (IndexNotReadyException e) {
            // empty catch block
        }
        Color color = null;
        if (this.isMarkModified() && (virtualFile = PsiUtilBase.getVirtualFile((PsiElement)this.myElement)) != null) {
            color = FileStatusManager.getInstance((Project)this.myProject).getStatus(virtualFile).getColor();
        }
        if (CopyPasteManager.getInstance().isCutElement((Object)this.myElement)) {
            color = CopyPasteManager.CUT_COLOR;
        }
        boolean changes = !Comparing.equal((Object)icon, (Object)this.myOpenIcon) || !Comparing.equal((Object)color, (Object)this.myColor);
        this.myClosedIcon = this.myOpenIcon = icon;
        this.myColor = color;
        return changes;
    }
}

