/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.frameworkSupport;

import com.intellij.ide.util.frameworkSupport.FrameworkSupportProvider;
import com.intellij.ide.util.projectWizard.ModuleBuilder;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleType;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FrameworkSupportUtil {
    private FrameworkSupportUtil() {
    }

    public static List<FrameworkSupportProvider> getProviders(@NotNull ModuleType moduleType) {
        if (moduleType == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ide/util/frameworkSupport/FrameworkSupportUtil.getProviders must not be null");
        }
        return FrameworkSupportUtil.getProviders(moduleType, null);
    }

    public static List<FrameworkSupportProvider> getProviders(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ide/util/frameworkSupport/FrameworkSupportUtil.getProviders must not be null");
        }
        return FrameworkSupportUtil.getProviders(module.getModuleType(), module);
    }

    private static List<FrameworkSupportProvider> getProviders(@NotNull ModuleType moduleType, @Nullable Module module) {
        if (moduleType == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ide/util/frameworkSupport/FrameworkSupportUtil.getProviders must not be null");
        }
        FrameworkSupportProvider[] providers = (FrameworkSupportProvider[])Extensions.getExtensions((ExtensionPointName)FrameworkSupportProvider.EXTENSION_POINT);
        ArrayList<FrameworkSupportProvider> result = new ArrayList<FrameworkSupportProvider>();
        for (FrameworkSupportProvider provider : providers) {
            if (!provider.isEnabledForModuleType(moduleType) || module != null && provider.isSupportAlreadyAdded(module)) continue;
            result.add(provider);
        }
        return result;
    }

    public static List<FrameworkSupportProvider> getProviders(@NotNull ModuleBuilder builder) {
        if (builder == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ide/util/frameworkSupport/FrameworkSupportUtil.getProviders must not be null");
        }
        ArrayList<FrameworkSupportProvider> result = new ArrayList<FrameworkSupportProvider>();
        for (FrameworkSupportProvider provider : (FrameworkSupportProvider[])Extensions.getExtensions((ExtensionPointName)FrameworkSupportProvider.EXTENSION_POINT)) {
            if (!provider.isEnabledForModuleBuilder(builder)) continue;
            result.add(provider);
        }
        return result;
    }

    public static boolean hasProviders(Module module) {
        List<FrameworkSupportProvider> providers = FrameworkSupportUtil.getProviders(module);
        for (FrameworkSupportProvider provider : providers) {
            if (provider.getUnderlyingFrameworkId() != null) continue;
            return true;
        }
        return false;
    }
}

