/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.structureView.impl.java;

import com.intellij.ide.structureView.impl.java.AccessLevelProvider;
import com.intellij.ide.util.treeView.AlphaComparator;
import com.intellij.ide.util.treeView.SourceComparator;
import com.intellij.openapi.diagnostic.Logger;
import java.util.Comparator;
import org.jetbrains.annotations.NotNull;

public class VisibilityComparator
implements Comparator {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.ide.structureView.impl.java.VisibilityComparator");
    private static final int GROUP_ACCESS_SUBLEVEL = 1;
    public static Comparator THEN_SOURCE = new VisibilityComparator(SourceComparator.INSTANCE);
    public static Comparator THEN_ALPHA = new VisibilityComparator(AlphaComparator.INSTANCE);
    public static Comparator IMSTANCE = new VisibilityComparator(null);
    private final Comparator myNextComparator;
    private static final int UNKNOWN_ACCESS_LEVEL = -1;

    public VisibilityComparator(Comparator comparator) {
        this.myNextComparator = comparator;
    }

    public int compare(@NotNull Object descriptor1, @NotNull Object descriptor2) {
        int accessLevel2;
        if (descriptor1 == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ide/structureView/impl/java/VisibilityComparator.compare must not be null");
        }
        if (descriptor2 == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/ide/structureView/impl/java/VisibilityComparator.compare must not be null");
        }
        int accessLevel1 = VisibilityComparator.getAccessLevel(descriptor1);
        if (accessLevel1 == (accessLevel2 = VisibilityComparator.getAccessLevel(descriptor2)) && this.myNextComparator != null) {
            return this.myNextComparator.compare(descriptor1, descriptor2);
        }
        return accessLevel2 - accessLevel1;
    }

    private static int getAccessLevel(@NotNull Object element) {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ide/structureView/impl/java/VisibilityComparator.getAccessLevel must not be null");
        }
        if (element instanceof AccessLevelProvider) {
            return ((AccessLevelProvider)element).getAccessLevel() * 2 + ((AccessLevelProvider)element).getSubLevel();
        }
        LOG.error(element.getClass().getName());
        return -1;
    }
}

