/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.highlighter.custom.tokens;

import com.intellij.ide.highlighter.custom.tokens.PrefixedTokenParser;
import com.intellij.psi.CustomHighlighterTokenType;

public class HexNumberParser
extends PrefixedTokenParser {
    private HexNumberParser(String prefix) {
        super(prefix, CustomHighlighterTokenType.NUMBER);
    }

    @Override
    protected int getTokenEnd(int position) {
        while (position < this.myEndOffset && HexNumberParser.isHexDigit(this.myBuffer.charAt(position))) {
            ++position;
        }
        return position;
    }

    public static boolean isHexDigit(char c) {
        return c >= '0' && c <= '9' || c >= 'a' && c <= 'f' || c >= 'A' && c <= 'F';
    }

    public static HexNumberParser create(String prefix) {
        if (prefix == null) {
            return null;
        }
        String trimmedPrefix = prefix.trim();
        if (trimmedPrefix.length() > 0) {
            return new HexNumberParser(prefix);
        }
        return null;
    }
}

