/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.browsers;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.browsers.BrowserSpecificSettings;
import com.intellij.ide.browsers.BrowsersConfiguration;
import com.intellij.ide.browsers.WebBrowserSettings;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.util.containers.HashMap;
import com.intellij.xml.XmlBundle;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

public class WebBrowsersPanel
extends JPanel {
    private final JPanel mySettingsPanel;
    private Map<BrowsersConfiguration.BrowserFamily, Pair<JCheckBox, TextFieldWithBrowseButton>> myBrowserSettingsMap = new HashMap();
    private final BrowsersConfiguration myConfiguration;

    public WebBrowsersPanel(BrowsersConfiguration configuration) {
        this.setLayout(new BorderLayout());
        this.myConfiguration = configuration;
        this.mySettingsPanel = new JPanel();
        this.mySettingsPanel.setLayout(new BoxLayout(this.mySettingsPanel, 1));
        this.add((Component)this.mySettingsPanel, "North");
        this.createIndividualSettings(BrowsersConfiguration.BrowserFamily.FIREFOX, this.mySettingsPanel);
        this.createIndividualSettings(BrowsersConfiguration.BrowserFamily.EXPLORER, this.mySettingsPanel);
        this.createIndividualSettings(BrowsersConfiguration.BrowserFamily.SAFARI, this.mySettingsPanel);
        this.createIndividualSettings(BrowsersConfiguration.BrowserFamily.CHROME, this.mySettingsPanel);
        this.createIndividualSettings(BrowsersConfiguration.BrowserFamily.OPERA, this.mySettingsPanel);
    }

    private void createIndividualSettings(final @NotNull BrowsersConfiguration.BrowserFamily family, JPanel container) {
        if (family == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ide/browsers/WebBrowsersPanel.createIndividualSettings must not be null");
        }
        JPanel result = new JPanel();
        result.setBorder(BorderFactory.createTitledBorder(family.getName()));
        result.setLayout(new BoxLayout(result, 1));
        final TextFieldWithBrowseButton field = new TextFieldWithBrowseButton();
        FileChooserDescriptor descriptor = SystemInfo.isMac ? FileChooserDescriptorFactory.createSingleFolderDescriptor() : FileChooserDescriptorFactory.createSingleFileNoJarsDescriptor();
        field.addBrowseFolderListener(IdeBundle.message((String)"title.select.path.to.browser", (Object[])new Object[0]), null, null, descriptor);
        result.add((Component)field);
        JPanel bottomPanel = new JPanel(new BorderLayout());
        JPanel activePanel = new JPanel();
        activePanel.setLayout(new BoxLayout(activePanel, 0));
        JCheckBox checkBox = new JCheckBox();
        activePanel.add(checkBox);
        JLabel label = new JLabel(XmlBundle.message((String)"browser.active", (Object[])new Object[0]));
        label.setLabelFor(checkBox);
        activePanel.add(label);
        bottomPanel.add((Component)activePanel, "West");
        JButton resetButton = new JButton(XmlBundle.message((String)"browser.default.settings", (Object[])new Object[0]));
        resetButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                field.getTextField().setText(family.getExecutionPath());
            }
        });
        JPanel buttonsPanel = new JPanel(new BorderLayout());
        if (family.createBrowserSpecificSettings() != null) {
            JButton editSettingsButton = new JButton(XmlBundle.message((String)"button.text.settings", (Object[])new Object[0]));
            editSettingsButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    WebBrowsersPanel.this.editSettings(family);
                }
            });
            buttonsPanel.add((Component)editSettingsButton, "Center");
        }
        buttonsPanel.add((Component)resetButton, "East");
        bottomPanel.add((Component)buttonsPanel, "East");
        result.add(bottomPanel);
        container.add(result);
        WebBrowserSettings settings = this.myConfiguration.getBrowserSettings(family);
        field.getTextField().setText(settings.getPath());
        checkBox.setSelected(settings.isActive());
        this.myBrowserSettingsMap.put(family, (Pair<JCheckBox, TextFieldWithBrowseButton>)Pair.create((Object)checkBox, (Object)field));
    }

    private void editSettings(BrowsersConfiguration.BrowserFamily family) {
        BrowserSpecificSettings settings = this.myConfiguration.getBrowserSettings(family).getBrowserSpecificSettings();
        if (settings == null) {
            settings = family.createBrowserSpecificSettings();
        }
        if (ShowSettingsUtil.getInstance().editConfigurable((Component)this.mySettingsPanel, settings.createConfigurable())) {
            this.myConfiguration.updateBrowserSpecificSettings(family, settings);
        }
    }

    public void dispose() {
        this.myBrowserSettingsMap = null;
    }

    public boolean isModified() {
        for (BrowsersConfiguration.BrowserFamily family : BrowsersConfiguration.BrowserFamily.values()) {
            WebBrowserSettings old = this.myConfiguration.getBrowserSettings(family);
            Pair<JCheckBox, TextFieldWithBrowseButton> settings = this.myBrowserSettingsMap.get((Object)family);
            if (old.isActive() == ((JCheckBox)settings.first).isSelected() && old.getPath().equals(((TextFieldWithBrowseButton)settings.second).getText())) continue;
            return true;
        }
        return false;
    }

    public void apply() {
        for (BrowsersConfiguration.BrowserFamily family : this.myBrowserSettingsMap.keySet()) {
            Pair<JCheckBox, TextFieldWithBrowseButton> buttonPair = this.myBrowserSettingsMap.get((Object)family);
            this.myConfiguration.updateBrowserValue(family, ((TextFieldWithBrowseButton)buttonPair.second).getText(), ((JCheckBox)buttonPair.first).isSelected());
        }
    }

    public void reset() {
        for (BrowsersConfiguration.BrowserFamily family : this.myBrowserSettingsMap.keySet()) {
            Pair<JCheckBox, TextFieldWithBrowseButton> buttonPair = this.myBrowserSettingsMap.get((Object)family);
            WebBrowserSettings settings = this.myConfiguration.getBrowserSettings(family);
            ((JCheckBox)buttonPair.first).setSelected(settings.isActive());
            ((TextFieldWithBrowseButton)buttonPair.second).getTextField().setText(settings.getPath());
        }
    }
}

