/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.history.core.changes;

import com.intellij.history.core.IdPath;
import com.intellij.history.core.changes.Change;
import com.intellij.history.core.changes.ChangeVisitor;
import com.intellij.history.core.storage.Content;
import com.intellij.history.core.storage.Stream;
import com.intellij.history.core.tree.Entry;
import java.io.IOException;
import java.util.Collections;
import java.util.List;

public class PutLabelChange
extends Change {
    private final String myName;
    private final long myTimestamp;

    public PutLabelChange(String name, long timestamp) {
        this.myName = name;
        this.myTimestamp = timestamp;
    }

    public PutLabelChange(Stream s) throws IOException {
        this.myName = s.readString();
        this.myTimestamp = s.readLong();
    }

    @Override
    public void write(Stream s) throws IOException {
        s.writeString(this.myName);
        s.writeLong(this.myTimestamp);
    }

    @Override
    public String getName() {
        return this.myName;
    }

    @Override
    public long getTimestamp() {
        return this.myTimestamp;
    }

    @Override
    public void applyTo(Entry r) {
    }

    @Override
    public void doRevertOn(Entry root) {
    }

    @Override
    public boolean affects(IdPath ... pp) {
        return true;
    }

    @Override
    public boolean affectsOnlyInside(Entry e) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isCreationalFor(Entry e) {
        return false;
    }

    @Override
    public List<Content> getContentsToPurge() {
        return Collections.emptyList();
    }

    @Override
    public boolean isLabel() {
        return true;
    }

    @Override
    public void accept(ChangeVisitor v) throws IOException, ChangeVisitor.StopVisitingException {
        v.visit(this);
    }
}

