/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.facet.impl.ui.libraries;

import com.intellij.facet.ui.libraries.LibraryInfo;
import com.intellij.openapi.roots.libraries.LibraryUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class RequiredLibrariesInfo {
    private final List<LibraryInfo> myLibraryInfos = new ArrayList<LibraryInfo>();

    public RequiredLibrariesInfo() {
    }

    public RequiredLibrariesInfo(LibraryInfo ... libs) {
        this.myLibraryInfos.addAll(new ArrayList<LibraryInfo>(Arrays.asList(libs)));
    }

    public void addLibraryInfo(LibraryInfo lib) {
        this.myLibraryInfos.add(lib);
    }

    @Nullable
    public RequiredClassesNotFoundInfo checkLibraries(VirtualFile[] libraryFiles, boolean all) {
        ArrayList<LibraryInfo> infos = new ArrayList<LibraryInfo>();
        ArrayList<String> classes = new ArrayList<String>();
        for (LibraryInfo info : this.myLibraryInfos) {
            boolean notFound = all && info.getRequiredClasses().length == 0;
            for (String className : info.getRequiredClasses()) {
                if (LibraryUtil.isClassAvailableInLibrary((VirtualFile[])libraryFiles, (String)className)) continue;
                classes.add(className);
                notFound = true;
            }
            if (!notFound) continue;
            infos.add(info);
        }
        if (infos.isEmpty()) {
            return null;
        }
        return new RequiredClassesNotFoundInfo(ArrayUtil.toStringArray(classes), infos.toArray(new LibraryInfo[infos.size()]));
    }

    public static String getLibrariesPresentableText(LibraryInfo[] libraryInfos) {
        StringBuilder missedJarsText = new StringBuilder();
        for (int i = 0; i < libraryInfos.length; ++i) {
            if (i > 0) {
                missedJarsText.append(", ");
            }
            missedJarsText.append(libraryInfos[i].getPresentableName());
        }
        return missedJarsText.toString();
    }

    public static class RequiredClassesNotFoundInfo {
        private final String[] myClassNames;
        private final LibraryInfo[] myLibraryInfos;

        public RequiredClassesNotFoundInfo(String[] classNames, LibraryInfo[] libraryInfos) {
            this.myClassNames = classNames;
            this.myLibraryInfos = libraryInfos;
        }

        public String[] getClassNames() {
            return this.myClassNames;
        }

        public LibraryInfo[] getLibraryInfos() {
            return this.myLibraryInfos;
        }

        public String getMissingJarsText() {
            return RequiredLibrariesInfo.getLibrariesPresentableText(this.myLibraryInfos);
        }
    }
}

