/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.impl;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.impl.ConsoleViewImpl;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.openapi.util.Key;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;

public abstract class ConsoleState {
    public static final ConsoleState NOT_STARTED = new ConsoleState(){

        @Override
        public ConsoleState attachTo(ConsoleViewImpl console, ProcessHandler processHandler) {
            return new RunningState(console, processHandler);
        }
    };

    public ConsoleState dispose() {
        return NOT_STARTED;
    }

    public boolean isFinished() {
        return false;
    }

    public boolean isRunning() {
        return false;
    }

    public void sendUserInput(String input) throws IOException {
    }

    public abstract ConsoleState attachTo(ConsoleViewImpl var1, ProcessHandler var2);

    private static class RunningState
    extends ConsoleState {
        private final ConsoleViewImpl myConsole;
        private final ProcessAdapter myProcessListener = new ProcessAdapter(){

            public void onTextAvailable(ProcessEvent event, Key outputType) {
                RunningState.this.myConsole.print(event.getText(), ConsoleViewContentType.getConsoleViewType((Key)outputType));
            }
        };
        private final ProcessHandler myProcessHandler;
        private final Writer myUserInputWriter;

        public RunningState(ConsoleViewImpl console, ProcessHandler processHandler) {
            this.myConsole = console;
            this.myProcessHandler = processHandler;
            processHandler.addProcessListener((ProcessListener)this.myProcessListener);
            OutputStream processInput = this.myProcessHandler.getProcessInput();
            this.myUserInputWriter = processInput != null ? new OutputStreamWriter(processInput) : null;
        }

        @Override
        public ConsoleState dispose() {
            if (this.myProcessHandler != null) {
                this.myProcessHandler.removeProcessListener((ProcessListener)this.myProcessListener);
            }
            return NOT_STARTED;
        }

        @Override
        public boolean isFinished() {
            return this.myProcessHandler == null || this.myProcessHandler.isProcessTerminated();
        }

        @Override
        public boolean isRunning() {
            return this.myProcessHandler != null && !this.myProcessHandler.isProcessTerminated();
        }

        @Override
        public void sendUserInput(String input) throws IOException {
            if (this.myUserInputWriter == null) {
                throw new IOException(ExecutionBundle.message((String)"no.user.process.input.error.message", (Object[])new Object[0]));
            }
            this.myUserInputWriter.write(input);
            this.myUserInputWriter.flush();
        }

        @Override
        public ConsoleState attachTo(ConsoleViewImpl console, ProcessHandler processHandler) {
            return this.dispose().attachTo(console, processHandler);
        }
    }
}

