/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.applet;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.applet.AppletConfiguration;
import com.intellij.execution.impl.CheckableRunConfigurationEditor;
import com.intellij.execution.junit2.configuration.ClassBrowser;
import com.intellij.execution.junit2.configuration.ConfigurationModuleSelector;
import com.intellij.execution.ui.AlternativeJREPanel;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.LabeledComponent;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.RawCommandLineEditor;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.table.TableView;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.ListTableModel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.table.TableCellEditor;
import org.jetbrains.annotations.NonNls;

public class AppletConfigurable
extends SettingsEditor<AppletConfiguration>
implements CheckableRunConfigurationEditor<AppletConfiguration> {
    private JPanel myWholePanel;
    private JRadioButton myMainClass;
    private JRadioButton myURL;
    private JPanel myClassOptions;
    private JPanel myHTMLOptions;
    private LabeledComponent<TextFieldWithBrowseButton> myPolicyFile;
    private LabeledComponent<RawCommandLineEditor> myVMParameters;
    private TextFieldWithBrowseButton myClassName;
    private TextFieldWithBrowseButton myHtmlFile;
    private JTextField myWidth;
    private JTextField myHeight;
    private LabeledComponent<JComboBox> myModule;
    private JPanel myTablePlace;
    private JButton myAddButton;
    private JButton myRemoveButton;
    private JLabel myHtmlFileLabel;
    private JLabel myClassNameLabel;
    private JLabel myWidthLabel;
    private JLabel myHeightLabel;
    private AlternativeJREPanel myAlternativeJREPanel;
    private final ButtonGroup myAppletRadioButtonGroup;
    private final Project myProject;
    private final ConfigurationModuleSelector myModuleSelector;
    private static final ColumnInfo[] PARAMETER_COLUMNS = new ColumnInfo[]{new MyColumnInfo(ExecutionBundle.message((String)"applet.configuration.parameter.name.column", (Object[])new Object[0])){

        public String valueOf(AppletConfiguration.AppletParameter appletParameter) {
            return appletParameter.getName();
        }

        public void setValue(AppletConfiguration.AppletParameter appletParameter, String name) {
            appletParameter.setName(name);
        }
    }, new MyColumnInfo(ExecutionBundle.message((String)"applet.configuration.parameter.value.column", (Object[])new Object[0])){

        public String valueOf(AppletConfiguration.AppletParameter appletParameter) {
            return appletParameter.getValue();
        }

        public void setValue(AppletConfiguration.AppletParameter appletParameter, String value) {
            appletParameter.setValue(value);
        }
    }};
    private final ListTableModel<AppletConfiguration.AppletParameter> myParameters;
    private final TableView myTable;
    @NonNls
    protected static final String HTTP_PREFIX = "http:/";

    private void changePanel() {
        if (this.myMainClass.isSelected()) {
            this.myClassOptions.setVisible(true);
            this.myHTMLOptions.setVisible(false);
        } else {
            this.myHTMLOptions.setVisible(true);
            this.myClassOptions.setVisible(false);
        }
    }

    public AppletConfigurable(Project project) {
        this.$$$setupUI$$$();
        this.myAppletRadioButtonGroup = new ButtonGroup();
        this.myParameters = new ListTableModel(PARAMETER_COLUMNS);
        this.myClassNameLabel.setLabelFor(this.myClassName.getTextField());
        this.myHtmlFileLabel.setLabelFor(this.myHtmlFile.getTextField());
        this.myWidthLabel.setLabelFor(this.myWidth);
        this.myHeightLabel.setLabelFor(this.myHeight);
        this.myProject = project;
        this.myModuleSelector = new ConfigurationModuleSelector(project, this.getModuleComponent());
        this.myTablePlace.setLayout(new BorderLayout());
        this.myTable = new TableView(this.myParameters);
        this.myTablePlace.add((Component)ScrollPaneFactory.createScrollPane((JComponent)this.myTable), "Center");
        this.myAppletRadioButtonGroup.add(this.myMainClass);
        this.myAppletRadioButtonGroup.add(this.myURL);
        this.getVMParametersComponent().setDialogCaption(this.myVMParameters.getRawText());
        this.myMainClass.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AppletConfigurable.this.changePanel();
            }
        });
        this.myURL.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AppletConfigurable.this.changePanel();
            }
        });
        this.getPolicyFileComponent().addBrowseFolderListener(ExecutionBundle.message((String)"select.applet.policy.file.dialog.title", (Object[])new Object[0]), null, this.myProject, FileChooserDescriptorFactory.createSingleFileNoJarsDescriptor());
        this.getHtmlPathComponent().addBrowseFolderListener(ExecutionBundle.message((String)"choose.html.file.dialog.title", (Object[])new Object[0]), null, this.myProject, FileChooserDescriptorFactory.createSingleFileNoJarsDescriptor());
        ClassBrowser.createAppletClassBrowser(this.myProject, this.myModuleSelector).setField(this.getClassNameComponent());
        this.myHTMLOptions.setVisible(false);
        this.myAddButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AppletConfigurable.this.addParameter();
            }
        });
        this.myRemoveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AppletConfigurable.this.removeParameter();
            }
        });
    }

    private void removeParameter() {
        int selectedRow = this.myTable.getSelectedRow();
        if (selectedRow < 0 || selectedRow >= this.myTable.getRowCount()) {
            return;
        }
        ArrayList newItems = new ArrayList(this.myParameters.getItems());
        newItems.remove(selectedRow);
        this.myParameters.setItems(newItems);
    }

    private void addParameter() {
        ArrayList<AppletConfiguration.AppletParameter> newItems = new ArrayList<AppletConfiguration.AppletParameter>(this.myParameters.getItems());
        newItems.add(new AppletConfiguration.AppletParameter("newParameter", ""));
        this.myParameters.setItems(newItems);
    }

    private JComboBox getModuleComponent() {
        return (JComboBox)this.myModule.getComponent();
    }

    private TextFieldWithBrowseButton getPolicyFileComponent() {
        return (TextFieldWithBrowseButton)this.myPolicyFile.getComponent();
    }

    private void getConfigurationTo(AppletConfiguration configuration) {
    }

    private List<AppletConfiguration.AppletParameter> cloneParameters(List<AppletConfiguration.AppletParameter> items) {
        ArrayList<AppletConfiguration.AppletParameter> params = new ArrayList<AppletConfiguration.AppletParameter>();
        for (AppletConfiguration.AppletParameter appletParameter : items) {
            params.add(new AppletConfiguration.AppletParameter(appletParameter.getName(), appletParameter.getValue()));
        }
        return params;
    }

    private JTextField getWidthComponent() {
        return this.myWidth;
    }

    private TextFieldWithBrowseButton getClassNameComponent() {
        return this.myClassName;
    }

    private TextFieldWithBrowseButton getHtmlPathComponent() {
        return this.myHtmlFile;
    }

    private String toNull(String s) {
        return (s = s.trim()).length() == 0 ? null : s;
    }

    private String toSystemFormat(String s) {
        return (s = s.trim()).length() == 0 ? null : s.replace(File.separatorChar, '/');
    }

    public void applyEditorTo(AppletConfiguration configuration) {
        this.checkEditorData(configuration);
        this.myTable.stopEditing();
        List<AppletConfiguration.AppletParameter> params = this.cloneParameters(this.myParameters.getItems());
        configuration.setAppletParameters(params);
    }

    public void resetEditorFrom(AppletConfiguration configuration) {
        this.getClassNameComponent().setText(configuration.MAIN_CLASS_NAME);
        String presentableHtmlName = configuration.HTML_FILE_NAME;
        if (presentableHtmlName != null && !StringUtil.startsWithIgnoreCase((String)presentableHtmlName, (String)HTTP_PREFIX)) {
            presentableHtmlName = presentableHtmlName.replace('/', File.separatorChar);
        }
        this.getHtmlPathComponent().setText(presentableHtmlName);
        this.getPolicyFileComponent().setText(configuration.getPolicyFile());
        this.getVMParametersComponent().setText(configuration.VM_PARAMETERS);
        this.getWidthComponent().setText(Integer.toString(configuration.WIDTH));
        this.getHeightComponent().setText(Integer.toString(configuration.HEIGHT));
        (configuration.HTML_USED ? this.myURL : this.myMainClass).setSelected(true);
        this.changePanel();
        AppletConfiguration.AppletParameter[] appletParameters = configuration.getAppletParameters();
        if (appletParameters != null) {
            this.myParameters.setItems(this.cloneParameters(Arrays.asList(appletParameters)));
        }
        this.myModuleSelector.reset(configuration);
        this.myAlternativeJREPanel.init(configuration.ALTERNATIVE_JRE_PATH, configuration.ALTERNATIVE_JRE_PATH_ENABLED);
    }

    private RawCommandLineEditor getVMParametersComponent() {
        return (RawCommandLineEditor)this.myVMParameters.getComponent();
    }

    private JTextField getHeightComponent() {
        return this.myHeight;
    }

    public JComponent createEditor() {
        return this.myWholePanel;
    }

    public void disposeEditor() {
    }

    public void checkEditorData(AppletConfiguration configuration) {
        configuration.MAIN_CLASS_NAME = this.toNull(this.getClassNameComponent().getText());
        configuration.HTML_FILE_NAME = this.toSystemFormat(this.getHtmlPathComponent().getText());
        configuration.VM_PARAMETERS = this.toNull(this.getVMParametersComponent().getText());
        configuration.setPolicyFile(this.getPolicyFileComponent().getText());
        this.myModuleSelector.applyTo(configuration);
        try {
            configuration.WIDTH = Integer.parseInt(this.getWidthComponent().getText());
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        try {
            configuration.HEIGHT = Integer.parseInt(this.getHeightComponent().getText());
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        configuration.HTML_USED = this.myURL.isSelected();
        configuration.ALTERNATIVE_JRE_PATH = this.myAlternativeJREPanel.getPath();
        configuration.ALTERNATIVE_JRE_PATH_ENABLED = this.myAlternativeJREPanel.isPathEnabled();
    }

    private /* synthetic */ void $$$setupUI$$$() {
        AlternativeJREPanel alternativeJREPanel;
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        JLabel jLabel;
        JPanel jPanel;
        JButton jButton;
        JButton jButton2;
        JTextField jTextField;
        JLabel jLabel2;
        JLabel jLabel3;
        JTextField jTextField2;
        JPanel jPanel2;
        TextFieldWithBrowseButton textFieldWithBrowseButton2;
        JLabel jLabel4;
        JPanel jPanel3;
        LabeledComponent labeledComponent;
        LabeledComponent labeledComponent2;
        LabeledComponent labeledComponent3;
        JRadioButton jRadioButton;
        JRadioButton jRadioButton2;
        JPanel jPanel4;
        this.myWholePanel = jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(7, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.add((Component)jPanel5, new GridConstraints(0, 0, 1, 1, 0, 1, 0, 1, null, null, null));
        this.myMainClass = jRadioButton2 = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton2, ResourceBundle.getBundle("messages/ExecutionBundle").getString("applet.configuration.applet.class.label"));
        jRadioButton2.setSelected(true);
        jPanel5.add((Component)jRadioButton2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myURL = jRadioButton = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton, ResourceBundle.getBundle("messages/ExecutionBundle").getString("applet.configuration.url.label"));
        jPanel5.add((Component)jRadioButton, new GridConstraints(0, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myPolicyFile = labeledComponent3 = new LabeledComponent();
        labeledComponent3.setText(ResourceBundle.getBundle("messages/ExecutionBundle").getString("applet.configuration.policy.file.label"));
        labeledComponent3.setLabelInsets(new Insets(0, 0, 5, 0));
        labeledComponent3.setComponentClass("com.intellij.openapi.ui.TextFieldWithBrowseButton");
        jPanel4.add((Component)labeledComponent3, new GridConstraints(2, 0, 1, 1, 1, 1, 3, 0, null, null, null));
        this.myVMParameters = labeledComponent2 = new LabeledComponent();
        labeledComponent2.setText(ResourceBundle.getBundle("messages/ExecutionBundle").getString("applet.configuration.vm.parameters.for.appletviewer.label"));
        labeledComponent2.setLabelInsets(new Insets(5, 0, 2, 0));
        labeledComponent2.setComponentClass("com.intellij.ui.RawCommandLineEditor");
        jPanel4.add((Component)labeledComponent2, new GridConstraints(3, 0, 1, 1, 1, 1, 3, 0, null, new Dimension(400, -1), null));
        this.myModule = labeledComponent = new LabeledComponent();
        labeledComponent.setText(ResourceBundle.getBundle("messages/ExecutionBundle").getString("applet.configuration.use.classpath.and.jdk.of.module.label"));
        labeledComponent.setLabelInsets(new Insets(5, 0, 5, 0));
        labeledComponent.setComponentClass("javax.swing.JComboBox");
        jPanel4.add((Component)labeledComponent, new GridConstraints(4, 0, 1, 1, 1, 1, 3, 0, null, null, null));
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.add((Component)jPanel6, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myHTMLOptions = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(5, 5, 5, 5), 5, -1, false, false));
        jPanel6.add((Component)jPanel3, new GridConstraints(0, 0, 1, 1, 1, 1, 3, 7, null, null, null));
        jPanel3.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), ResourceBundle.getBundle("messages/ExecutionBundle").getString("applet.configuration.url.border"), 0, 0, null, null));
        this.myHtmlFileLabel = jLabel4 = new JLabel();
        this.$$$loadLabelText$$$(jLabel4, ResourceBundle.getBundle("messages/ExecutionBundle").getString("applet.configuration.url.html.file.label"));
        jPanel3.add((Component)jLabel4, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myHtmlFile = textFieldWithBrowseButton2 = new TextFieldWithBrowseButton();
        textFieldWithBrowseButton2.setText("");
        jPanel3.add((Component)textFieldWithBrowseButton2, new GridConstraints(0, 1, 1, 1, 8, 3, 3, 0, null, null, null));
        this.myClassOptions = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(4, 1, new Insets(5, 5, 5, 5), -1, 7, false, false));
        ((Component)jPanel2).setEnabled(true);
        jPanel6.add((Component)jPanel2, new GridConstraints(1, 0, 1, 1, 1, 1, 3, 0, null, null, null));
        jPanel2.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), ResourceBundle.getBundle("messages/ExecutionBundle").getString("applet.configuration.applet.class.border"), 0, 0, null, null));
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout((LayoutManager)new GridLayoutManager(1, 4, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel7, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 1, null, null, null));
        this.myWidth = jTextField2 = new JTextField();
        jTextField2.setText("");
        jPanel7.add((Component)jTextField2, new GridConstraints(0, 1, 1, 1, 8, 0, 0, 0, new Dimension(50, -1), null, null));
        this.myWidthLabel = jLabel3 = new JLabel();
        this.$$$loadLabelText$$$(jLabel3, ResourceBundle.getBundle("messages/ExecutionBundle").getString("applet.configuration.width.label"));
        jPanel7.add((Component)jLabel3, new GridConstraints(0, 0, 1, 1, 4, 0, 0, 0, new Dimension(52, -1), null, null));
        this.myHeightLabel = jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, ResourceBundle.getBundle("messages/ExecutionBundle").getString("applet.configuration.height.label"));
        jPanel7.add((Component)jLabel2, new GridConstraints(0, 2, 1, 1, 4, 0, 0, 0, null, null, null));
        this.myHeight = jTextField = new JTextField();
        jTextField.setText("");
        jPanel7.add((Component)jTextField, new GridConstraints(0, 3, 1, 1, 8, 0, 3, 0, new Dimension(50, -1), null, null));
        JPanel jPanel8 = new JPanel();
        jPanel8.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel8, new GridConstraints(3, 0, 1, 1, 1, 1, 3, 0, null, null, null));
        JPanel jPanel9 = new JPanel();
        jPanel9.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel8.add((Component)jPanel9, new GridConstraints(0, 1, 1, 1, 0, 3, 1, 3, null, null, null));
        this.myAddButton = jButton2 = new JButton();
        this.$$$loadButtonText$$$(jButton2, ResourceBundle.getBundle("messages/ExecutionBundle").getString("button.add"));
        jPanel9.add((Component)jButton2, new GridConstraints(0, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        this.myRemoveButton = jButton = new JButton();
        this.$$$loadButtonText$$$(jButton, ResourceBundle.getBundle("messages/ExecutionBundle").getString("button.remove"));
        jPanel9.add((Component)jButton, new GridConstraints(1, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel9.add((Component)spacer, new GridConstraints(2, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myTablePlace = jPanel = new JPanel();
        jPanel8.add((Component)jPanel, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, new Dimension(-1, 100), null));
        JPanel jPanel10 = new JPanel();
        jPanel10.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, 5, false, false));
        jPanel2.add((Component)jPanel10, new GridConstraints(0, 0, 1, 1, 1, 1, 3, 0, null, null, null));
        this.myClassNameLabel = jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("messages/ExecutionBundle").getString("applet.configuration.applet.class.label"));
        jPanel10.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 4, 0, 0, 0, null, null, null));
        this.myClassName = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        textFieldWithBrowseButton.setText("");
        jPanel10.add((Component)textFieldWithBrowseButton, new GridConstraints(0, 1, 1, 1, 8, 3, 3, 0, null, null, null));
        JPanel jPanel11 = new JPanel();
        jPanel11.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel11, new GridConstraints(2, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JLabel jLabel5 = new JLabel();
        this.$$$loadLabelText$$$(jLabel5, ResourceBundle.getBundle("messages/ExecutionBundle").getString("applet.configuration.applet.parameters.label"));
        jPanel11.add((Component)jLabel5, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JPanel jPanel12 = new JPanel();
        jPanel11.add((Component)jPanel12, new GridConstraints(0, 1, 1, 1, 0, 3, 3, 3, null, null, new Dimension(-1, 1)));
        jPanel12.setBorder(BorderFactory.createTitledBorder(BorderFactory.createRaisedBevelBorder(), null, 0, 0, null, null));
        Spacer spacer2 = new Spacer();
        jPanel4.add((Component)spacer2, new GridConstraints(6, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myAlternativeJREPanel = alternativeJREPanel = new AlternativeJREPanel();
        jPanel4.add((Component)alternativeJREPanel, new GridConstraints(5, 0, 1, 1, 0, 1, 3, 3, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myWholePanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    private static abstract class MyColumnInfo
    extends ColumnInfo<AppletConfiguration.AppletParameter, String> {
        public MyColumnInfo(String name) {
            super(name);
        }

        public Comparator<AppletConfiguration.AppletParameter> getComparator() {
            return new Comparator<AppletConfiguration.AppletParameter>(){

                @Override
                public int compare(AppletConfiguration.AppletParameter parameter1, AppletConfiguration.AppletParameter parameter2) {
                    return ((String)MyColumnInfo.this.valueOf(parameter1)).compareTo((String)MyColumnInfo.this.valueOf(parameter2));
                }
            };
        }

        public TableCellEditor getEditor(AppletConfiguration.AppletParameter item) {
            JTextField textField = new JTextField();
            textField.setBorder(BorderFactory.createLineBorder(Color.BLACK));
            return new DefaultCellEditor(textField);
        }

        public boolean isCellEditable(AppletConfiguration.AppletParameter appletParameter) {
            return true;
        }
    }
}

