/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui;

import com.intellij.CommonBundle;
import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.DebuggerManagerEx;
import com.intellij.debugger.engine.StackFrameContext;
import com.intellij.debugger.engine.evaluation.CodeFragmentFactory;
import com.intellij.debugger.engine.evaluation.DefaultCodeFragmentFactory;
import com.intellij.debugger.engine.evaluation.TextWithImports;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.impl.DebuggerContextListener;
import com.intellij.debugger.impl.DebuggerSession;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.impl.PositionUtil;
import com.intellij.debugger.ui.DebuggerEditorImpl;
import com.intellij.debugger.ui.impl.WatchDebuggerTree;
import com.intellij.debugger.ui.impl.WatchPanel;
import com.intellij.debugger.ui.impl.watch.DebuggerTreeNodeImpl;
import com.intellij.debugger.ui.impl.watch.EvaluationDescriptor;
import com.intellij.debugger.ui.impl.watch.NodeDescriptorImpl;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionPopupMenu;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.psi.PsiElement;
import com.intellij.util.EventDispatcher;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.List;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.tree.TreeModel;

public abstract class EvaluationDialog
extends DialogWrapper {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.debugger.ui.EvaluationDialog");
    private final MyEvaluationPanel myEvaluationPanel;
    private final ComboBox myCbFactories;
    private final Project myProject;
    private final DebuggerContextListener myContextListener;
    private final DebuggerEditorImpl myEditor;
    private final List<Runnable> myDisposeRunnables = new ArrayList<Runnable>();
    private final List<CodeFragmentFactory> myFactories = new ArrayList<CodeFragmentFactory>();

    public EvaluationDialog(Project project, TextWithImports text) {
        super(project, true);
        this.myProject = project;
        this.setModal(false);
        this.setCancelButtonText(CommonBundle.message((String)"button.close", (Object[])new Object[0]));
        this.setOKButtonText(DebuggerBundle.message((String)"button.evaluate", (Object[])new Object[0]));
        this.myEvaluationPanel = new MyEvaluationPanel(this.myProject);
        this.myCbFactories = new ComboBox((ComboBoxModel)new MyComboBoxModel(), 150);
        this.myCbFactories.setRenderer((ListCellRenderer)new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                JLabel component = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                component.setText(((CodeFragmentFactory)value).getFileType().getLanguage().getID());
                return component;
            }
        });
        this.myCbFactories.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                EvaluationDialog.this.myEditor.setFactory((CodeFragmentFactory)EvaluationDialog.this.myCbFactories.getSelectedItem());
                EvaluationDialog.this.myEditor.revalidate();
            }
        });
        CodeFragmentFactory factory = (CodeFragmentFactory)this.myCbFactories.getSelectedItem();
        if (factory == null) {
            factory = DefaultCodeFragmentFactory.getInstance();
        }
        this.myEditor = this.createEditor(factory);
        this.setDebuggerContext(this.getDebuggerContext());
        this.initDialogData(text);
        this.myContextListener = new DebuggerContextListener(){

            @Override
            public void changeEvent(DebuggerContextImpl newContext, int event) {
                boolean close = true;
                for (DebuggerSession session : DebuggerManagerEx.getInstanceEx(EvaluationDialog.this.myProject).getSessions()) {
                    if (session.isStopped()) continue;
                    close = false;
                    break;
                }
                if (close) {
                    EvaluationDialog.this.close(1);
                } else {
                    EvaluationDialog.this.setDebuggerContext(newContext);
                }
            }
        };
        DebuggerManagerEx.getInstanceEx(this.myProject).getContextManager().addListener(this.myContextListener);
        this.setHorizontalStretch(1.0f);
        this.setVerticalStretch(1.0f);
    }

    protected void doOKAction() {
        if (this.isOKActionEnabled()) {
            this.doEvaluate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doEvaluate() {
        if (this.myEditor == null || this.myEvaluationPanel == null) {
            return;
        }
        this.myEvaluationPanel.clear();
        TextWithImports codeToEvaluate = this.getCodeToEvaluate();
        if (codeToEvaluate == null) {
            return;
        }
        try {
            this.setOKActionEnabled(false);
            NodeDescriptorImpl descriptor = this.myEvaluationPanel.getWatchTree().addWatch(codeToEvaluate).getDescriptor();
            if (descriptor instanceof EvaluationDescriptor) {
                CodeFragmentFactory factory = ((MyComboBoxModel)this.myCbFactories.getModel()).getSelectedItem();
                LOG.assertTrue(factory != null);
                ((EvaluationDescriptor)descriptor).setCodeFragmentFactory(factory);
            }
            this.myEvaluationPanel.getWatchTree().rebuild(this.getDebuggerContext());
            descriptor.myIsExpanded = true;
        }
        finally {
            this.setOKActionEnabled(true);
        }
        this.getEditor().addRecent(this.getCodeToEvaluate());
        this.myEvaluationPanel.getContextManager().getContext().getDebuggerSession().refresh(true);
    }

    protected TextWithImports getCodeToEvaluate() {
        TextWithImports text = this.getEditor().getText();
        String s = text.getText();
        if (s != null) {
            s = s.trim();
        }
        if ("".equals(s)) {
            return null;
        }
        return text;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myEditor.getPreferredFocusedComponent();
    }

    protected String getDimensionServiceKey() {
        return "#com.intellij.debugger.ui.EvaluationDialog2";
    }

    protected void addDisposeRunnable(Runnable runnable) {
        this.myDisposeRunnables.add(runnable);
    }

    public void dispose() {
        for (Runnable runnable : this.myDisposeRunnables) {
            runnable.run();
        }
        this.myDisposeRunnables.clear();
        this.myEditor.dispose();
        DebuggerManagerEx.getInstanceEx(this.myProject).getContextManager().removeListener(this.myContextListener);
        this.myEvaluationPanel.dispose();
        super.dispose();
    }

    protected void setDebuggerContext(DebuggerContextImpl context) {
        PsiElement contextElement = PositionUtil.getContextElement((StackFrameContext)context);
        this.myFactories.clear();
        this.myFactories.addAll(DebuggerUtilsEx.getCodeFragmentFactories(contextElement));
        ((MyComboBoxModel)this.myCbFactories.getModel()).update();
        this.myCbFactories.setVisible(this.myCbFactories.getItemCount() > 1);
        this.myEditor.setContext(contextElement);
    }

    protected PsiElement getContext() {
        return this.myEditor.getContext();
    }

    protected void initDialogData(TextWithImports text) {
        this.getEditor().setText(text);
        this.myEvaluationPanel.clear();
    }

    public DebuggerContextImpl getDebuggerContext() {
        return DebuggerManagerEx.getInstanceEx(this.myProject).getContext();
    }

    public DebuggerEditorImpl getEditor() {
        return this.myEditor;
    }

    protected Component getCodeFragmentFactoryChooserComponent() {
        return this.myCbFactories;
    }

    protected abstract DebuggerEditorImpl createEditor(CodeFragmentFactory var1);

    protected MyEvaluationPanel getEvaluationPanel() {
        return this.myEvaluationPanel;
    }

    public Project getProject() {
        return this.myProject;
    }

    private class MyComboBoxModel
    implements ComboBoxModel {
        private CodeFragmentFactory mySelectedItem = null;
        private final EventDispatcher<ListDataListener> myDispatcher = EventDispatcher.create(ListDataListener.class);

        private MyComboBoxModel() {
        }

        @Override
        public void setSelectedItem(Object anItem) {
            this.mySelectedItem = anItem instanceof CodeFragmentFactory && EvaluationDialog.this.myFactories.contains(anItem) ? (CodeFragmentFactory)anItem : (EvaluationDialog.this.myFactories.size() > 0 ? (CodeFragmentFactory)EvaluationDialog.this.myFactories.get(0) : null);
        }

        public CodeFragmentFactory getSelectedItem() {
            return this.mySelectedItem;
        }

        @Override
        public int getSize() {
            return EvaluationDialog.this.myFactories.size();
        }

        @Override
        public CodeFragmentFactory getElementAt(int index) {
            return (CodeFragmentFactory)EvaluationDialog.this.myFactories.get(index);
        }

        @Override
        public void addListDataListener(ListDataListener l) {
            this.myDispatcher.addListener((EventListener)l);
        }

        @Override
        public void removeListDataListener(ListDataListener l) {
            this.myDispatcher.removeListener((EventListener)l);
        }

        void update() {
            this.setSelectedItem(this.mySelectedItem);
            ((ListDataListener)this.myDispatcher.getMulticaster()).contentsChanged(new ListDataEvent(this, 0, -1, -1));
        }
    }

    protected class MyEvaluationPanel
    extends WatchPanel {
        public MyEvaluationPanel(Project project) {
            super(project, DebuggerManagerEx.getInstanceEx(project).getContextManager());
            final WatchDebuggerTree watchTree = this.getWatchTree();
            final AnAction setValueAction = ActionManager.getInstance().getAction("Debugger.SetValue");
            setValueAction.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(KeyStroke.getKeyStroke(113, 0)), (JComponent)((Object)watchTree));
            this.registerDisposable(new Disposable(){

                public void dispose() {
                    setValueAction.unregisterCustomShortcutSet((JComponent)((Object)watchTree));
                }
            });
            this.setUpdateEnabled(true);
        }

        @Override
        protected ActionPopupMenu createPopupMenu() {
            ActionGroup group = (ActionGroup)ActionManager.getInstance().getAction("Debugger.EvaluationDialogPopup");
            return ActionManager.getInstance().createActionPopupMenu("Debugger.EvaluationDialogPopup", group);
        }

        @Override
        protected void changeEvent(DebuggerContextImpl newContext, int event) {
            if (event == 7 || event == 11) {
                TreeModel treeModel = this.getTree().getModel();
                this.updateTree(treeModel, (DebuggerTreeNodeImpl)treeModel.getRoot());
            }
        }

        private void updateTree(TreeModel model, DebuggerTreeNodeImpl node) {
            if (node == null) {
                return;
            }
            if (node.getDescriptor().myIsExpanded) {
                int count = model.getChildCount(node);
                for (int idx = 0; idx < count; ++idx) {
                    DebuggerTreeNodeImpl child = (DebuggerTreeNodeImpl)model.getChild(node, idx);
                    this.updateTree(model, child);
                }
            }
            node.labelChanged();
        }
    }
}

