/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.concurrency;

import com.intellij.openapi.application.RuntimeInterruptedException;
import com.intellij.openapi.diagnostic.Logger;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class PrioritizedFutureTask<T>
extends FutureTask<T>
implements Comparable<PrioritizedFutureTask> {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.concurrency.PrioritizedFutureTask");
    private final long myJobIndex;
    private final int myTaskIndex;
    private final int myPriority;
    private final boolean myParentThreadHasReadAccess;
    private final boolean myReportExceptions;
    private final Lock myLock;
    private volatile Condition myDoneCondition;

    public PrioritizedFutureTask(Callable<T> callable, long jobIndex, int taskIndex, int priority, boolean parentThreadHasReadAccess, boolean reportExceptions) {
        super(callable);
        this.myJobIndex = jobIndex;
        this.myTaskIndex = taskIndex;
        this.myPriority = priority;
        this.myParentThreadHasReadAccess = parentThreadHasReadAccess;
        this.myReportExceptions = reportExceptions;
        this.myLock = new ReentrantLock();
    }

    public boolean isParentThreadHasReadAccess() {
        return this.myParentThreadHasReadAccess;
    }

    @Override
    public int compareTo(PrioritizedFutureTask o) {
        if (this.getPriority() != o.getPriority()) {
            return this.getPriority() - o.getPriority();
        }
        if (this.getTaskIndex() != o.getTaskIndex()) {
            return this.getTaskIndex() - o.getTaskIndex();
        }
        if (this.getJobIndex() != o.getJobIndex()) {
            return this.getJobIndex() < o.getJobIndex() ? -1 : 1;
        }
        return 0;
    }

    public long getJobIndex() {
        return this.myJobIndex;
    }

    public int getTaskIndex() {
        return this.myTaskIndex;
    }

    public int getPriority() {
        return this.myPriority;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void signalStarted() {
        this.myLock.lock();
        try {
            this.myDoneCondition = this.myLock.newCondition();
        }
        finally {
            this.myLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void signalDone() {
        this.myLock.lock();
        try {
            this.myDoneCondition.signalAll();
            this.myDoneCondition = null;
        }
        finally {
            this.myLock.unlock();
        }
    }

    public void awaitTermination() {
        this.myLock.lock();
        try {
            if (this.myDoneCondition == null) {
                return;
            }
            this.myDoneCondition.await();
        }
        catch (InterruptedException e) {
            throw new RuntimeInterruptedException(e);
        }
        finally {
            this.myLock.unlock();
        }
    }

    @Override
    protected void done() {
        if (this.myReportExceptions) {
            try {
                this.get();
            }
            catch (CancellationException e) {
            }
            catch (InterruptedException e) {
                LOG.error((Throwable)e);
            }
            catch (ExecutionException e) {
                LOG.error((Throwable)e);
            }
        }
    }
}

