/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.impl.javaCompiler.jikes;

import com.intellij.compiler.impl.javaCompiler.jikes.JikesSettings;
import com.intellij.compiler.options.ComparingUtils;
import com.intellij.openapi.compiler.CompilerBundle;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.RawCommandLineEditor;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class JikesConfigurable
implements Configurable {
    private JPanel myPanel;
    private JCheckBox myCbDebuggingInfo;
    private JCheckBox myCbDeprecation;
    private JCheckBox myCbGenerateNoWarnings;
    private RawCommandLineEditor myAdditionalOptionsField;
    private JTextField myPathField;
    private JButton myJikesPathFieldBrowseButton;
    private final JikesSettings myJikesSettings;

    public JikesConfigurable(JikesSettings jikesSettings) {
        this.myJikesSettings = jikesSettings;
        this.$$$setupUI$$$();
        this.myJikesPathFieldBrowseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FileChooserDescriptor descriptor = FileChooserDescriptorFactory.createSingleFileNoJarsDescriptor();
                VirtualFile[] files = FileChooser.chooseFiles((Component)JikesConfigurable.this.myPathField, (FileChooserDescriptor)descriptor);
                if (files.length != 0) {
                    JikesConfigurable.this.myPathField.setText(files[0].getPath().replace('/', File.separatorChar));
                }
            }
        });
        this.myAdditionalOptionsField.setDialogCaption(CompilerBundle.message((String)"java.compiler.option.additional.command.line.parameters", (Object[])new Object[0]));
    }

    public String getDisplayName() {
        return null;
    }

    public Icon getIcon() {
        return null;
    }

    public String getHelpTopic() {
        return null;
    }

    public JComponent createComponent() {
        return this.myPanel;
    }

    public boolean isModified() {
        boolean isModified = false;
        isModified |= ComparingUtils.isModified(this.myPathField, this.myJikesSettings.JIKES_PATH.replace('/', File.separatorChar));
        isModified |= ComparingUtils.isModified(this.myCbDeprecation, this.myJikesSettings.DEPRECATION);
        isModified |= ComparingUtils.isModified(this.myCbDebuggingInfo, this.myJikesSettings.DEBUGGING_INFO);
        isModified |= ComparingUtils.isModified(this.myCbGenerateNoWarnings, this.myJikesSettings.GENERATE_NO_WARNINGS);
        return isModified |= ComparingUtils.isModified(this.myAdditionalOptionsField, this.myJikesSettings.ADDITIONAL_OPTIONS_STRING);
    }

    public void apply() throws ConfigurationException {
        this.myJikesSettings.JIKES_PATH = this.myPathField.getText().trim().replace(File.separatorChar, '/');
        this.myJikesSettings.DEPRECATION = this.myCbDeprecation.isSelected();
        this.myJikesSettings.DEBUGGING_INFO = this.myCbDebuggingInfo.isSelected();
        this.myJikesSettings.GENERATE_NO_WARNINGS = this.myCbGenerateNoWarnings.isSelected();
        this.myJikesSettings.ADDITIONAL_OPTIONS_STRING = this.myAdditionalOptionsField.getText();
    }

    public void reset() {
        this.myPathField.setText(this.myJikesSettings.JIKES_PATH.replace('/', File.separatorChar));
        this.myCbDeprecation.setSelected(this.myJikesSettings.DEPRECATION);
        this.myCbDebuggingInfo.setSelected(this.myJikesSettings.DEBUGGING_INFO);
        this.myCbGenerateNoWarnings.setSelected(this.myJikesSettings.GENERATE_NO_WARNINGS);
        this.myAdditionalOptionsField.setText(this.myJikesSettings.ADDITIONAL_OPTIONS_STRING);
    }

    public void disposeUIResources() {
    }

    private /* synthetic */ void $$$setupUI$$$() {
        RawCommandLineEditor rawCommandLineEditor;
        JButton jButton;
        JTextField jTextField;
        JCheckBox jCheckBox;
        JCheckBox jCheckBox2;
        JCheckBox jCheckBox3;
        JPanel jPanel;
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(6, 1, new Insets(0, 0, 0, 0), -1, 0, false, false));
        jPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), ResourceBundle.getBundle("messages/CompilerBundle").getString("jikes.options.group.title"), 0, 0, null, null));
        this.myCbDebuggingInfo = jCheckBox3 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox3, ResourceBundle.getBundle("messages/CompilerBundle").getString("java.compiler.option.generate.debugging.info"));
        jCheckBox3.setSelected(true);
        jCheckBox3.setMargin(new Insets(5, 2, 2, 2));
        jPanel.add((Component)jCheckBox3, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myCbGenerateNoWarnings = jCheckBox2 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox2, ResourceBundle.getBundle("messages/CompilerBundle").getString("java.compiler.option.generate.no.warnings"));
        jCheckBox2.setSelected(true);
        jCheckBox2.setMargin(new Insets(2, 2, 2, 3));
        jPanel.add((Component)jCheckBox2, new GridConstraints(2, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myCbDeprecation = jCheckBox = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox, ResourceBundle.getBundle("messages/CompilerBundle").getString("java.compiler.option.report.deprecated"));
        jCheckBox.setSelected(true);
        jCheckBox.setMargin(new Insets(2, 2, 5, 2));
        jPanel.add((Component)jCheckBox, new GridConstraints(3, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(5, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), 5, -1, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(0, 0, 1, 1, 1, 1, 3, 0, null, null, null));
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("messages/CompilerBundle").getString("jikes.option.path.to.executable"));
        jPanel2.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), 0, -1, false, false));
        jPanel2.add((Component)jPanel3, new GridConstraints(0, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myPathField = jTextField = new JTextField();
        jPanel3.add((Component)jTextField, new GridConstraints(0, 0, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.myJikesPathFieldBrowseButton = jButton = new JButton();
        jButton.setMargin(new Insets(0, 0, 0, 0));
        jButton.setText("...");
        jPanel3.add((Component)jButton, new GridConstraints(0, 1, 1, 1, 0, 1, 3, 0, null, new Dimension(21, 21), null));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), 5, -1, false, false));
        jPanel.add((Component)jPanel4, new GridConstraints(4, 0, 1, 1, 1, 1, 3, 0, null, null, null));
        JLabel jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, ResourceBundle.getBundle("messages/CompilerBundle").getString("java.compiler.option.additional.command.line.parameters"));
        jPanel4.add((Component)jLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myAdditionalOptionsField = rawCommandLineEditor = new RawCommandLineEditor();
        jPanel4.add((Component)rawCommandLineEditor, new GridConstraints(0, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

