/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.classParsing;

import com.intellij.compiler.SymbolTable;
import com.intellij.compiler.classParsing.AnnotationConstantValue;
import com.intellij.compiler.classParsing.ConstantValue;
import com.intellij.compiler.classParsing.MemberInfo;
import com.intellij.compiler.classParsing.MemberInfoExternalizer;
import com.intellij.compiler.make.CacheCorruptedException;
import com.intellij.compiler.make.CacheUtils;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.ArrayUtil;
import com.intellij.util.cls.ClsUtil;
import gnu.trove.TIntHashSet;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import org.jetbrains.annotations.NonNls;

public class MethodInfo
extends MemberInfo {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.compiler.classParsing.MethodInfo");
    private static final int[] EXCEPTION_INFO_UNAVAILABLE = ArrayUtil.EMPTY_INT_ARRAY;
    public static final MethodInfo[] EMPTY_ARRAY = new MethodInfo[0];
    private final int[] myThrownExceptions;
    private String mySignature = null;
    private String[] myParameterDescriptors = null;
    private String myReturnTypeSignature = null;
    private final boolean myIsConstructor;
    private final AnnotationConstantValue[][] myRuntimeVisibleParameterAnnotations;
    private final AnnotationConstantValue[][] myRuntimeInvisibleParameterAnnotations;
    private final ConstantValue myAnnotationDefault;

    public MethodInfo(int name, int descriptor, boolean isConstructor) {
        super(name, descriptor);
        this.myIsConstructor = isConstructor;
        this.myThrownExceptions = EXCEPTION_INFO_UNAVAILABLE;
        this.myRuntimeVisibleParameterAnnotations = AnnotationConstantValue.EMPTY_ARRAY_ARRAY;
        this.myRuntimeInvisibleParameterAnnotations = AnnotationConstantValue.EMPTY_ARRAY_ARRAY;
        this.myAnnotationDefault = ConstantValue.EMPTY_CONSTANT_VALUE;
    }

    public MethodInfo(int name, int descriptor, int genericSignature, int flags, int[] exceptions, boolean isConstructor, AnnotationConstantValue[] runtimeVisibleAnnotations, AnnotationConstantValue[] runtimeInvisibleAnnotations, AnnotationConstantValue[][] runtimeVisibleParameterAnnotations, AnnotationConstantValue[][] runtimeInvisibleParameterAnnotations, ConstantValue annotationDefault) {
        super(name, descriptor, genericSignature, flags, runtimeVisibleAnnotations, runtimeInvisibleAnnotations);
        this.myThrownExceptions = exceptions != null ? exceptions : ArrayUtil.EMPTY_INT_ARRAY;
        this.myIsConstructor = isConstructor;
        this.myRuntimeVisibleParameterAnnotations = runtimeVisibleParameterAnnotations == null ? AnnotationConstantValue.EMPTY_ARRAY_ARRAY : runtimeVisibleParameterAnnotations;
        this.myRuntimeInvisibleParameterAnnotations = runtimeInvisibleParameterAnnotations == null ? AnnotationConstantValue.EMPTY_ARRAY_ARRAY : runtimeInvisibleParameterAnnotations;
        this.myAnnotationDefault = annotationDefault;
    }

    public MethodInfo(DataInput in) throws IOException {
        super(in);
        this.myIsConstructor = in.readBoolean();
        int count = in.readInt();
        if (count == -1) {
            this.myThrownExceptions = EXCEPTION_INFO_UNAVAILABLE;
        } else {
            this.myThrownExceptions = ArrayUtil.newIntArray((int)count);
            for (int idx = 0; idx < count; ++idx) {
                this.myThrownExceptions[idx] = in.readInt();
            }
        }
        this.myRuntimeVisibleParameterAnnotations = this.loadParameterAnnotations(in);
        this.myRuntimeInvisibleParameterAnnotations = this.loadParameterAnnotations(in);
        this.myAnnotationDefault = MemberInfoExternalizer.loadConstantValue(in);
    }

    @Override
    public void save(DataOutput out) throws IOException {
        super.save(out);
        out.writeBoolean(this.myIsConstructor);
        if (this.isExceptionInfoAvailable()) {
            out.writeInt(this.myThrownExceptions.length);
        } else {
            out.writeInt(-1);
        }
        for (int thrownException : this.myThrownExceptions) {
            out.writeInt(thrownException);
        }
        this.saveParameterAnnotations(out, this.myRuntimeVisibleParameterAnnotations);
        this.saveParameterAnnotations(out, this.myRuntimeInvisibleParameterAnnotations);
        MemberInfoExternalizer.saveConstantValue(out, this.myAnnotationDefault);
    }

    private boolean isExceptionInfoAvailable() {
        return this.myThrownExceptions != EXCEPTION_INFO_UNAVAILABLE;
    }

    public boolean areExceptionsEqual(MethodInfo info) {
        if (this.myThrownExceptions.length != info.myThrownExceptions.length) {
            return false;
        }
        if (this.myThrownExceptions.length != 0) {
            TIntHashSet exceptionsSet = new TIntHashSet();
            for (int thrownException : this.myThrownExceptions) {
                exceptionsSet.add(thrownException);
            }
            for (int exception : info.myThrownExceptions) {
                if (exceptionsSet.contains(exception)) continue;
                return false;
            }
        }
        return true;
    }

    public int[] getThrownExceptions() {
        return this.myThrownExceptions;
    }

    public String getDescriptor(SymbolTable symbolTable) throws CacheCorruptedException {
        if (this.mySignature == null) {
            String descriptor = symbolTable.getSymbol(this.getDescriptor());
            String name = symbolTable.getSymbol(this.getName());
            this.mySignature = CacheUtils.getMethodSignature(name, descriptor);
        }
        return this.mySignature;
    }

    public String getReturnTypeDescriptor(SymbolTable symbolTable) throws CacheCorruptedException {
        if (this.myReturnTypeSignature == null) {
            String descriptor = symbolTable.getSymbol(this.getDescriptor());
            this.myReturnTypeSignature = descriptor.substring(descriptor.indexOf(41) + 1, descriptor.length());
        }
        return this.myReturnTypeSignature;
    }

    public String[] getParameterDescriptors(SymbolTable symbolTable) throws CacheCorruptedException {
        if (this.myParameterDescriptors == null) {
            String descriptor = symbolTable.getSymbol(this.getDescriptor());
            int endIndex = descriptor.indexOf(41);
            if (endIndex <= 0) {
                LOG.error("Corrupted method descriptor: " + descriptor);
            }
            this.myParameterDescriptors = this.parseParameterDescriptors(descriptor.substring(1, endIndex));
        }
        return this.myParameterDescriptors;
    }

    public boolean isAbstract() {
        return ClsUtil.isAbstract((int)this.getFlags());
    }

    public boolean isConstructor() {
        return this.myIsConstructor;
    }

    private String[] parseParameterDescriptors(String signature) {
        ArrayList<String> list = new ArrayList<String>();
        String paramSignature = this.parseFieldType(signature);
        while (paramSignature != null && !"".equals(paramSignature)) {
            list.add(paramSignature);
            signature = signature.substring(paramSignature.length());
            paramSignature = this.parseFieldType(signature);
        }
        return ArrayUtil.toStringArray(list);
    }

    @NonNls
    private String parseFieldType(@NonNls String signature) {
        if (signature.length() == 0) {
            return null;
        }
        if (signature.charAt(0) == 'B') {
            return "B";
        }
        if (signature.charAt(0) == 'C') {
            return "C";
        }
        if (signature.charAt(0) == 'D') {
            return "D";
        }
        if (signature.charAt(0) == 'F') {
            return "F";
        }
        if (signature.charAt(0) == 'I') {
            return "I";
        }
        if (signature.charAt(0) == 'J') {
            return "J";
        }
        if (signature.charAt(0) == 'S') {
            return "S";
        }
        if (signature.charAt(0) == 'Z') {
            return "Z";
        }
        if (signature.charAt(0) == 'L') {
            return signature.substring(0, signature.indexOf(";") + 1);
        }
        if (signature.charAt(0) == '[') {
            String s = this.parseFieldType(signature.substring(1));
            return s != null ? "[" + s : null;
        }
        return null;
    }

    public AnnotationConstantValue[][] getRuntimeVisibleParameterAnnotations() {
        return this.myRuntimeVisibleParameterAnnotations;
    }

    public AnnotationConstantValue[][] getRuntimeInvisibleParameterAnnotations() {
        return this.myRuntimeInvisibleParameterAnnotations;
    }

    public String toString() {
        return this.mySignature;
    }

    private AnnotationConstantValue[][] loadParameterAnnotations(DataInput in) throws IOException {
        int size = in.readInt();
        if (size == 0) {
            return AnnotationConstantValue.EMPTY_ARRAY_ARRAY;
        }
        AnnotationConstantValue[][] paramAnnotations = new AnnotationConstantValue[size][];
        for (int idx = 0; idx < size; ++idx) {
            paramAnnotations[idx] = this.loadAnnotations(in);
        }
        return paramAnnotations;
    }

    private void saveParameterAnnotations(DataOutput out, AnnotationConstantValue[][] parameterAnnotations) throws IOException {
        out.writeInt(parameterAnnotations.length);
        for (AnnotationConstantValue[] parameterAnnotation : parameterAnnotations) {
            this.saveAnnotations(out, parameterAnnotation);
        }
    }

    public ConstantValue getAnnotationDefault() {
        return this.myAnnotationDefault;
    }
}

