/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.reference;

import com.intellij.codeInspection.reference.RefClass;
import com.intellij.codeInspection.reference.RefClassImpl;
import com.intellij.codeInspection.reference.RefElementImpl;
import com.intellij.codeInspection.reference.RefField;
import com.intellij.codeInspection.reference.RefJavaElement;
import com.intellij.codeInspection.reference.RefJavaElementImpl;
import com.intellij.codeInspection.reference.RefJavaUtil;
import com.intellij.codeInspection.reference.RefJavaVisitor;
import com.intellij.codeInspection.reference.RefManager;
import com.intellij.codeInspection.reference.RefVisitor;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.ClassUtil;
import com.intellij.psi.util.PsiFormatUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import org.jetbrains.annotations.Nullable;

public class RefFieldImpl
extends RefJavaElementImpl
implements RefField {
    private static final int USED_FOR_READING_MASK = 65536;
    private static final int USED_FOR_WRITING_MASK = 131072;
    private static final int ASSIGNED_ONLY_IN_INITIALIZER = 262144;

    RefFieldImpl(PsiField field, RefManager manager) {
        this((RefClass)manager.getReference((PsiElement)field.getContainingClass()), field, manager);
    }

    RefFieldImpl(RefClass ownerClass, PsiField field, RefManager manager) {
        super((PsiModifierListOwner)field, manager);
        ((RefClassImpl)ownerClass).add(this);
        PsiClass psiClass = field.getContainingClass();
        if (psiClass.isInterface()) {
            this.setIsStatic(true);
            this.setIsFinal(true);
        }
    }

    public PsiField getElement() {
        return (PsiField)super.getElement();
    }

    @Override
    protected void markReferenced(RefElementImpl refFrom, PsiElement psiFrom, PsiElement psiWhat, boolean forWriting, boolean forReading, PsiReferenceExpression expressionFrom) {
        PsiClassInitializer initializer;
        this.addInReference(refFrom);
        boolean referencedFromClassInitializer = false;
        if (forWriting && expressionFrom != null && (initializer = (PsiClassInitializer)PsiTreeUtil.getParentOfType((PsiElement)expressionFrom, PsiClassInitializer.class)) != null && initializer.getParent() instanceof PsiClass && psiFrom == initializer.getParent()) {
            referencedFromClassInitializer = true;
        }
        if (forWriting) {
            this.setUsedForWriting(true);
        }
        if (forReading) {
            this.setUsedForReading(true);
        }
        this.getRefManager().fireNodeMarkedReferenced(this, refFrom, referencedFromClassInitializer, forReading, forWriting);
    }

    public boolean isUsedForReading() {
        return this.checkFlag(65536);
    }

    private void setUsedForReading(boolean usedForReading) {
        this.setFlag(usedForReading, 65536);
    }

    public boolean isUsedForWriting() {
        return this.checkFlag(131072);
    }

    private void setUsedForWriting(boolean usedForWriting) {
        this.setFlag(false, 262144);
        this.setFlag(usedForWriting, 131072);
    }

    public boolean isOnlyAssignedInInitializer() {
        return this.checkFlag(262144);
    }

    @Override
    public void accept(final RefVisitor visitor) {
        if (visitor instanceof RefJavaVisitor) {
            ApplicationManager.getApplication().runReadAction(new Runnable(){

                @Override
                public void run() {
                    ((RefJavaVisitor)visitor).visitField((RefField)RefFieldImpl.this);
                }
            });
        } else {
            super.accept(visitor);
        }
    }

    @Override
    public void buildReferences() {
        PsiField psiField = this.getElement();
        if (psiField != null) {
            RefClassImpl refClass;
            PsiClass psiClass;
            RefJavaUtil refUtil = RefJavaUtil.getInstance();
            refUtil.addReferences((PsiModifierListOwner)psiField, (RefJavaElement)this, (PsiElement)psiField.getInitializer());
            refUtil.addReferences((PsiModifierListOwner)psiField, (RefJavaElement)this, (PsiElement)psiField.getModifierList());
            if (psiField instanceof PsiEnumConstant) {
                refUtil.addReferences((PsiModifierListOwner)psiField, (RefJavaElement)this, (PsiElement)psiField);
            }
            if ((psiField.getInitializer() != null || psiField instanceof PsiEnumConstant) && !this.checkFlag(131072)) {
                this.setFlag(true, 262144);
                this.setFlag(true, 131072);
            }
            PsiType psiType = psiField.getType();
            RefClass ownerClass = refUtil.getOwnerClass((RefManager)this.getRefManager(), (PsiElement)psiField);
            if (ownerClass != null && (psiType = psiType.getDeepComponentType()) instanceof PsiClassType && (psiClass = PsiUtil.resolveClassInType((PsiType)psiType)) != null && this.getRefManager().belongsToScope((PsiElement)psiClass) && (refClass = (RefClassImpl)this.getRefManager().getReference((PsiElement)psiClass)) != null) {
                refClass.addTypeReference((RefJavaElement)ownerClass);
                refClass.addClassExporter(this);
            }
            this.getRefManager().fireBuildReferences(this);
        }
    }

    public RefClass getOwnerClass() {
        return (RefClass)this.getOwner();
    }

    @Override
    public String getExternalName() {
        final String[] result = new String[1];
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                PsiField psiField = RefFieldImpl.this.getElement();
                RefElementImpl.LOG.assertTrue(psiField != null);
                result[0] = PsiFormatUtil.getExternalName((PsiModifierListOwner)psiField);
            }
        };
        ApplicationManager.getApplication().runReadAction(runnable);
        return result[0];
    }

    @Nullable
    public static RefField fieldFromExternalName(RefManager manager, String externalName) {
        return (RefField)manager.getReference((PsiElement)RefFieldImpl.findPsiField(PsiManager.getInstance((Project)manager.getProject()), externalName));
    }

    @Nullable
    public static PsiField findPsiField(PsiManager manager, String externalName) {
        int classNameDelimeter = externalName.lastIndexOf(32);
        if (classNameDelimeter > 0 && classNameDelimeter < externalName.length() - 1) {
            String className = externalName.substring(0, classNameDelimeter);
            String fieldName = externalName.substring(classNameDelimeter + 1);
            PsiClass psiClass = ClassUtil.findPsiClass((PsiManager)manager, (String)className);
            if (psiClass != null) {
                return psiClass.findFieldByName(fieldName, false);
            }
        }
        return null;
    }

    @Override
    public boolean isSuspicious() {
        if (this.isEntry()) {
            return false;
        }
        if (super.isSuspicious()) {
            return true;
        }
        return this.isUsedForReading() != this.isUsedForWriting();
    }

    @Override
    protected void initialize() {
        this.getRefManager().fireNodeInitialized(this);
    }
}

