/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.macro;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.ExpressionContext;
import com.intellij.codeInsight.template.macro.MacroUtil;
import com.intellij.codeInsight.template.macro.VariableTypeMacroBase;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import java.util.ArrayList;

public class ArrayVariableMacro
extends VariableTypeMacroBase {
    public String getName() {
        return "arrayVariable";
    }

    public String getDescription() {
        return CodeInsightBundle.message((String)"macro.array.variable", (Object[])new Object[0]);
    }

    @Override
    protected PsiElement[] getVariables(Expression[] params, ExpressionContext context) {
        PsiVariable[] variables;
        if (params.length != 0) {
            return null;
        }
        Project project = context.getProject();
        int offset = context.getStartOffset();
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        ArrayList<PsiVariable> array = new ArrayList<PsiVariable>();
        PsiFile file = PsiDocumentManager.getInstance((Project)project).getPsiFile(context.getEditor().getDocument());
        PsiElement place = file.findElementAt(offset);
        for (PsiVariable variable : variables = MacroUtil.getVariablesVisibleAt(place, "")) {
            PsiType type = variable.getType();
            if (!(type instanceof PsiArrayType)) continue;
            array.add(variable);
        }
        return (PsiElement[])array.toArray(new PsiVariable[array.size()]);
    }
}

