/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.impl;

import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.codeInsight.template.impl.TemplateImpl;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Set;

public class InvokeTemplateAction
extends AnAction {
    private final TemplateImpl myTemplate;
    private final Editor myEditor;
    private final Project myProject;

    public InvokeTemplateAction(TemplateImpl template, Editor editor, Project project, Set<Character> usedMnemonicsSet) {
        super(InvokeTemplateAction.extractMnemonic(template.getKey(), usedMnemonicsSet) + ". " + template.getDescription());
        this.myTemplate = template;
        this.myProject = project;
        this.myEditor = editor;
    }

    public static String extractMnemonic(String caption, Set<Character> usedMnemonics) {
        if (StringUtil.isEmpty((String)caption)) {
            return "";
        }
        for (int i = 0; i < caption.length(); ++i) {
            char c = caption.charAt(i);
            if (!usedMnemonics.add(Character.valueOf(Character.toUpperCase(c)))) continue;
            return caption.substring(0, i) + '\u001b' + caption.substring(i);
        }
        return caption + " ";
    }

    public TemplateImpl getTemplate() {
        return this.myTemplate;
    }

    public void actionPerformed(AnActionEvent e) {
        String selectionString;
        Document document = this.myEditor.getDocument();
        VirtualFile file = FileDocumentManager.getInstance().getFile(document);
        if (file != null) {
            ReadonlyStatusHandler.getInstance((Project)this.myProject).ensureFilesWritable(new VirtualFile[]{file});
        }
        if ((selectionString = this.myEditor.getSelectionModel().getSelectedText()) != null && this.myTemplate.isToReformat()) {
            selectionString = selectionString.trim();
        }
        TemplateManager.getInstance(this.myProject).startTemplate(this.myEditor, selectionString, this.myTemplate);
    }
}

