/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.lookup.impl;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementAction;
import com.intellij.codeInsight.lookup.impl.LookupActionHandler;
import com.intellij.codeInsight.lookup.impl.LookupImpl;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.popup.ClosableByLeftArrow;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class ShowLookupActionsHandler
extends LookupActionHandler {
    public ShowLookupActionsHandler(EditorActionHandler originalHandler) {
        super(originalHandler);
    }

    @Override
    protected void executeInLookup(LookupImpl lookup) {
        LookupElement element = lookup.getCurrentItem();
        if (element == null) {
            return;
        }
        Collection<LookupElementAction> actions = lookup.getActionsFor(element);
        if (actions.isEmpty()) {
            lookup.getEditor().getCaretModel().moveCaretRelatively(1, 0, false, false, true);
            return;
        }
        ShowLookupActionsHandler.showItemActions(lookup, actions);
    }

    public static void showItemActions(LookupImpl lookup, Collection<LookupElementAction> actions) {
        LookupActionsStep step = new LookupActionsStep(actions, lookup);
        Rectangle bounds = lookup.getCurrentItemBounds();
        ListPopup popup = JBPopupFactory.getInstance().createListPopup((ListPopupStep)step);
        JComponent component = lookup.getComponent();
        popup.show(new RelativePoint((Component)component, new Point(bounds.x + bounds.width, bounds.y)));
    }

    private static class LookupActionsStep
    extends BaseListPopupStep<LookupElementAction>
    implements ClosableByLeftArrow {
        private final LookupImpl myLookup;

        public LookupActionsStep(Collection<LookupElementAction> actions, LookupImpl lookup) {
            super(null, new ArrayList<LookupElementAction>(actions));
            this.myLookup = lookup;
        }

        public PopupStep onChosen(LookupElementAction selectedValue, boolean finalChoice) {
            selectedValue.performLookupAction();
            this.myLookup.hide();
            return FINAL_CHOICE;
        }

        public Icon getIconFor(LookupElementAction aValue) {
            return aValue.getIcon();
        }

        @NotNull
        public String getTextFor(LookupElementAction value) {
            String string = value.getText();
            if (string == null) {
                throw new IllegalStateException("@NotNull method com/intellij/codeInsight/lookup/impl/ShowLookupActionsHandler$LookupActionsStep.getTextFor must not return null");
            }
            return string;
        }
    }
}

