/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention.impl;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.CodeInsightUtilBase;
import com.intellij.codeInsight.intention.impl.BaseIntentionAction;
import com.intellij.codeInsight.intention.impl.CreateFieldFromParameterAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.fileEditor.ex.IdeDocumentHistory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.SuggestedNameInfo;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AssignFieldFromParameterAction
extends BaseIntentionAction {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.intention.impl.AssignFieldFromParameterAction");

    @Nullable
    private static PsiType getType(PsiParameter myParameter) {
        if (myParameter == null) {
            return null;
        }
        PsiType type = myParameter.getType();
        if (type instanceof PsiEllipsisType) {
            type = ((PsiEllipsisType)type).toArrayType();
        }
        return type;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        PsiClass targetClass;
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/intention/impl/AssignFieldFromParameterAction.isAvailable must not be null");
        }
        PsiParameter myParameter = CreateFieldFromParameterAction.findParameterAtCursor(file, editor);
        PsiType type = AssignFieldFromParameterAction.getType(myParameter);
        PsiClass psiClass = targetClass = myParameter == null ? null : (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)myParameter, PsiClass.class);
        if (myParameter == null || !myParameter.isValid() || !myParameter.getManager().isInProject((PsiElement)myParameter) || !(myParameter.getDeclarationScope() instanceof PsiMethod) || ((PsiMethod)myParameter.getDeclarationScope()).getBody() == null || type == null || !type.isValid() || targetClass == null || targetClass.isInterface() || CreateFieldFromParameterAction.isParameterAssignedToField(myParameter)) {
            return false;
        }
        PsiField field = AssignFieldFromParameterAction.findFieldToAssign(myParameter);
        if (field == null) {
            return false;
        }
        this.setText(CodeInsightBundle.message((String)"intention.assign.field.from.parameter.text", (Object[])new Object[]{field.getName()}));
        return true;
    }

    @NotNull
    public String getFamilyName() {
        String string = CodeInsightBundle.message((String)"intention.assign.field.from.parameter.family", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/intention/impl/AssignFieldFromParameterAction.getFamilyName must not return null");
        }
        return string;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/intention/impl/AssignFieldFromParameterAction.invoke must not be null");
        }
        PsiParameter myParameter = CreateFieldFromParameterAction.findParameterAtCursor(file, editor);
        if (!CodeInsightUtilBase.prepareFileForWrite(myParameter.getContainingFile())) {
            return;
        }
        IdeDocumentHistory.getInstance(project).includeCurrentPlaceAsChangePlace();
        try {
            PsiField field = AssignFieldFromParameterAction.findFieldToAssign(myParameter);
            AssignFieldFromParameterAction.addFieldAssignmentStatement(project, field, myParameter, editor);
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
    }

    public static void addFieldAssignmentStatement(Project project, PsiField field, PsiParameter parameter, Editor editor) throws IncorrectOperationException {
        PsiMethod method = (PsiMethod)parameter.getDeclarationScope();
        PsiCodeBlock methodBody = method.getBody();
        if (methodBody == null) {
            return;
        }
        PsiManager psiManager = PsiManager.getInstance((Project)project);
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)psiManager.getProject()).getElementFactory();
        String fieldName = field.getName();
        String parameterName = parameter.getName();
        boolean isMethodStatic = method.hasModifierProperty("static");
        PsiClass targetClass = method.getContainingClass();
        String stmtText = fieldName + " = " + parameterName + ";";
        if (Comparing.strEqual((String)fieldName, (String)parameterName)) {
            String prefix = isMethodStatic ? (targetClass.getName() == null ? "" : targetClass.getName() + ".") : "this.";
            stmtText = prefix + stmtText;
        }
        PsiStatement assignmentStmt = factory.createStatementFromText(stmtText, (PsiElement)methodBody);
        assignmentStmt = (PsiStatement)CodeStyleManager.getInstance((Project)project).reformat((PsiElement)assignmentStmt);
        PsiStatement[] statements = methodBody.getStatements();
        int i = CreateFieldFromParameterAction.findFieldAssignmentAnchor(statements, null, targetClass, parameter);
        PsiElement inserted = i == statements.length ? methodBody.add((PsiElement)assignmentStmt) : methodBody.addAfter((PsiElement)assignmentStmt, i > 0 ? statements[i - 1] : null);
        editor.getCaretModel().moveToOffset(inserted.getTextRange().getEndOffset());
        editor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
    }

    @Nullable
    private static PsiField findFieldToAssign(PsiParameter myParameter) {
        JavaCodeStyleManager styleManager = JavaCodeStyleManager.getInstance((Project)myParameter.getProject());
        String parameterName = myParameter.getName();
        String propertyName = styleManager.variableNameToPropertyName(parameterName, VariableKind.PARAMETER);
        PsiMethod method = (PsiMethod)myParameter.getDeclarationScope();
        boolean isMethodStatic = method.hasModifierProperty("static");
        VariableKind kind = isMethodStatic ? VariableKind.STATIC_FIELD : VariableKind.FIELD;
        SuggestedNameInfo suggestedNameInfo = styleManager.suggestVariableName(kind, propertyName, null, AssignFieldFromParameterAction.getType(myParameter));
        String fieldName = suggestedNameInfo.names[0];
        PsiClass aClass = method.getContainingClass();
        if (aClass == null) {
            return null;
        }
        PsiField field = aClass.findFieldByName(fieldName, false);
        if (field == null) {
            return null;
        }
        if (!field.hasModifierProperty("static") && isMethodStatic) {
            return null;
        }
        return field;
    }
}

