/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.highlighting;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.highlighting.HighlightUsagesHandler;
import com.intellij.codeInsight.highlighting.HighlightUsagesHandlerBase;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiBreakStatement;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiContinueStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiThrowStatement;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.controlFlow.AnalysisCanceledException;
import com.intellij.psi.controlFlow.ControlFlow;
import com.intellij.psi.controlFlow.ControlFlowFactory;
import com.intellij.psi.controlFlow.ControlFlowUtil;
import com.intellij.psi.controlFlow.LocalsOrMyInstanceFieldsControlFlowPolicy;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Consumer;
import com.intellij.util.containers.IntArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class HighlightExitPointsHandler
extends HighlightUsagesHandlerBase<PsiElement> {
    private final PsiElement myTarget;

    public HighlightExitPointsHandler(Editor editor, PsiFile file, PsiElement target) {
        super(editor, file);
        this.myTarget = target;
    }

    @Override
    public List<PsiElement> getTargets() {
        return Collections.singletonList(this.myTarget);
    }

    @Override
    protected void selectTargets(List<PsiElement> targets, Consumer<List<PsiElement>> selectionConsumer) {
        selectionConsumer.consume(targets);
    }

    @Override
    public void computeUsages(List<PsiElement> targets) {
        FeatureUsageTracker.getInstance().triggerFeatureUsed("codeassists.highlight.return");
        PsiElement parent = this.myTarget.getParent();
        if (!(parent instanceof PsiReturnStatement) && !(parent instanceof PsiThrowStatement)) {
            return;
        }
        PsiMethod method = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)this.myTarget, PsiMethod.class);
        if (method == null) {
            return;
        }
        PsiCodeBlock body = method.getBody();
        try {
            this.highlightExitPoints((PsiStatement)parent, body);
        }
        catch (AnalysisCanceledException e) {
            // empty catch block
        }
    }

    @Nullable
    private static PsiElement getExitTarget(PsiStatement exitStatement) {
        if (exitStatement instanceof PsiReturnStatement) {
            return PsiTreeUtil.getParentOfType((PsiElement)exitStatement, PsiMethod.class);
        }
        if (exitStatement instanceof PsiBreakStatement) {
            return ((PsiBreakStatement)exitStatement).findExitedStatement();
        }
        if (exitStatement instanceof PsiContinueStatement) {
            return ((PsiContinueStatement)exitStatement).findContinuedStatement();
        }
        if (exitStatement instanceof PsiThrowStatement) {
            PsiStatement target;
            PsiExpression expr = ((PsiThrowStatement)exitStatement).getException();
            if (expr == null) {
                return null;
            }
            PsiType exceptionType = expr.getType();
            if (!(exceptionType instanceof PsiClassType)) {
                return null;
            }
            for (target = exitStatement; !(target instanceof PsiMethod || target == null || target instanceof PsiClass || target instanceof PsiFile); target = target.getParent()) {
                PsiParameter[] params;
                if (!(target instanceof PsiTryStatement)) continue;
                PsiTryStatement tryStatement = (PsiTryStatement)target;
                for (PsiParameter param : params = tryStatement.getCatchBlockParameters()) {
                    if (param.getType().isAssignableFrom(exceptionType)) break;
                }
            }
            if (target instanceof PsiMethod || target instanceof PsiTryStatement) {
                return target;
            }
            return null;
        }
        return null;
    }

    private void highlightExitPoints(PsiStatement parent, PsiCodeBlock body) throws AnalysisCanceledException {
        Project project = this.myTarget.getProject();
        ControlFlow flow = ControlFlowFactory.getInstance(project).getControlFlow((PsiElement)body, LocalsOrMyInstanceFieldsControlFlowPolicy.getInstance(), false);
        Collection<PsiStatement> exitStatements = ControlFlowUtil.findExitPointsAndStatements(flow, 0, flow.getSize(), new IntArrayList(), PsiReturnStatement.class, PsiBreakStatement.class, PsiContinueStatement.class, PsiThrowStatement.class);
        if (!exitStatements.contains(parent)) {
            return;
        }
        PsiElement originalTarget = HighlightExitPointsHandler.getExitTarget(parent);
        Iterator<PsiStatement> it = exitStatements.iterator();
        while (it.hasNext()) {
            PsiStatement psiStatement = it.next();
            if (HighlightExitPointsHandler.getExitTarget(psiStatement) == originalTarget) continue;
            it.remove();
        }
        for (PsiStatement e : exitStatements) {
            this.addOccurrence((PsiElement)e);
        }
        this.myStatusText = CodeInsightBundle.message((String)"status.bar.exit.points.highlighted.message", (Object[])new Object[]{exitStatements.size(), HighlightUsagesHandler.getShortcutText()});
    }
}

