/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions;

import com.intellij.codeInsight.editorActions.ExtendWordSelectionHandler;
import com.intellij.codeInsight.editorActions.XmlTokenSelectioner;
import com.intellij.codeInsight.editorActions.wordSelection.AbstractWordSelectioner;
import com.intellij.codeInsight.highlighting.BraceMatchingUtil;
import com.intellij.ide.highlighter.HighlighterFactory;
import com.intellij.lang.Language;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlComment;
import com.intellij.psi.xml.XmlToken;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.xml.util.HtmlUtil;
import java.util.ArrayList;
import java.util.List;

public class HtmlSelectioner
extends AbstractWordSelectioner {
    private static ExtendWordSelectionHandler ourStyleSelectioner;

    public static void setStyleSelectioner(ExtendWordSelectionHandler _styleSelectioner) {
        ourStyleSelectioner = _styleSelectioner;
    }

    @Override
    public boolean canSelect(PsiElement e) {
        return HtmlSelectioner.canSelectElement(e);
    }

    static boolean canSelectElement(PsiElement e) {
        if (e instanceof XmlToken) {
            Language language = e.getLanguage();
            return HtmlUtil.hasHtml(e.getContainingFile()) || ourStyleSelectioner != null && ourStyleSelectioner.canSelect(e);
        }
        return false;
    }

    @Override
    public List<TextRange> select(PsiElement e, CharSequence editorText, int cursorOffset, Editor editor) {
        PsiElement parent;
        List o;
        List<TextRange> result = !(e instanceof XmlToken) || XmlTokenSelectioner.shouldSelectToken((XmlToken)e) || ((XmlToken)e).getTokenType() == XmlTokenType.XML_DATA_CHARACTERS ? super.select(e, editorText, cursorOffset, editor) : new ArrayList<TextRange>();
        if (ourStyleSelectioner != null && (o = ourStyleSelectioner.select(e, editorText, cursorOffset, editor)) != null) {
            result.addAll(o);
        }
        if ((parent = e.getParent()) instanceof XmlComment) {
            result.addAll(HtmlSelectioner.expandToWholeLine(editorText, parent.getTextRange(), true));
        }
        PsiFile psiFile = e.getContainingFile();
        FileType fileType = FileTypeManager.getInstance().getFileTypeByFile(psiFile.getVirtualFile());
        HtmlSelectioner.addAttributeSelection(result, e);
        FileViewProvider fileViewProvider = psiFile.getViewProvider();
        for (Language lang : fileViewProvider.getLanguages()) {
            PsiFile langFile = fileViewProvider.getPsi(lang);
            if (langFile == psiFile) continue;
            HtmlSelectioner.addAttributeSelection(result, fileViewProvider.findElementAt(cursorOffset, lang));
        }
        EditorHighlighter highlighter = HighlighterFactory.createHighlighter((Project)e.getProject(), (VirtualFile)psiFile.getVirtualFile());
        highlighter.setText(editorText);
        HtmlSelectioner.addTagSelection(editorText, cursorOffset, fileType, highlighter, result);
        return result;
    }

    private static void addTagSelection(CharSequence editorText, int cursorOffset, FileType fileType, EditorHighlighter highlighter, List<TextRange> result) {
        int start = cursorOffset;
        while (start >= 0) {
            HighlighterIterator i = highlighter.createIterator(start);
            if (i.atEnd()) {
                return;
            }
            while (i.getTokenType() != XmlTokenType.XML_START_TAG_START) {
                i.retreat();
                if (!i.atEnd()) continue;
                return;
            }
            start = i.getStart();
            boolean matched = BraceMatchingUtil.matchBrace(editorText, fileType, i, true);
            if (matched) {
                int tagEnd = i.getEnd();
                result.add(new TextRange(start, tagEnd));
                HighlighterIterator j = highlighter.createIterator(start);
                while (!j.atEnd() && j.getTokenType() != XmlTokenType.XML_TAG_END) {
                    j.advance();
                }
                while (!i.atEnd() && i.getTokenType() != XmlTokenType.XML_END_TAG_START) {
                    i.retreat();
                }
                if (!i.atEnd() && !j.atEnd()) {
                    result.add(new TextRange(j.getEnd(), i.getStart()));
                }
                if (!j.atEnd()) {
                    result.add(new TextRange(start, j.getEnd()));
                }
                if (!i.atEnd()) {
                    result.add(new TextRange(i.getStart(), tagEnd));
                }
            }
            --start;
        }
        return;
    }

    private static void addAttributeSelection(List<TextRange> result, PsiElement e) {
        XmlAttribute attribute = (XmlAttribute)PsiTreeUtil.getParentOfType((PsiElement)e, XmlAttribute.class);
        if (attribute != null) {
            result.add(attribute.getTextRange());
            XmlAttributeValue value = attribute.getValueElement();
            if (value != null) {
                TextRange range = value.getTextRange();
                result.add(range);
                if (value.getFirstChild() != null && value.getFirstChild().getNode().getElementType() == XmlTokenType.XML_ATTRIBUTE_VALUE_START_DELIMITER) {
                    result.add(new TextRange(range.getStartOffset() + 1, range.getEndOffset() - 1));
                }
            }
        }
    }
}

