/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.CodeInsightUtilBase;
import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.quickfix.QuickFixAction;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WrapExpressionFix
implements IntentionAction {
    private final PsiExpression myExpression;
    private final PsiClassType myExpectedType;

    public WrapExpressionFix(PsiClassType expectedType, PsiExpression expression) {
        this.myExpression = expression;
        this.myExpectedType = expectedType;
    }

    @NotNull
    public String getText() {
        PsiMethod wrapper = this.myExpression.isValid() ? WrapExpressionFix.findWrapper(this.myExpression.getType(), this.myExpectedType) : null;
        String methodPresentation = wrapper != null ? wrapper.getContainingClass().getName() + "." + wrapper.getName() : "";
        String string = QuickFixBundle.message("wrap.expression.using.static.accessor.text", methodPresentation);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/daemon/impl/quickfix/WrapExpressionFix.getText must not return null");
        }
        return string;
    }

    @Nullable
    private static PsiMethod findWrapper(PsiType type, PsiClassType expectedType) {
        PsiClass aClass = expectedType.resolve();
        if (aClass != null) {
            PsiMethod[] methods;
            for (PsiMethod method : methods = aClass.getMethods()) {
                if (!method.hasModifierProperty("static") || method.getParameterList().getParametersCount() != 1 || !method.getParameterList().getParameters()[0].getType().equals(type) || method.getReturnType() == null || !expectedType.equals((Object)method.getReturnType())) continue;
                return method;
            }
        }
        return null;
    }

    @NotNull
    public String getFamilyName() {
        String string = QuickFixBundle.message("wrap.expression.using.static.accessor.family", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/daemon/impl/quickfix/WrapExpressionFix.getFamilyName must not return null");
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/quickfix/WrapExpressionFix.isAvailable must not be null");
        }
        return this.myExpression.isValid() && this.myExpression.getManager().isInProject((PsiElement)this.myExpression) && this.myExpectedType.isValid() && this.myExpression.getType() != null && WrapExpressionFix.findWrapper(this.myExpression.getType(), this.myExpectedType) != null;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/quickfix/WrapExpressionFix.invoke must not be null");
        }
        if (!CodeInsightUtilBase.prepareFileForWrite(file)) {
            return;
        }
        PsiMethod wrapper = WrapExpressionFix.findWrapper(this.myExpression.getType(), this.myExpectedType);
        assert (wrapper != null);
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)file.getProject()).getElementFactory();
        String methodCallText = "Foo." + wrapper.getName() + "()";
        PsiMethodCallExpression call = (PsiMethodCallExpression)factory.createExpressionFromText(methodCallText, null);
        call.getArgumentList().add((PsiElement)this.myExpression);
        ((PsiReferenceExpression)call.getMethodExpression().getQualifierExpression()).bindToElement((PsiElement)wrapper.getContainingClass());
        this.myExpression.replace((PsiElement)call);
    }

    public boolean startInWriteAction() {
        return true;
    }

    public static void registerWrapAction(JavaResolveResult[] candidates, PsiExpression[] expressions, HighlightInfo highlightInfo) {
        PsiClassType expectedType = null;
        PsiExpression expr = null;
        block0: for (int i = 0; i < candidates.length && expectedType == null; ++i) {
            JavaResolveResult candidate = candidates[i];
            PsiSubstitutor substitutor = candidate.getSubstitutor();
            PsiElement element = candidate.getElement();
            assert (element != null);
            PsiParameter[] parameters = ((PsiMethod)element).getParameterList().getParameters();
            if (parameters.length != expressions.length) continue;
            for (int j = 0; j < expressions.length; ++j) {
                PsiExpression expression = expressions[j];
                if (expression.getType() == null) continue;
                PsiType paramType = parameters[j].getType();
                PsiType psiType = paramType = substitutor != null ? substitutor.substitute(paramType) : paramType;
                if (paramType.isAssignableFrom(expression.getType()) || !(paramType instanceof PsiClassType)) continue;
                if (expectedType == null && WrapExpressionFix.findWrapper(expression.getType(), (PsiClassType)paramType) != null) {
                    expectedType = (PsiClassType)paramType;
                    expr = expression;
                    continue;
                }
                expectedType = null;
                expr = null;
                continue block0;
            }
        }
        if (expectedType != null) {
            QuickFixAction.registerQuickFixAction(highlightInfo, expr.getTextRange(), new WrapExpressionFix(expectedType, expr), null);
        }
    }
}

