/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.CodeInsightUtilBase;
import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.intention.impl.BaseIntentionAction;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateEditingListener;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.ide.util.PsiClassListCellRenderer;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.fileEditor.ex.IdeDocumentHistory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.PopupChooserBuilder;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.VisibilityUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Vector;
import javax.swing.JList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CreateFromUsageBaseFix
extends BaseIntentionAction {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.daemon.impl.quickfix.CreateFromUsageBaseFix");

    protected CreateFromUsageBaseFix() {
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/quickfix/CreateFromUsageBaseFix.isAvailable must not be null");
        }
        int offset = editor.getCaretModel().getOffset();
        PsiElement element = this.getElement();
        if (element == null) {
            return false;
        }
        List<PsiClass> targetClasses = this.getTargetClasses(element);
        return !targetClasses.isEmpty() && !this.isValidElement(element) && this.isAvailableImpl(offset);
    }

    protected abstract boolean isAvailableImpl(int var1);

    protected abstract void invokeImpl(PsiClass var1);

    protected abstract boolean isValidElement(PsiElement var1);

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/quickfix/CreateFromUsageBaseFix.invoke must not be null");
        }
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        PsiElement element = this.getElement();
        if (LOG.isDebugEnabled()) {
            LOG.debug("CreateFromUsage: element =" + element);
        }
        if (element == null) {
            return;
        }
        List<PsiClass> targetClasses = this.getTargetClasses(element);
        if (targetClasses.isEmpty()) {
            return;
        }
        if (targetClasses.size() == 1) {
            this.doInvoke(project, targetClasses.get(0));
        } else {
            this.chooseTargetClass(targetClasses, editor);
        }
    }

    private void doInvoke(Project project, PsiClass targetClass) {
        if (!CodeInsightUtilBase.prepareFileForWrite(targetClass.getContainingFile())) {
            return;
        }
        IdeDocumentHistory.getInstance(project).includeCurrentPlaceAsChangePlace();
        this.invokeImpl(targetClass);
    }

    @Nullable
    protected abstract PsiElement getElement();

    private void chooseTargetClass(List<PsiClass> classes, Editor editor) {
        final Project project = classes.get(0).getProject();
        final JList<PsiClass> list = new JList<PsiClass>(new Vector<PsiClass>(classes));
        PsiClassListCellRenderer renderer = new PsiClassListCellRenderer();
        list.setSelectionMode(0);
        list.setCellRenderer(renderer);
        PopupChooserBuilder builder = new PopupChooserBuilder(list);
        renderer.installSpeedSearch(builder);
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                int index = list.getSelectedIndex();
                if (index < 0) {
                    return;
                }
                final PsiClass aClass = (PsiClass)list.getSelectedValue();
                CommandProcessor.getInstance().executeCommand(project, new Runnable(){

                    @Override
                    public void run() {
                        ApplicationManager.getApplication().runWriteAction(new Runnable(){

                            @Override
                            public void run() {
                                CreateFromUsageBaseFix.this.doInvoke(project, aClass);
                            }
                        });
                    }
                }, CreateFromUsageBaseFix.this.getText(), null);
            }
        };
        builder.setTitle(QuickFixBundle.message("target.class.chooser.title", new Object[0])).setItemChoosenCallback(runnable).createPopup().showInBestPositionFor(editor);
    }

    protected static Editor positionCursor(Project project, @NotNull PsiFile targetFile, @NotNull PsiElement element) {
        if (targetFile == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/quickfix/CreateFromUsageBaseFix.positionCursor must not be null");
        }
        if (element == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/quickfix/CreateFromUsageBaseFix.positionCursor must not be null");
        }
        TextRange range = element.getTextRange();
        int textOffset = range.getStartOffset();
        OpenFileDescriptor descriptor = new OpenFileDescriptor(project, targetFile.getVirtualFile(), textOffset);
        return FileEditorManager.getInstance((Project)project).openTextEditor(descriptor, true);
    }

    protected void setupVisibility(PsiClass parentClass, PsiClass targetClass, PsiModifierList list) throws IncorrectOperationException {
        if (targetClass.isInterface()) {
            list.deleteChildRange(list.getFirstChild(), list.getLastChild());
            return;
        }
        VisibilityUtil.setVisibility((PsiModifierList)list, (String)this.getVisibility(parentClass, targetClass));
    }

    protected String getVisibility(PsiClass parentClass, PsiClass targetClass) {
        if (parentClass != null && (parentClass.equals(targetClass) || PsiTreeUtil.isAncestor((PsiElement)targetClass, (PsiElement)parentClass, (boolean)true))) {
            return "private";
        }
        return "public";
    }

    protected static boolean shouldCreateStaticMember(PsiReferenceExpression ref, PsiClass targetClass) {
        if (targetClass.isInterface()) {
            return false;
        }
        PsiExpression qualifierExpression = ref.getQualifierExpression();
        while (qualifierExpression instanceof PsiParenthesizedExpression) {
            qualifierExpression = ((PsiParenthesizedExpression)qualifierExpression).getExpression();
        }
        if (qualifierExpression instanceof PsiReferenceExpression) {
            PsiReferenceExpression referenceExpression = (PsiReferenceExpression)qualifierExpression;
            PsiElement resolvedElement = referenceExpression.resolve();
            return resolvedElement instanceof PsiClass;
        }
        if (qualifierExpression != null) {
            return false;
        }
        assert (PsiTreeUtil.isAncestor((PsiElement)targetClass, (PsiElement)ref, (boolean)true));
        PsiModifierListOwner owner = (PsiModifierListOwner)PsiTreeUtil.getParentOfType((PsiElement)ref, PsiModifierListOwner.class);
        if (owner instanceof PsiMethod && ((PsiMethod)owner).isConstructor()) {
            String calleeText;
            PsiReferenceExpression run = ref;
            while (run.getParent() instanceof PsiExpression) {
                run = (PsiExpression)run.getParent();
            }
            if (run.getParent() instanceof PsiExpressionList && run.getParent().getParent() instanceof PsiMethodCallExpression && ((calleeText = ((PsiMethodCallExpression)run.getParent().getParent()).getMethodExpression().getText()).equals("this") || calleeText.equals("super"))) {
                return true;
            }
        }
        while (owner != null && owner != targetClass) {
            if (owner.hasModifierProperty("static")) {
                return true;
            }
            owner = (PsiModifierListOwner)PsiTreeUtil.getParentOfType((PsiElement)owner, PsiModifierListOwner.class);
        }
        return false;
    }

    @Nullable
    private static PsiExpression getQualifier(PsiElement element) {
        if (element instanceof PsiNewExpression) {
            PsiJavaCodeReferenceElement ref = ((PsiNewExpression)element).getClassReference();
            if (ref instanceof PsiReferenceExpression) {
                return ((PsiReferenceExpression)ref).getQualifierExpression();
            }
        } else {
            if (element instanceof PsiReferenceExpression) {
                return ((PsiReferenceExpression)element).getQualifierExpression();
            }
            if (element instanceof PsiMethodCallExpression) {
                return ((PsiMethodCallExpression)element).getMethodExpression().getQualifierExpression();
            }
        }
        return null;
    }

    protected static PsiSubstitutor getTargetSubstitutor(PsiElement element) {
        PsiType type;
        if (element instanceof PsiNewExpression) {
            JavaResolveResult result = ((PsiNewExpression)element).getClassOrAnonymousClassReference().advancedResolve(false);
            PsiSubstitutor substitutor = result.getSubstitutor();
            return substitutor == null ? PsiSubstitutor.EMPTY : substitutor;
        }
        PsiExpression qualifier = CreateFromUsageBaseFix.getQualifier(element);
        if (qualifier != null && (type = qualifier.getType()) instanceof PsiClassType) {
            return ((PsiClassType)type).resolveGenerics().getSubstitutor();
        }
        return PsiSubstitutor.EMPTY;
    }

    protected boolean isAllowOuterTargetClass() {
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    protected List<PsiClass> getTargetClasses(PsiElement element) {
        ArrayList<PsiClass> result;
        List<Object> list;
        PsiClass psiClass = null;
        PsiExpression qualifier = null;
        if (element instanceof PsiNewExpression) {
            PsiElement refElement;
            PsiNewExpression newExpression = (PsiNewExpression)element;
            PsiJavaCodeReferenceElement ref = newExpression.getClassOrAnonymousClassReference();
            if (ref != null && (refElement = ref.resolve()) instanceof PsiClass) {
                psiClass = (PsiClass)refElement;
            }
        } else if (element instanceof PsiReferenceExpression) {
            qualifier = ((PsiReferenceExpression)element).getQualifierExpression();
        } else if (element instanceof PsiMethodCallExpression) {
            PsiReferenceExpression methodExpression = ((PsiMethodCallExpression)element).getMethodExpression();
            qualifier = methodExpression.getQualifierExpression();
            String referenceName = methodExpression.getReferenceName();
            if (referenceName == null) {
                list = Collections.emptyList();
                if (list == null) throw new IllegalStateException("@NotNull method com/intellij/codeInsight/daemon/impl/quickfix/CreateFromUsageBaseFix.getTargetClasses must not return null");
                return list;
            }
        }
        boolean allowOuterClasses = false;
        if (qualifier != null) {
            PsiElement resolved;
            PsiType type = qualifier.getType();
            if (type instanceof PsiClassType) {
                psiClass = ((PsiClassType)type).resolve();
            }
            if (qualifier instanceof PsiJavaCodeReferenceElement && (resolved = ((PsiJavaCodeReferenceElement)qualifier).resolve()) instanceof PsiClass && psiClass == null) {
                psiClass = (PsiClass)resolved;
            }
        } else if (psiClass == null) {
            psiClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)element, PsiClass.class);
            allowOuterClasses = true;
        }
        if (!(psiClass instanceof PsiTypeParameter)) {
            if (psiClass == null || !psiClass.getManager().isInProject((PsiElement)psiClass)) {
                list = Collections.emptyList();
                if (list == null) throw new IllegalStateException("@NotNull method com/intellij/codeInsight/daemon/impl/quickfix/CreateFromUsageBaseFix.getTargetClasses must not return null");
                return list;
            }
            if (!allowOuterClasses || !this.isAllowOuterTargetClass() || ApplicationManager.getApplication().isUnitTestMode()) {
                list = Collections.singletonList(psiClass);
                if (list == null) throw new IllegalStateException("@NotNull method com/intellij/codeInsight/daemon/impl/quickfix/CreateFromUsageBaseFix.getTargetClasses must not return null");
                return list;
            }
            result = new ArrayList<PsiClass>();
        } else {
            PsiClass[] supers = psiClass.getSupers();
            ArrayList<PsiClass> filtered = new ArrayList<PsiClass>();
            for (PsiClass aSuper : supers) {
                if (!aSuper.getManager().isInProject((PsiElement)aSuper) || aSuper instanceof PsiTypeParameter) continue;
                filtered.add(aSuper);
            }
            list = filtered;
            if (list == null) throw new IllegalStateException("@NotNull method com/intellij/codeInsight/daemon/impl/quickfix/CreateFromUsageBaseFix.getTargetClasses must not return null");
            return list;
        }
        while (psiClass != null) {
            result.add(psiClass);
            if (psiClass.hasModifierProperty("static")) break;
            psiClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)psiClass, PsiClass.class);
        }
        if ((list = result) != null) return list;
        throw new IllegalStateException("@NotNull method com/intellij/codeInsight/daemon/impl/quickfix/CreateFromUsageBaseFix.getTargetClasses must not return null");
    }

    protected static void startTemplate(@NotNull Editor editor, Template template, @NotNull Project project) {
        if (editor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/quickfix/CreateFromUsageBaseFix.startTemplate must not be null");
        }
        if (project == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/quickfix/CreateFromUsageBaseFix.startTemplate must not be null");
        }
        CreateFromUsageBaseFix.startTemplate(editor, template, project, null);
    }

    protected static void startTemplate(final @NotNull Editor editor, final Template template, final @NotNull Project project, final TemplateEditingListener listener) {
        if (editor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/quickfix/CreateFromUsageBaseFix.startTemplate must not be null");
        }
        if (project == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/quickfix/CreateFromUsageBaseFix.startTemplate must not be null");
        }
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                if (project.isDisposed() || editor.isDisposed()) {
                    return;
                }
                TemplateManager.getInstance(project).startTemplate(editor, template, listener);
            }
        };
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            runnable.run();
        } else {
            ApplicationManager.getApplication().invokeLater(runnable);
        }
    }
}

