/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.controlflow;

import com.intellij.codeInsight.controlflow.Instruction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.PsiElement;
import java.util.Arrays;

public class ControlFlowUtil {
    private static final Logger LOG = Logger.getInstance((String)ControlFlowUtil.class.getName());

    private ControlFlowUtil() {
    }

    public static int[] postOrder(Instruction[] flow) {
        int length = flow.length;
        int[] result = new int[length];
        boolean[] visited = new boolean[length];
        Arrays.fill(visited, false);
        Stack stack = new Stack(length);
        int N = 0;
        for (int i = 0; i < length; ++i) {
            if (visited[i]) continue;
            visited[i] = true;
            stack.clear();
            stack.push(i);
            while (!stack.isEmpty()) {
                int num = stack.pop();
                result[N++] = num;
                for (Instruction succ : flow[num].allSucc()) {
                    int succNum = succ.num();
                    if (visited[succNum]) continue;
                    visited[succNum] = true;
                    stack.push(succNum);
                }
            }
        }
        LOG.assertTrue(N == length);
        return result;
    }

    public static int findInstructionNumberByElement(Instruction[] flow, PsiElement element) {
        for (int i = 0; i < flow.length; ++i) {
            if (element != flow[i].getElement()) continue;
            return i;
        }
        return -1;
    }

    public static class Stack {
        private final int myCapacity;
        private final int[] myValues;
        private int myIndex;

        public Stack(int capacity) {
            this.myCapacity = capacity;
            this.myValues = new int[this.myCapacity];
            this.clear();
        }

        public void push(int value) {
            this.myValues[++this.myIndex] = value;
        }

        public int pop() {
            assert (!this.isEmpty()) : "Cannot pop on empty stack";
            return this.myValues[this.myIndex--];
        }

        public boolean isEmpty() {
            return this.myIndex == -1;
        }

        public void clear() {
            this.myIndex = -1;
        }

        public String toString() {
            return "Stack(" + (this.myIndex + 1) + ") elements";
        }
    }
}

