/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.codeInsight.TailType;
import com.intellij.codeInsight.completion.CompletionData;
import com.intellij.codeInsight.completion.CompletionDataEP;
import com.intellij.codeInsight.completion.CompletionInitializationContext;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionVariant;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.completion.OffsetMap;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupItem;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.filters.TrueFilter;
import com.intellij.util.containers.HashMap;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CompletionUtil {
    public static final Key<TailType> TAIL_TYPE_ATTR = LookupItem.TAIL_TYPE_ATTR;
    private static final CompletionData ourGenericCompletionData = new CompletionData(){
        {
            CompletionVariant variant = new CompletionVariant(PsiElement.class, TrueFilter.INSTANCE);
            variant.addCompletionFilter(TrueFilter.INSTANCE, TailType.NONE);
            this.registerVariant(variant);
        }
    };
    private static final HashMap<FileType, NotNullLazyValue<CompletionData>> ourCustomCompletionDatas = new HashMap();
    @NonNls
    public static final String DUMMY_IDENTIFIER = "IntellijIdeaRulezzz ";
    @NonNls
    public static final String DUMMY_IDENTIFIER_TRIMMED = "IntellijIdeaRulezzz ".trim();

    public static boolean startsWith(String text, String prefix) {
        return CompletionUtil.toLowerCase(text).startsWith(CompletionUtil.toLowerCase(prefix));
    }

    private static String toLowerCase(String text) {
        CodeInsightSettings settings = CodeInsightSettings.getInstance();
        switch (settings.COMPLETION_CASE_SENSITIVE) {
            case 2: {
                return text.toLowerCase();
            }
            case 3: {
                StringBuffer buffer = new StringBuffer();
                buffer.append(text.toLowerCase());
                if (buffer.length() > 0) {
                    buffer.setCharAt(0, text.charAt(0));
                }
                return buffer.toString();
            }
        }
        return text;
    }

    public static CompletionData getCompletionDataByElement(PsiFile file) {
        CompletionData mainData = CompletionUtil.getCompletionDataByFileType(file.getFileType());
        return mainData != null ? mainData : ourGenericCompletionData;
    }

    public static void registerCompletionData(FileType fileType, NotNullLazyValue<CompletionData> completionData) {
        ourCustomCompletionDatas.put((Object)fileType, completionData);
    }

    public static void registerCompletionData(FileType fileType, final CompletionData completionData) {
        CompletionUtil.registerCompletionData(fileType, new NotNullLazyValue<CompletionData>(){

            @NotNull
            protected CompletionData compute() {
                CompletionData completionData2 = completionData;
                if (completionData2 == null) {
                    throw new IllegalStateException("@NotNull method com/intellij/codeInsight/completion/CompletionUtil$2.compute must not return null");
                }
                return completionData2;
            }
        });
    }

    @Nullable
    public static CompletionData getCompletionDataByFileType(FileType fileType) {
        for (CompletionDataEP ep : (CompletionDataEP[])Extensions.getExtensions(CompletionDataEP.EP_NAME)) {
            if (!ep.fileType.equals(fileType.getName())) continue;
            return ep.getHandler();
        }
        NotNullLazyValue lazyValue = (NotNullLazyValue)ourCustomCompletionDatas.get((Object)fileType);
        return lazyValue == null ? null : (CompletionData)lazyValue.getValue();
    }

    static boolean isOverwrite(LookupElement item, char completionChar) {
        return completionChar != '\u0000' ? completionChar == '\t' : item.getUserData(LookupItem.OVERWRITE_ON_AUTOCOMPLETE_ATTR) != null;
    }

    public static boolean shouldShowFeature(CompletionParameters parameters, @NonNls String id) {
        return FeatureUsageTracker.getInstance().isToBeShown(id, parameters.getPosition().getProject());
    }

    public static String findJavaIdentifierPrefix(PsiElement insertedElement, int offset) {
        return CompletionUtil.findIdentifierPrefix(insertedElement, offset, (ElementPattern<Character>)PlatformPatterns.character().javaIdentifierPart(), (ElementPattern<Character>)PlatformPatterns.character().javaIdentifierStart());
    }

    public static String findIdentifierPrefix(PsiElement insertedElement, int offset, ElementPattern<Character> idPart, ElementPattern<Character> idStart) {
        int start;
        if (insertedElement == null) {
            return "";
        }
        String text = insertedElement.getText();
        int offsetInElement = offset - insertedElement.getTextRange().getStartOffset();
        for (start = offsetInElement - 1; start >= 0 && idPart.accepts((Object)Character.valueOf(text.charAt(start))); --start) {
        }
        while (start + 1 < offsetInElement && !idStart.accepts((Object)Character.valueOf(text.charAt(start + 1)))) {
            ++start;
        }
        return text.substring(start + 1, offsetInElement).trim();
    }

    static InsertionContext emulateInsertion(InsertionContext oldContext, int newStart, LookupElement item) {
        InsertionContext newContext = CompletionUtil.newContext(oldContext, item);
        CompletionUtil.emulateInsertion(item, newStart, newContext);
        return newContext;
    }

    private static InsertionContext newContext(InsertionContext oldContext, LookupElement forElement) {
        Editor editor = oldContext.getEditor();
        return new InsertionContext(new OffsetMap(editor.getDocument()), '\u0000', new LookupElement[]{forElement}, oldContext.getFile(), editor);
    }

    public static InsertionContext newContext(InsertionContext oldContext, LookupElement forElement, int startOffset, int tailOffset) {
        InsertionContext context = CompletionUtil.newContext(oldContext, forElement);
        CompletionUtil.setOffsets(context, startOffset, tailOffset);
        return context;
    }

    public static void emulateInsertion(LookupElement item, int offset, InsertionContext context) {
        CompletionUtil.setOffsets(context, offset, offset);
        Editor editor = context.getEditor();
        Document document = editor.getDocument();
        String lookupString = item.getLookupString();
        document.insertString(offset, (CharSequence)lookupString);
        editor.getCaretModel().moveToOffset(context.getTailOffset());
        PsiDocumentManager.getInstance((Project)context.getProject()).commitDocument(document);
        item.handleInsert(context);
    }

    private static void setOffsets(InsertionContext context, int offset, int tailOffset) {
        OffsetMap offsetMap = context.getOffsetMap();
        offsetMap.addOffset(CompletionInitializationContext.START_OFFSET, offset);
        offsetMap.addOffset(CompletionInitializationContext.IDENTIFIER_END_OFFSET, tailOffset);
        offsetMap.addOffset(CompletionInitializationContext.SELECTION_END_OFFSET, tailOffset);
        context.setTailOffset(tailOffset);
    }
}

