/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.actions;

import com.intellij.application.options.editor.EditorOptions;
import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.actions.LayoutCodeDialog;
import com.intellij.codeInsight.actions.LayoutProjectCodeDialog;
import com.intellij.codeInsight.actions.ReformatAndOptimizeImportsProcessor;
import com.intellij.codeInsight.actions.ReformatCodeProcessor;
import com.intellij.codeInsight.actions.ReformatFilesDialog;
import com.intellij.formatting.FormattingModelBuilder;
import com.intellij.lang.LanguageFormatting;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorSettingsExternalizable;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.ex.WindowManagerEx;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDirectoryContainer;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import java.awt.Component;
import java.util.ArrayList;
import javax.swing.JFrame;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class ReformatCodeAction
extends AnAction
implements DumbAware {
    @NonNls
    private static final String HELP_ID = "editing.codeReformatting";

    public void actionPerformed(AnActionEvent event) {
        PsiDirectory dir;
        DataContext dataContext = event.getDataContext();
        Project project = (Project)PlatformDataKeys.PROJECT.getData(dataContext);
        if (project == null) {
            return;
        }
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        Editor editor = (Editor)PlatformDataKeys.EDITOR.getData(dataContext);
        VirtualFile[] files = (VirtualFile[])PlatformDataKeys.VIRTUAL_FILE_ARRAY.getData(dataContext);
        if (files == null) {
            return;
        }
        PsiFile file = null;
        boolean hasSelection = false;
        if (editor != null) {
            file = PsiDocumentManager.getInstance((Project)project).getPsiFile(editor.getDocument());
            if (file == null) {
                return;
            }
            dir = file.getContainingDirectory();
            hasSelection = editor.getSelectionModel().hasSelection();
        } else {
            if (ReformatCodeAction.areFiles(files)) {
                ReadonlyStatusHandler.OperationStatus operationStatus = ReadonlyStatusHandler.getInstance((Project)project).ensureFilesWritable(files);
                if (!operationStatus.hasReadonlyFiles()) {
                    ReformatFilesDialog reformatFilesDialog = new ReformatFilesDialog(project);
                    reformatFilesDialog.show();
                    if (!reformatFilesDialog.isOK()) {
                        return;
                    }
                    if (reformatFilesDialog.optimizeImports() && !DumbService.getInstance((Project)project).isDumb()) {
                        new ReformatAndOptimizeImportsProcessor(project, ReformatCodeAction.convertToPsiFiles(files, project)).run();
                    } else {
                        new ReformatCodeProcessor(project, ReformatCodeAction.convertToPsiFiles(files, project), null).run();
                    }
                }
                return;
            }
            Project projectContext = (Project)PlatformDataKeys.PROJECT_CONTEXT.getData(dataContext);
            Module moduleContext = (Module)LangDataKeys.MODULE_CONTEXT.getData(dataContext);
            if (projectContext != null || moduleContext != null) {
                String text = moduleContext != null ? CodeInsightBundle.message((String)"process.scope.module", (Object[])new Object[]{moduleContext.getModuleFilePath()}) : CodeInsightBundle.message((String)"process.scope.project", (Object[])new Object[]{projectContext.getPresentableUrl()});
                LayoutProjectCodeDialog dialog = new LayoutProjectCodeDialog(project, CodeInsightBundle.message((String)"process.reformat.code", (Object[])new Object[0]), text, true);
                dialog.show();
                if (!dialog.isOK()) {
                    return;
                }
                if (dialog.isOptimizeImports() && !DumbService.getInstance((Project)project).isDumb()) {
                    if (moduleContext != null) {
                        new ReformatAndOptimizeImportsProcessor(project, moduleContext).run();
                    } else {
                        new ReformatAndOptimizeImportsProcessor(projectContext).run();
                    }
                } else if (moduleContext != null) {
                    new ReformatCodeProcessor(project, moduleContext).run();
                } else {
                    new ReformatCodeProcessor(projectContext).run();
                }
                return;
            }
            PsiElement element = (PsiElement)LangDataKeys.PSI_ELEMENT.getData(dataContext);
            if (element == null) {
                return;
            }
            if (element instanceof PsiDirectoryContainer) {
                dir = ((PsiDirectoryContainer)element).getDirectories()[0];
            } else if (element instanceof PsiDirectory) {
                dir = (PsiDirectory)element;
            } else {
                file = element.getContainingFile();
                if (file == null) {
                    return;
                }
                dir = file.getContainingDirectory();
            }
        }
        boolean optimizeImports = ReformatFilesDialog.isOptmizeImportsOptionOn();
        if (EditorSettingsExternalizable.getInstance().getOptions().SHOW_REFORMAT_DIALOG) {
            LayoutCodeDialog dialog = new LayoutCodeDialog(project, CodeInsightBundle.message((String)"process.reformat.code", (Object[])new Object[0]), file, dir, hasSelection ? Boolean.TRUE : Boolean.FALSE, HELP_ID);
            dialog.show();
            if (!dialog.isOK()) {
                return;
            }
            EditorSettingsExternalizable.getInstance().getOptions().SHOW_REFORMAT_DIALOG = !dialog.isDoNotAskMe();
            ReformatCodeAction.updateShowDialogSetting(dialog, "\"Reformat Code\" dialog disabled");
            optimizeImports = dialog.isOptimizeImports();
            if (dialog.isProcessDirectory()) {
                if (optimizeImports) {
                    new ReformatAndOptimizeImportsProcessor(project, dir, dialog.isIncludeSubdirectories()).run();
                } else {
                    new ReformatCodeProcessor(project, dir, dialog.isIncludeSubdirectories()).run();
                }
                return;
            }
        }
        TextRange range = editor != null && editor.getSelectionModel().hasSelection() ? new TextRange(editor.getSelectionModel().getSelectionStart(), editor.getSelectionModel().getSelectionEnd()) : null;
        if (optimizeImports && range == null) {
            new ReformatAndOptimizeImportsProcessor(project, file).run();
        } else {
            new ReformatCodeProcessor(project, file, range).run();
        }
    }

    public static void updateShowDialogSetting(LayoutCodeDialog dialog, String title) {
        if (dialog.isDoNotAskMe()) {
            Notifications.Bus.notify((Notification)new Notification("settings", title, "<html>You can re-enable the dialog on the <a href=''>IDE Settings -> Editor</a> pane</html>", NotificationType.INFORMATION, new NotificationListener(){

                public void hyperlinkUpdate(@NotNull Notification notification, @NotNull HyperlinkEvent e) {
                    if (notification == null) {
                        throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/actions/ReformatCodeAction$1.hyperlinkUpdate must not be null");
                    }
                    if (e == null) {
                        throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/codeInsight/actions/ReformatCodeAction$1.hyperlinkUpdate must not be null");
                    }
                    if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                        EditorOptions editorOptions = (EditorOptions)ShowSettingsUtil.getInstance().findApplicationConfigurable(EditorOptions.class);
                        IdeFrame ideFrame = WindowManagerEx.getInstanceEx().findFrameFor(null);
                        ShowSettingsUtil.getInstance().editConfigurable((Component)((JFrame)ideFrame), (Configurable)editorOptions);
                    }
                }
            }));
        }
    }

    public static PsiFile[] convertToPsiFiles(VirtualFile[] files, Project project) {
        PsiManager manager = PsiManager.getInstance((Project)project);
        ArrayList<PsiFile> result = new ArrayList<PsiFile>();
        for (VirtualFile virtualFile : files) {
            PsiFile psiFile = manager.findFile(virtualFile);
            if (psiFile == null) continue;
            result.add(psiFile);
        }
        return result.toArray(new PsiFile[result.size()]);
    }

    public void update(AnActionEvent event) {
        Presentation presentation = event.getPresentation();
        DataContext dataContext = event.getDataContext();
        Project project = (Project)PlatformDataKeys.PROJECT.getData(dataContext);
        if (project == null) {
            presentation.setEnabled(false);
            return;
        }
        Editor editor = (Editor)PlatformDataKeys.EDITOR.getData(dataContext);
        VirtualFile[] files = (VirtualFile[])PlatformDataKeys.VIRTUAL_FILE_ARRAY.getData(dataContext);
        if (editor != null) {
            PsiFile file = PsiDocumentManager.getInstance((Project)project).getPsiFile(editor.getDocument());
            if (file == null || file.getVirtualFile() == null) {
                presentation.setEnabled(false);
                return;
            }
            if (LanguageFormatting.INSTANCE.forContext((PsiElement)file) != null) {
                presentation.setEnabled(true);
                return;
            }
        } else if (files != null && ReformatCodeAction.areFiles(files)) {
            boolean anyFormatters = false;
            for (VirtualFile virtualFile : files) {
                if (virtualFile.isDirectory()) {
                    presentation.setEnabled(false);
                    return;
                }
                PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(virtualFile);
                if (psiFile == null) {
                    presentation.setEnabled(false);
                    return;
                }
                FormattingModelBuilder builder = LanguageFormatting.INSTANCE.forContext((PsiElement)psiFile);
                if (builder == null) continue;
                anyFormatters = true;
            }
            if (!anyFormatters) {
                presentation.setEnabled(false);
                return;
            }
        } else if ((files == null || files.length != 1) && LangDataKeys.MODULE_CONTEXT.getData(dataContext) == null && PlatformDataKeys.PROJECT_CONTEXT.getData(dataContext) == null) {
            PsiFile file;
            PsiElement element = (PsiElement)LangDataKeys.PSI_ELEMENT.getData(dataContext);
            if (element == null) {
                presentation.setEnabled(false);
                return;
            }
            if (!(element instanceof PsiDirectory || (file = element.getContainingFile()) != null && LanguageFormatting.INSTANCE.forContext((PsiElement)file) != null)) {
                presentation.setEnabled(false);
                return;
            }
        }
        presentation.setEnabled(true);
    }

    public static boolean areFiles(VirtualFile[] files) {
        if (files == null) {
            return false;
        }
        if (files.length < 2) {
            return false;
        }
        for (VirtualFile virtualFile : files) {
            if (!virtualFile.isDirectory()) continue;
            return false;
        }
        return true;
    }
}

