/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.actions;

import com.intellij.codeInsight.CodeInsightActionHandler;
import com.intellij.codeInsight.actions.BaseCodeInsightAction;
import com.intellij.openapi.actionSystem.ActionPlaces;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlProcessingInstruction;
import com.intellij.psi.xml.XmlProlog;
import com.intellij.util.IncorrectOperationException;
import com.intellij.xml.util.XmlUtil;
import org.jetbrains.annotations.NotNull;

public class GenerateDTDAction
extends BaseCodeInsightAction {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.actions.GenerateDTDAction");

    protected CodeInsightActionHandler getHandler() {
        return new CodeInsightActionHandler(){

            public void invoke(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file) {
                if (project == null) {
                    throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/actions/GenerateDTDAction$1.invoke must not be null");
                }
                if (editor == null) {
                    throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/codeInsight/actions/GenerateDTDAction$1.invoke must not be null");
                }
                if (file == null) {
                    throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/codeInsight/actions/GenerateDTDAction$1.invoke must not be null");
                }
                if (file instanceof XmlFile && file.getVirtualFile() != null && file.getVirtualFile().isWritable()) {
                    StringBuffer buffer = new StringBuffer();
                    XmlDocument document = ((XmlFile)file).getDocument();
                    if (document.getRootTag() != null) {
                        buffer.append("<!DOCTYPE " + document.getRootTag().getName() + " [\n");
                        buffer.append(XmlUtil.generateDocumentDTD(document, true));
                        buffer.append("]>\n");
                        try {
                            XmlProlog prolog = document.getProlog();
                            PsiElement childOfType = PsiTreeUtil.getChildOfType((PsiElement)prolog, XmlProcessingInstruction.class);
                            if (childOfType != null) {
                                String text = childOfType.getText();
                                buffer.insert(0, text);
                                PsiElement nextSibling = childOfType.getNextSibling();
                                if (nextSibling instanceof PsiWhiteSpace) {
                                    buffer.insert(text.length(), nextSibling.getText());
                                }
                            }
                            XmlFile tempFile = (XmlFile)PsiFileFactory.getInstance((Project)file.getProject()).createFileFromText("dummy.xml", buffer.toString());
                            prolog.replace((PsiElement)tempFile.getDocument().getProlog());
                        }
                        catch (IncorrectOperationException e) {
                            LOG.error((Throwable)e);
                        }
                    }
                }
            }

            public boolean startInWriteAction() {
                return true;
            }
        };
    }

    @Override
    public void update(AnActionEvent event) {
        boolean enabled;
        super.update(event);
        DataContext dataContext = event.getDataContext();
        Presentation presentation = event.getPresentation();
        Editor editor = (Editor)PlatformDataKeys.EDITOR.getData(dataContext);
        Project project = (Project)PlatformDataKeys.PROJECT.getData(dataContext);
        if (editor != null && project != null) {
            PsiFile file = PsiDocumentManager.getInstance((Project)project).getPsiFile(editor.getDocument());
            enabled = file instanceof XmlFile;
        } else {
            enabled = false;
        }
        presentation.setEnabled(enabled);
        if (ActionPlaces.isPopupPlace((String)event.getPlace())) {
            presentation.setVisible(enabled);
        }
    }

    protected boolean isValidForFile(Project project, Editor editor, PsiFile file) {
        return file instanceof XmlFile;
    }
}

