/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeEditor.printing;

import com.intellij.codeEditor.printing.FileSeparatorProvider;
import com.intellij.codeInsight.daemon.LineMarkerInfo;
import com.intellij.codeInsight.daemon.impl.LineMarkersPass;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.psi.PsiFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class MethodSeparatorProvider
extends FileSeparatorProvider {
    @Override
    public List<LineMarkerInfo> getFileSeparators(final PsiFile file, final Document document) {
        final ArrayList<LineMarkerInfo> result = new ArrayList<LineMarkerInfo>();
        ApplicationManager.getApplication().runReadAction(new Runnable(){

            @Override
            public void run() {
                LineMarkersPass action = new LineMarkersPass(file.getProject(), file, document, 0, file.getTextLength(), true);
                Collection<LineMarkerInfo> lineMarkerInfos = action.queryLineMarkers();
                for (LineMarkerInfo lineMarkerInfo : lineMarkerInfos) {
                    if (lineMarkerInfo.separatorColor == null) continue;
                    result.add(lineMarkerInfo);
                }
            }
        });
        Collections.sort(result, new Comparator<LineMarkerInfo>(){

            @Override
            public int compare(LineMarkerInfo i1, LineMarkerInfo i2) {
                return i1.startOffset - i2.startOffset;
            }
        });
        return result;
    }
}

