/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.visibility;

import com.intellij.psi.PsiCatchSection;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.fixes.RenameFix;
import com.siyeh.ig.psiutils.ClassUtils;
import com.siyeh.ig.ui.MultipleCheckboxOptionsPanel;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class LocalVariableHidingMemberVariableInspection
extends BaseInspection {
    public boolean m_ignoreInvisibleFields = true;
    public boolean m_ignoreStaticMethods = true;

    @NotNull
    public String getID() {
        if ("LocalVariableHidesMemberVariable" == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/visibility/LocalVariableHidingMemberVariableInspection.getID must not return null");
        }
        return "LocalVariableHidesMemberVariable";
    }

    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("local.variable.hides.member.variable.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/visibility/LocalVariableHidingMemberVariableInspection.getDisplayName must not return null");
        }
        return string;
    }

    @Override
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new RenameFix();
    }

    @Override
    protected boolean buildQuickFixesOnlyForOnTheFlyErrors() {
        return true;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("local.variable.hides.member.variable.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/visibility/LocalVariableHidingMemberVariableInspection.buildErrorString must not return null");
        }
        return string;
    }

    public JComponent createOptionsPanel() {
        MultipleCheckboxOptionsPanel optionsPanel = new MultipleCheckboxOptionsPanel(this);
        optionsPanel.addCheckbox(InspectionGadgetsBundle.message("field.name.hides.in.superclass.ignore.option", new Object[0]), "m_ignoreInvisibleFields");
        optionsPanel.addCheckbox(InspectionGadgetsBundle.message("local.variable.hides.member.variable.ignore.option", new Object[0]), "m_ignoreStaticMethods");
        return optionsPanel;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new LocalVariableHidingMemberVariableVisitor();
    }

    private class LocalVariableHidingMemberVariableVisitor
    extends BaseInspectionVisitor {
        private LocalVariableHidingMemberVariableVisitor() {
        }

        public void visitLocalVariable(@NotNull PsiLocalVariable variable) {
            PsiField[] fields;
            PsiClass aClass;
            if (variable == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/visibility/LocalVariableHidingMemberVariableInspection$LocalVariableHidingMemberVariableVisitor.visitLocalVariable must not be null");
            }
            super.visitLocalVariable(variable);
            if (LocalVariableHidingMemberVariableInspection.this.m_ignoreStaticMethods) {
                PsiMethod aMethod = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)variable, PsiMethod.class);
                if (aMethod == null) {
                    return;
                }
                if (aMethod.hasModifierProperty("static")) {
                    return;
                }
            }
            if ((aClass = ClassUtils.getContainingClass((PsiElement)variable)) == null) {
                return;
            }
            String variableName = variable.getName();
            for (PsiField field : fields = aClass.getAllFields()) {
                if (!this.checkFieldName(field, variableName, aClass)) continue;
                this.registerVariableError((PsiVariable)variable, new Object[0]);
            }
        }

        public void visitParameter(@NotNull PsiParameter variable) {
            PsiField[] fields;
            if (variable == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/visibility/LocalVariableHidingMemberVariableInspection$LocalVariableHidingMemberVariableVisitor.visitParameter must not be null");
            }
            super.visitParameter(variable);
            if (!(variable.getDeclarationScope() instanceof PsiCatchSection)) {
                return;
            }
            PsiClass aClass = ClassUtils.getContainingClass((PsiElement)variable);
            if (aClass == null) {
                return;
            }
            String variableName = variable.getName();
            for (PsiField field : fields = aClass.getAllFields()) {
                if (!this.checkFieldName(field, variableName, aClass)) continue;
                this.registerVariableError((PsiVariable)variable, new Object[0]);
            }
        }

        private boolean checkFieldName(PsiField field, String variableName, PsiClass aClass) {
            if (field == null) {
                return false;
            }
            String fieldName = field.getName();
            if (fieldName == null) {
                return false;
            }
            if (!fieldName.equals(variableName)) {
                return false;
            }
            return !LocalVariableHidingMemberVariableInspection.this.m_ignoreInvisibleFields || ClassUtils.isFieldVisible(field, aClass);
        }
    }
}

