/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.serialization;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.psiutils.SerializationUtils;
import org.jetbrains.annotations.NotNull;

public class TransientFieldInNonSerializableClassInspection
extends BaseInspection {
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("transient.field.in.non.serializable.class.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/serialization/TransientFieldInNonSerializableClassInspection.getDisplayName must not return null");
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        PsiField field = (PsiField)infos[0];
        String string = InspectionGadgetsBundle.message("transient.field.in.non.serializable.class.problem.descriptor", field.getName());
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/serialization/TransientFieldInNonSerializableClassInspection.buildErrorString must not return null");
        }
        return string;
    }

    @Override
    public InspectionGadgetsFix buildFix(Object ... infos) {
        return new TransientFieldInNonSerializableClassFix();
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new TransientFieldInNonSerializableClassVisitor();
    }

    private static class TransientFieldInNonSerializableClassVisitor
    extends BaseInspectionVisitor {
        private TransientFieldInNonSerializableClassVisitor() {
        }

        public void visitField(@NotNull PsiField field) {
            if (field == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/serialization/TransientFieldInNonSerializableClassInspection$TransientFieldInNonSerializableClassVisitor.visitField must not be null");
            }
            if (!field.hasModifierProperty("transient")) {
                return;
            }
            PsiClass aClass = field.getContainingClass();
            if (SerializationUtils.isSerializable(aClass)) {
                return;
            }
            this.registerModifierError("transient", (PsiModifierListOwner)field, field);
        }
    }

    private static class TransientFieldInNonSerializableClassFix
    extends InspectionGadgetsFix {
        private TransientFieldInNonSerializableClassFix() {
        }

        @NotNull
        public String getName() {
            String string = InspectionGadgetsBundle.message("transient.field.in.non.serializable.class.remove.quickfix", new Object[0]);
            if (string == null) {
                throw new IllegalStateException("@NotNull method com/siyeh/ig/serialization/TransientFieldInNonSerializableClassInspection$TransientFieldInNonSerializableClassFix.getName must not return null");
            }
            return string;
        }

        @Override
        public void doFix(Project project, ProblemDescriptor descriptor) throws IncorrectOperationException {
            PsiElement transientModifier = descriptor.getPsiElement();
            TransientFieldInNonSerializableClassFix.deleteElement(transientModifier);
        }
    }
}

