/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.performance;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.psiutils.ClassUtils;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import org.jetbrains.annotations.NotNull;

public class BooleanConstructorInspection
extends BaseInspection {
    @NotNull
    public String getID() {
        if ("BooleanConstructorCall" == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/performance/BooleanConstructorInspection.getID must not return null");
        }
        return "BooleanConstructorCall";
    }

    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("boolean.constructor.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/performance/BooleanConstructorInspection.getDisplayName must not return null");
        }
        return string;
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("boolean.constructor.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/performance/BooleanConstructorInspection.buildErrorString must not return null");
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new BooleanConstructorVisitor();
    }

    @Override
    public InspectionGadgetsFix buildFix(Object ... infos) {
        return new BooleanConstructorFix();
    }

    private static class BooleanConstructorVisitor
    extends BaseInspectionVisitor {
        private BooleanConstructorVisitor() {
        }

        public void visitNewExpression(@NotNull PsiNewExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/performance/BooleanConstructorInspection$BooleanConstructorVisitor.visitNewExpression must not be null");
            }
            super.visitNewExpression(expression);
            PsiType type = expression.getType();
            if (type == null || !type.equalsToText("java.lang.Boolean")) {
                return;
            }
            PsiClass aClass = ClassUtils.getContainingClass((PsiElement)expression);
            if (aClass != null && "java.lang.Boolean".equals(aClass.getQualifiedName())) {
                return;
            }
            this.registerError((PsiElement)expression, new Object[0]);
        }
    }

    private static class BooleanConstructorFix
    extends InspectionGadgetsFix {
        private static final String TRUE = "\"true\"";
        private static final String FALSE = "\"false\"";

        private BooleanConstructorFix() {
        }

        @NotNull
        public String getName() {
            String string = InspectionGadgetsBundle.message("boolean.aonstructor.simplify.quickfix", new Object[0]);
            if (string == null) {
                throw new IllegalStateException("@NotNull method com/siyeh/ig/performance/BooleanConstructorInspection$BooleanConstructorFix.getName must not return null");
            }
            return string;
        }

        @Override
        public void doFix(Project project, ProblemDescriptor descriptor) throws IncorrectOperationException {
            PsiType argType;
            PsiNewExpression expression = (PsiNewExpression)descriptor.getPsiElement();
            PsiExpressionList argList = expression.getArgumentList();
            assert (argList != null);
            PsiExpression[] args = argList.getExpressions();
            PsiExpression arg = args[0];
            String text = arg.getText();
            LanguageLevel languageLevel = PsiUtil.getLanguageLevel((PsiElement)expression);
            String newExpression = "true".equals(text) || TRUE.equalsIgnoreCase(text) ? "Boolean.TRUE" : ("false".equals(text) || FALSE.equalsIgnoreCase(text) ? "Boolean.FALSE" : (languageLevel.equals((Object)LanguageLevel.JDK_1_3) ? (PsiType.BOOLEAN.equals(argType = arg.getType()) ? (ParenthesesUtils.getPrecedence(arg) > 15 ? text + "?Boolean.TRUE:Boolean.FALSE" : '(' + text + ")?Boolean.TRUE:Boolean.FALSE") : "Boolean.valueOf(" + text + ')') : "Boolean.valueOf(" + text + ')'));
            BooleanConstructorFix.replaceExpression((PsiExpression)expression, newExpression);
        }
    }
}

