/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.junit;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.ClassUtils;
import com.siyeh.ig.psiutils.TypeUtils;
import org.jetbrains.annotations.NotNull;

public class UnconstructableTestCaseInspection
extends BaseInspection {
    @NotNull
    public String getID() {
        if ("UnconstructableJUnitTestCase" == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/junit/UnconstructableTestCaseInspection.getID must not return null");
        }
        return "UnconstructableJUnitTestCase";
    }

    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("unconstructable.test.case.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/junit/UnconstructableTestCaseInspection.getDisplayName must not return null");
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("unconstructable.test.case.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/junit/UnconstructableTestCaseInspection.buildErrorString must not return null");
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new UnconstructableTestCaseVisitor();
    }

    private static class UnconstructableTestCaseVisitor
    extends BaseInspectionVisitor {
        private UnconstructableTestCaseVisitor() {
        }

        public void visitClass(@NotNull PsiClass aClass) {
            if (aClass == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/junit/UnconstructableTestCaseInspection$UnconstructableTestCaseVisitor.visitClass must not be null");
            }
            if (aClass.isInterface() || aClass.isEnum() || aClass.isAnnotationType() || aClass.hasModifierProperty("abstract")) {
                return;
            }
            if (aClass instanceof PsiTypeParameter) {
                return;
            }
            if (!ClassUtils.isSubclass(aClass, "junit.framework.TestCase")) {
                return;
            }
            PsiMethod[] constructors = aClass.getConstructors();
            boolean hasStringConstructor = false;
            boolean hasNoArgConstructor = false;
            boolean hasConstructor = false;
            for (PsiMethod constructor : constructors) {
                PsiParameter[] parameters;
                PsiType type;
                hasConstructor = true;
                if (!constructor.hasModifierProperty("public")) continue;
                PsiParameterList parameterList = constructor.getParameterList();
                int parametersCount = parameterList.getParametersCount();
                if (parametersCount == 0) {
                    hasNoArgConstructor = true;
                }
                if (parametersCount != 1 || !TypeUtils.typeEquals("java.lang.String", type = (parameters = parameterList.getParameters())[0].getType())) continue;
                hasStringConstructor = true;
            }
            if (!hasConstructor) {
                return;
            }
            if (hasNoArgConstructor || hasStringConstructor) {
                return;
            }
            this.registerClassError(aClass, new Object[0]);
        }
    }
}

