/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.junit;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.ClassUtils;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class AssertsWithoutMessagesInspection
extends BaseInspection {
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("asserts.without.messages.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/junit/AssertsWithoutMessagesInspection.getDisplayName must not return null");
        }
        return string;
    }

    @NotNull
    public String getID() {
        if ("MessageMissingOnJUnitAssertion" == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/junit/AssertsWithoutMessagesInspection.getID must not return null");
        }
        return "MessageMissingOnJUnitAssertion";
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("asserts.without.messages.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/junit/AssertsWithoutMessagesInspection.buildErrorString must not return null");
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new AssertionsWithoutMessagesVisitor();
    }

    private static class AssertionsWithoutMessagesVisitor
    extends BaseInspectionVisitor {
        @NonNls
        private static final Set<String> s_assertMethods = new HashSet<String>(8);

        private AssertionsWithoutMessagesVisitor() {
        }

        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/junit/AssertsWithoutMessagesInspection$AssertionsWithoutMessagesVisitor.visitMethodCallExpression must not be null");
            }
            super.visitMethodCallExpression(expression);
            if (!AssertionsWithoutMessagesVisitor.isJUnitAssertion(expression)) {
                return;
            }
            PsiReferenceExpression methodExpression = expression.getMethodExpression();
            PsiMethod method = (PsiMethod)methodExpression.resolve();
            if (method == null) {
                return;
            }
            PsiParameterList parameterList = method.getParameterList();
            String methodName = method.getName();
            int parameterCount = parameterList.getParametersCount();
            if (parameterCount < 2 && methodName.startsWith("assert")) {
                this.registerMethodCallError(expression, new Object[0]);
                return;
            }
            if (parameterCount < 1) {
                this.registerMethodCallError(expression, new Object[0]);
                return;
            }
            PsiManager psiManager = expression.getManager();
            Project project = psiManager.getProject();
            GlobalSearchScope scope = GlobalSearchScope.allScope((Project)project);
            PsiClassType stringType = PsiType.getJavaLangString((PsiManager)psiManager, (GlobalSearchScope)scope);
            PsiParameter[] parameters = parameterList.getParameters();
            PsiType parameterType1 = parameters[0].getType();
            if (parameterType1.equals(stringType)) {
                PsiType parameterType2;
                if (parameters.length == 2 && (parameterType2 = parameters[1].getType()).equals(stringType)) {
                    this.registerMethodCallError(expression, new Object[0]);
                }
            } else {
                this.registerMethodCallError(expression, new Object[0]);
            }
        }

        private static boolean isJUnitAssertion(PsiMethodCallExpression expression) {
            PsiReferenceExpression methodExpression = expression.getMethodExpression();
            String methodName = methodExpression.getReferenceName();
            if (!s_assertMethods.contains(methodName)) {
                return false;
            }
            PsiMethod method = (PsiMethod)methodExpression.resolve();
            if (method == null) {
                return false;
            }
            PsiClass targetClass = method.getContainingClass();
            return targetClass != null && (ClassUtils.isSubclass(targetClass, "junit.framework.Assert") || ClassUtils.isSubclass(targetClass, "org.junit.Assert"));
        }

        static {
            s_assertMethods.add("assertTrue");
            s_assertMethods.add("assertFalse");
            s_assertMethods.add("assertEquals");
            s_assertMethods.add("assertNull");
            s_assertMethods.add("assertNotNull");
            s_assertMethods.add("assertSame");
            s_assertMethods.add("assertNotSame");
            s_assertMethods.add("fail");
        }
    }
}

