/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.global;

import com.intellij.analysis.AnalysisScope;
import com.intellij.codeInsight.daemon.GroupNames;
import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.GlobalInspectionContext;
import com.intellij.codeInspection.GlobalJavaInspectionContext;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptionsProcessor;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.reference.RefElement;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.reference.RefGraphAnnotator;
import com.intellij.codeInspection.reference.RefJavaVisitor;
import com.intellij.codeInspection.reference.RefManager;
import com.intellij.codeInspection.reference.RefMethod;
import com.intellij.codeInspection.reference.RefVisitor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Key;
import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseGlobalInspection;
import com.siyeh.ig.psiutils.MethodInheritanceUtils;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MethodReturnAlwaysIgnoredInspection
extends BaseGlobalInspection {
    private static final Logger LOG = Logger.getInstance((String)"MethodReturnAlwaysIgnoredInspection");
    private static final Key<Boolean> ALWAYS_IGNORED = Key.create((String)"ALWAYS_IGNORED_METHOD");

    @NotNull
    public String getGroupDisplayName() {
        String string = GroupNames.CLASSLAYOUT_GROUP_NAME;
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/global/MethodReturnAlwaysIgnoredInspection.getGroupDisplayName must not return null");
        }
        return string;
    }

    @Nullable
    public RefGraphAnnotator getAnnotator(RefManager refManager) {
        return new MethodIgnoredAnnotator();
    }

    public CommonProblemDescriptor[] checkElement(RefEntity refEntity, AnalysisScope scope, InspectionManager manager, GlobalInspectionContext globalContext) {
        CommonProblemDescriptor[] originalProblemDescriptors = super.checkElement(refEntity, scope, manager, globalContext);
        if (!(refEntity instanceof RefMethod)) {
            return null;
        }
        RefMethod refMethod = (RefMethod)refEntity;
        if (MethodReturnAlwaysIgnoredInspection.methodReturnUsed(refMethod)) {
            this.markSiblings(refMethod);
            return originalProblemDescriptors;
        }
        if (!(refMethod.getElement() instanceof PsiMethod)) {
            return originalProblemDescriptors;
        }
        PsiMethod method = (PsiMethod)refMethod.getElement();
        if (method == null) {
            return originalProblemDescriptors;
        }
        if (MethodInheritanceUtils.inheritsFromLibraryMethod(method)) {
            this.markSiblings(refMethod);
            return originalProblemDescriptors;
        }
        ProblemDescriptor descriptor = manager.createProblemDescriptor((PsiElement)method, InspectionGadgetsBundle.message("method.return.always.ignored.problem.descriptor", new Object[0]), false, (LocalQuickFix[])null, ProblemHighlightType.GENERIC_ERROR_OR_WARNING);
        if (originalProblemDescriptors == null) {
            return new ProblemDescriptor[]{descriptor};
        }
        int numDescriptors = originalProblemDescriptors.length;
        ProblemDescriptor[] descriptors = new ProblemDescriptor[numDescriptors + 1];
        System.arraycopy(originalProblemDescriptors, 0, numDescriptors + 1, 0, numDescriptors);
        descriptors[numDescriptors] = descriptor;
        return descriptors;
    }

    private void markSiblings(RefMethod refMethod) {
        Set<RefMethod> siblingMethods = MethodInheritanceUtils.calculateSiblingMethods(refMethod);
        for (RefMethod siblingMethod : siblingMethods) {
            siblingMethod.putUserData(ALWAYS_IGNORED, (Object)false);
        }
    }

    private static boolean methodReturnUsed(RefMethod refMethod) {
        Boolean alwaysIgnored = (Boolean)refMethod.getUserData(ALWAYS_IGNORED);
        return alwaysIgnored == null || alwaysIgnored == false;
    }

    protected boolean queryExternalUsagesRequests(RefManager manager, final GlobalJavaInspectionContext context, final ProblemDescriptionsProcessor descriptionsProcessor) {
        manager.iterate((RefVisitor)new RefJavaVisitor(){

            public void visitMethod(final RefMethod refMethod) {
                if (MethodReturnAlwaysIgnoredInspection.methodReturnUsed(refMethod)) {
                    return;
                }
                GlobalJavaInspectionContext.UsagesProcessor usagesProcessor = new GlobalJavaInspectionContext.UsagesProcessor(){

                    public boolean process(PsiReference psiReference) {
                        PsiElement psiReferenceExpression = psiReference.getElement();
                        PsiElement parent = psiReferenceExpression.getParent();
                        if (parent instanceof PsiMethodCallExpression && !MethodReturnAlwaysIgnoredInspection.isIgnoredMethodCall((PsiCallExpression)parent)) {
                            descriptionsProcessor.ignoreElement((RefEntity)refMethod);
                        }
                        return false;
                    }
                };
                context.enqueueMethodUsagesProcessor(refMethod, usagesProcessor);
            }
        });
        return false;
    }

    private static boolean isIgnoredMethodCall(PsiCallExpression methodExpression) {
        PsiElement parent = methodExpression.getParent();
        return parent instanceof PsiExpressionStatement;
    }

    private static class MethodIgnoredAnnotator
    extends RefGraphAnnotator {
        private MethodIgnoredAnnotator() {
        }

        public void onInitialize(RefElement refElement) {
            super.onInitialize(refElement);
            if (!(refElement instanceof RefMethod)) {
                return;
            }
            RefMethod refMethod = (RefMethod)refElement;
            PsiElement element = refElement.getElement();
            if (!(element instanceof PsiMethod)) {
                return;
            }
            PsiMethod method = (PsiMethod)element;
            PsiType returnType = method.getReturnType();
            if (PsiType.VOID.equals(returnType)) {
                return;
            }
            LOG.info("onInitialize:" + refMethod.getName());
            refElement.putUserData(ALWAYS_IGNORED, (Object)true);
        }

        public void onMarkReferenced(RefElement refWhat, RefElement refFrom, boolean referencedFromClassInitializer) {
            super.onMarkReferenced(refWhat, refFrom, referencedFromClassInitializer);
            if (!(refWhat instanceof RefMethod)) {
                return;
            }
            final RefMethod refMethod = (RefMethod)refWhat;
            if (MethodReturnAlwaysIgnoredInspection.methodReturnUsed(refMethod)) {
                return;
            }
            PsiModifierListOwner psiElement = refMethod.getElement();
            if (!(psiElement instanceof PsiMethod)) {
                return;
            }
            final PsiMethod psiMethod = (PsiMethod)psiElement;
            LOG.info("onMarkReferenced:" + refMethod.getName());
            PsiElement element = refFrom.getElement();
            element.accept((PsiElementVisitor)new JavaRecursiveElementVisitor(){

                public void visitMethodCallExpression(PsiMethodCallExpression call) {
                    if (MethodReturnAlwaysIgnoredInspection.methodReturnUsed(refMethod)) {
                        return;
                    }
                    super.visitMethodCallExpression(call);
                    if (MethodReturnAlwaysIgnoredInspection.isIgnoredMethodCall((PsiCallExpression)call)) {
                        return;
                    }
                    PsiReferenceExpression methodExpression = call.getMethodExpression();
                    if (methodExpression.isReferenceTo((PsiElement)psiMethod)) {
                        refMethod.putUserData(ALWAYS_IGNORED, (Object)false);
                    }
                }

                public void visitNewExpression(PsiNewExpression call) {
                    if (MethodReturnAlwaysIgnoredInspection.methodReturnUsed(refMethod)) {
                        return;
                    }
                    super.visitNewExpression(call);
                    if (MethodReturnAlwaysIgnoredInspection.isIgnoredMethodCall((PsiCallExpression)call)) {
                        return;
                    }
                    PsiMethod referedMethod = call.resolveMethod();
                    if (psiMethod.equals(referedMethod)) {
                        refMethod.putUserData(ALWAYS_IGNORED, (Object)false);
                    }
                }
            });
        }
    }
}

