/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.classmetrics;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.classmetrics.ClassMetricInspection;
import org.jetbrains.annotations.NotNull;

public class ConstructorCountInspection
extends ClassMetricInspection {
    private static final int CONSTRUCTOR_COUNT_LIMIT = 5;

    @NotNull
    public String getID() {
        if ("ClassWithTooManyConstructors" == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/classmetrics/ConstructorCountInspection.getID must not return null");
        }
        return "ClassWithTooManyConstructors";
    }

    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("too.many.constructors.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/classmetrics/ConstructorCountInspection.getDisplayName must not return null");
        }
        return string;
    }

    @Override
    protected int getDefaultLimit() {
        return 5;
    }

    @Override
    protected String getConfigurationLabel() {
        return InspectionGadgetsBundle.message("too.many.constructors.count.limit.option", new Object[0]);
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        Integer count = (Integer)infos[0];
        String string = InspectionGadgetsBundle.message("too.many.constructors.problem.descriptor", count);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/classmetrics/ConstructorCountInspection.buildErrorString must not return null");
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ConstructorCountVisitor();
    }

    private class ConstructorCountVisitor
    extends BaseInspectionVisitor {
        private ConstructorCountVisitor() {
        }

        public void visitClass(@NotNull PsiClass aClass) {
            if (aClass == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/classmetrics/ConstructorCountInspection$ConstructorCountVisitor.visitClass must not be null");
            }
            int constructorCount = this.calculateTotalConstructorCount(aClass);
            if (constructorCount <= ConstructorCountInspection.this.getLimit()) {
                return;
            }
            this.registerClassError(aClass, constructorCount);
        }

        private int calculateTotalConstructorCount(PsiClass aClass) {
            PsiMethod[] methods = aClass.getMethods();
            int totalCount = 0;
            for (PsiMethod method : methods) {
                if (!method.isConstructor()) continue;
                ++totalCount;
            }
            return totalCount;
        }
    }
}

