/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.classlayout;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiModifierListOwner;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.fixes.RemoveModifierFix;
import org.jetbrains.annotations.NotNull;

public class FinalClassInspection
extends BaseInspection {
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("final.class.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/classlayout/FinalClassInspection.getDisplayName must not return null");
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("final.class.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/classlayout/FinalClassInspection.buildErrorString must not return null");
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new FinalStaticMethodVisitor();
    }

    @Override
    public InspectionGadgetsFix buildFix(Object ... infos) {
        return new RemoveModifierFix((String)infos[0]);
    }

    private static class FinalStaticMethodVisitor
    extends BaseInspectionVisitor {
        private FinalStaticMethodVisitor() {
        }

        public void visitClass(@NotNull PsiClass aClass) {
            if (aClass == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/classlayout/FinalClassInspection$FinalStaticMethodVisitor.visitClass must not be null");
            }
            if (!aClass.hasModifierProperty("final")) {
                return;
            }
            this.registerModifierError("final", (PsiModifierListOwner)aClass, "final");
        }
    }
}

