/*
 * Decompiled with CFR 0.152.
 */
package com.theoryinpractice.testng.configuration.browser;

import com.intellij.execution.JavaExecutionUtil;
import com.intellij.execution.configuration.BrowseModuleValueActionListener;
import com.intellij.ide.util.TreeClassChooser;
import com.intellij.ide.util.TreeClassChooserFactory;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ex.MessagesEx;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.search.GlobalSearchScope;
import com.theoryinpractice.testng.MessageInfoException;
import com.theoryinpractice.testng.configuration.TestNGConfiguration;
import com.theoryinpractice.testng.configuration.TestNGConfigurationEditor;
import com.theoryinpractice.testng.configuration.TestNGConfigurationType;
import com.theoryinpractice.testng.model.TestClassFilter;

public class TestClassBrowser
extends BrowseModuleValueActionListener {
    protected TestNGConfigurationEditor editor;

    public TestClassBrowser(Project project, TestNGConfigurationEditor editor) {
        super(project);
        this.editor = editor;
    }

    protected String showDialog() {
        TreeClassChooser.ClassFilterWithScope filter;
        try {
            filter = this.getFilter();
        }
        catch (MessageInfoException e) {
            MessagesEx.MessageInfo message = e.getMessageInfo();
            message.showNow();
            return null;
        }
        TreeClassChooser chooser = TreeClassChooserFactory.getInstance((Project)this.getProject()).createWithInnerClassesScopeChooser("Choose Test Class", filter.getScope(), (TreeClassChooser.ClassFilter)filter, null);
        this.init(chooser);
        chooser.showDialog();
        PsiClass psiclass = chooser.getSelectedClass();
        if (psiclass == null) {
            return null;
        }
        this.onClassChoosen(psiclass);
        return JavaExecutionUtil.getRuntimeQualifiedName((PsiClass)psiclass);
    }

    protected void onClassChoosen(PsiClass psiClass) {
    }

    protected PsiClass findClass(String className) {
        return this.editor.getModuleSelector().findClass(className);
    }

    protected TreeClassChooser.ClassFilterWithScope getFilter() throws MessageInfoException {
        TestNGConfiguration config = new TestNGConfiguration("<no-name>", this.getProject(), TestNGConfigurationType.getInstance().getConfigurationFactories()[0]);
        this.editor.applyEditorTo(config);
        GlobalSearchScope scope = this.getSearchScope(config.getModules());
        if (scope == null) {
            throw new MessageInfoException(new MessagesEx.MessageInfo(this.getProject(), "No classes found in project", "Can't Browse Tests"));
        }
        return new TestClassFilter(scope, this.getProject(), false);
    }

    protected GlobalSearchScope getSearchScope(Module[] modules) {
        if (modules == null || modules.length == 0) {
            return null;
        }
        GlobalSearchScope scope = GlobalSearchScope.moduleWithDependenciesScope((Module)modules[0]);
        for (int i = 1; i < modules.length; ++i) {
            scope.uniteWith(GlobalSearchScope.moduleWithDependenciesScope((Module)modules[i]));
        }
        return scope;
    }

    private void init(TreeClassChooser chooser) {
        String s = this.getText();
        PsiClass psiclass = this.findClass(s);
        if (psiclass == null) {
            return;
        }
        PsiDirectory psidirectory = psiclass.getContainingFile().getContainingDirectory();
        if (psidirectory != null) {
            chooser.selectDirectory(psidirectory);
        }
        chooser.selectClass(psiclass);
    }
}

