/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cvsSupport2.cvsoperations.dateOrRevision;

import org.netbeans.lib.cvsclient.command.Command;
import org.netbeans.lib.cvsclient.command.checkout.CheckoutCommand;
import org.netbeans.lib.cvsclient.command.checkout.ExportCommand;
import org.netbeans.lib.cvsclient.command.update.UpdateCommand;

public class CommandWrapper {
    private final Command myCommand;

    public CommandWrapper(Command command) {
        this.myCommand = command;
    }

    public void setUpdateByRevisionOrDate(String revision, String date) {
        if (this.isCheckoutCommand()) {
            this.asCheckoutCommand().setUpdateByRevisionOrTag(revision);
            this.asCheckoutCommand().setUpdateByDate(date);
        } else if (this.isUpdateCommand()) {
            this.asUpdateCommand().setUpdateByRevisionOrTag(revision);
            this.asUpdateCommand().setUpdateByDate(date);
        } else if (this.isExportCommand()) {
            this.asExportCommand().setUpdateByRevisionOrTag(revision == null && date == null ? "HEAD" : revision);
            this.asExportCommand().setUpdateByDate(date);
        }
    }

    private UpdateCommand asUpdateCommand() {
        return (UpdateCommand)this.myCommand;
    }

    private CheckoutCommand asCheckoutCommand() {
        return (CheckoutCommand)this.myCommand;
    }

    private ExportCommand asExportCommand() {
        return (ExportCommand)this.myCommand;
    }

    private boolean isUpdateCommand() {
        return this.myCommand instanceof UpdateCommand;
    }

    private boolean isCheckoutCommand() {
        return this.myCommand instanceof CheckoutCommand;
    }

    private boolean isExportCommand() {
        return this.myCommand instanceof ExportCommand;
    }
}

