/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cvsSupport2.cvsBrowser;

import com.intellij.CvsBundle;
import com.intellij.cvsSupport2.connections.CvsEnvironment;
import com.intellij.cvsSupport2.cvsBrowser.CvsElement;
import com.intellij.cvsSupport2.cvsBrowser.CvsElementFactory;
import com.intellij.cvsSupport2.cvsBrowser.GetContentCallback;
import com.intellij.cvsSupport2.cvsBrowser.ModuleDataProvider;
import com.intellij.cvsSupport2.cvsBrowser.RemoteResourceDataProvider;
import com.intellij.cvsSupport2.cvsExecution.CvsOperationExecutor;
import com.intellij.cvsSupport2.cvsExecution.CvsOperationExecutorCallback;
import com.intellij.cvsSupport2.cvsExecution.ModalityContext;
import com.intellij.cvsSupport2.cvshandlers.CommandCvsHandler;
import com.intellij.cvsSupport2.cvsoperations.common.CvsOperation;
import com.intellij.cvsSupport2.cvsoperations.cvsContent.DirectoryContent;
import com.intellij.cvsSupport2.cvsoperations.cvsContent.DirectoryContentProvider;
import com.intellij.cvsSupport2.cvsoperations.cvsContent.GetDirectoriesListViaUpdateOperation;
import com.intellij.cvsSupport2.cvsoperations.cvsMessages.CvsListenerWithProgress;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.project.Project;
import com.intellij.util.Consumer;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;

public abstract class AbstractVcsDataProvider
implements RemoteResourceDataProvider {
    protected final CvsEnvironment myEnvironment;
    protected final boolean myShowFiles;
    protected final boolean myShowModules;

    protected AbstractVcsDataProvider(CvsEnvironment environment, boolean showFiles, boolean showModules) {
        this.myEnvironment = environment;
        this.myShowFiles = showFiles;
        this.myShowModules = showModules;
    }

    @Override
    public void fillContentFor(CvsElement element, Project project, GetContentCallback callback) {
        this.collectTreeElementsTo(element, project, callback);
    }

    private void collectTreeElementsTo(CvsElement parent, Project project, GetContentCallback callback) {
        this.fillDirectoryContent(parent, parent.getElementPath(), callback, project);
    }

    private void fillDirectoryContent(final CvsElement parent, String path, final GetContentCallback callback, final Project project) {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            this.executeCommand(this.createDirectoryContentProvider(path), callback, parent, project);
        } else {
            GetDirectoriesListViaUpdateOperation provider = new GetDirectoriesListViaUpdateOperation(this.myEnvironment, path);
            MyBufferedConsumer consumer = new MyBufferedConsumer((Consumer)new Consumer<DirectoryContent>(){

                public void consume(DirectoryContent directoryContent) {
                    ArrayList elements = AbstractVcsDataProvider.this.directoryContentToElements(directoryContent, parent, project);
                    if (!elements.isEmpty()) {
                        callback.appendDirectoryContent(elements);
                    }
                }
            });
            provider.setStepByStepListener(consumer);
            this.executeCommand(provider, callback, parent, project);
            consumer.flush();
        }
    }

    public DirectoryContentProvider createDirectoryContentProvider(String path) {
        return new GetDirectoriesListViaUpdateOperation(this.myEnvironment, path);
    }

    private void executeCommand(final DirectoryContentProvider command, final GetContentCallback callback, final CvsElement parent, final Project project) {
        CvsOperationExecutor executor1 = new CvsOperationExecutor(false, project, ModalityState.stateForComponent((Component)parent.getTree()));
        executor1.setIsQuietOperation(true);
        MyCancellableCvsHandler cvsHandler = new MyCancellableCvsHandler(CvsBundle.message((String)"browse.repository.operation.name", (Object[])new Object[0]), (CvsOperation)((Object)command));
        callback.useForCancel(cvsHandler.getProgressListener());
        executor1.performActionSync(cvsHandler, new CvsOperationExecutorCallback(){

            @Override
            public void executionFinished(boolean successfully) {
                callback.finished();
                DirectoryContent directoryContent = command.getDirectoryContent();
                ArrayList children = AbstractVcsDataProvider.this.directoryContentToElements(directoryContent, parent, project);
                callback.fillDirectoryContent(children);
            }

            @Override
            public void executeInProgressAfterAction(ModalityContext modaityContext) {
            }

            @Override
            public void executionFinishedSuccessfully() {
            }
        });
    }

    private ArrayList<CvsElement> directoryContentToElements(DirectoryContent directoryContent, CvsElement parent, Project project) {
        ArrayList<CvsElement> children = new ArrayList<CvsElement>();
        if (this.myShowModules) {
            children.addAll(this.addModules(directoryContent, parent, project));
        }
        children.addAll(this.addSubDirectories(directoryContent, parent, project));
        if (this.myShowFiles) {
            children.addAll(this.addFiles(directoryContent, parent, project));
        }
        return children;
    }

    private ArrayList<CvsElement> addFiles(DirectoryContent children, CvsElement element, Project project) {
        return this.createCvsNodesOn(children.getFiles(), element, CvsElementFactory.FILE_ELEMENT_FACTORY, RemoteResourceDataProvider.NOT_EXPANDABLE, project);
    }

    private ArrayList<CvsElement> addSubDirectories(DirectoryContent children, CvsElement element, Project project) {
        return this.createCvsNodesOn(children.getSubDirectories(), element, CvsElementFactory.FOLDER_ELEMENT_FACTORY, this.getChildrenDataProvider(), project);
    }

    private ArrayList<CvsElement> addModules(DirectoryContent children, CvsElement element, Project project) {
        Collection<String> modules = children.getSubModules();
        return this.createCvsNodesOn(modules, element, CvsElementFactory.MODULE_ELEMENT_FACTORY, new ModuleDataProvider(this.myEnvironment, this.myShowFiles), project);
    }

    protected ArrayList<CvsElement> createCvsNodesOn(Collection<String> children, CvsElement element, CvsElementFactory elementFactory, RemoteResourceDataProvider dataProvider, Project project) {
        ArrayList<CvsElement> result = new ArrayList<CvsElement>();
        for (String name : children) {
            result.add(AbstractVcsDataProvider.setElementDetails(elementFactory.createElement(name, this.myEnvironment, project), name, element, dataProvider));
        }
        return result;
    }

    private static CvsElement setElementDetails(CvsElement result, String name, CvsElement parent, RemoteResourceDataProvider dataProvider) {
        result.setDataProvider(dataProvider);
        result.setName(name);
        result.setPath(AbstractVcsDataProvider.getPathForName(name, parent));
        result.setModel(parent.getModel());
        return result;
    }

    protected abstract AbstractVcsDataProvider getChildrenDataProvider();

    private static String getPathForName(String name, CvsElement parent) {
        return parent.createPathForChild(name);
    }

    private static class MyCancellableCvsHandler
    extends CommandCvsHandler {
        private MyCancellableCvsHandler(String title, CvsOperation cvsOperation) {
            super(title, cvsOperation, true);
        }

        @Override
        protected boolean runInReadThread() {
            return false;
        }

        @Override
        public CvsListenerWithProgress getProgressListener() {
            return super.getProgressListener();
        }
    }

    private static class MyBufferedConsumer
    implements Consumer<DirectoryContent> {
        private static final int ourSize = 15;
        private final DirectoryContent myBuffer;
        private final Consumer<DirectoryContent> myDelegate;

        private MyBufferedConsumer(Consumer<DirectoryContent> delegate) {
            this.myDelegate = delegate;
            this.myBuffer = new DirectoryContent();
        }

        public void consume(DirectoryContent directoryContent) {
            this.myBuffer.copyDataFrom(directoryContent);
            if (this.myBuffer.getTotalSize() >= 15) {
                this.myDelegate.consume((Object)this.myBuffer);
                this.myBuffer.clear();
            }
        }

        public void flush() {
            if (this.myBuffer.getTotalSize() > 0) {
                this.myDelegate.consume((Object)this.myBuffer);
            }
        }
    }
}

