/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.properties.references;

import com.intellij.lang.properties.PropertiesFilesManager;
import com.intellij.lang.properties.PropertiesReferenceManager;
import com.intellij.lang.properties.psi.PropertiesElementFactory;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.lang.properties.psi.Property;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Processor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class I18nUtil {
    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static List<PropertiesFile> propertiesFilesByBundleName(String resourceBundleName, PsiElement context) {
        List<PropertiesFile> list;
        Project project;
        Module module;
        VirtualFile virtualFile;
        PsiFile containingFile = context.getContainingFile();
        PsiElement containingFileContext = containingFile.getContext();
        if (containingFileContext != null) {
            containingFile = containingFileContext.getContainingFile();
        }
        if ((virtualFile = containingFile.getVirtualFile()) == null) {
            virtualFile = containingFile.getOriginalFile().getVirtualFile();
        }
        if (virtualFile != null && (module = ProjectRootManager.getInstance((Project)(project = containingFile.getProject())).getFileIndex().getModuleForFile(virtualFile)) != null) {
            PropertiesReferenceManager refManager = PropertiesReferenceManager.getInstance(project);
            list = refManager.findPropertiesFiles(module, resourceBundleName);
            if (list == null) throw new IllegalStateException("@NotNull method com/intellij/lang/properties/references/I18nUtil.propertiesFilesByBundleName must not return null");
            return list;
        }
        list = Collections.emptyList();
        if (list != null) return list;
        throw new IllegalStateException("@NotNull method com/intellij/lang/properties/references/I18nUtil.propertiesFilesByBundleName must not return null");
    }

    public static void createProperty(Project project, Collection<PropertiesFile> propertiesFiles, String key, String value) throws IncorrectOperationException {
        Property property = PropertiesElementFactory.createProperty(project, key, value);
        for (PropertiesFile file : propertiesFiles) {
            PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)project);
            documentManager.commitDocument(documentManager.getDocument((PsiFile)file));
            Property existingProperty = file.findPropertyByKey(property.getUnescapedKey());
            if (existingProperty != null) continue;
            file.addProperty(property);
        }
    }

    public static List<String> defaultGetPropertyFiles(Project project) {
        final ArrayList<String> paths = new ArrayList<String>();
        final ProjectFileIndex projectFileIndex = ProjectRootManager.getInstance((Project)project).getFileIndex();
        PropertiesFilesManager.getInstance(project).processAllPropertiesFiles(new Processor<VirtualFile>(){

            public boolean process(VirtualFile virtualFile) {
                if (projectFileIndex.isInContent(virtualFile)) {
                    String path = FileUtil.toSystemDependentName((String)virtualFile.getPath());
                    paths.add(path);
                }
                return true;
            }
        });
        return paths;
    }
}

