/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io.storage;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.Forceable;
import com.intellij.util.io.RecordDataOutput;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public abstract class AbstractStorage
implements Forceable,
Disposable {
    public abstract int createNewRecord(int var1) throws IOException;

    public abstract void deleteRecord(int var1);

    public StorageDataOutput writeStream(int record) {
        return new StorageDataOutput(record);
    }

    public AppenderStream appendStream(int record) {
        return new AppenderStream(record);
    }

    public DataInputStream readStream(int record) {
        byte[] bytes = this.readBytes(record);
        return new DataInputStream(new ByteArrayInputStream(bytes));
    }

    public abstract byte[] readBytes(int var1);

    public abstract void checkSanity(int var1);

    public abstract boolean flushSome();

    public abstract int getVersion();

    public abstract void setVersion(int var1);

    protected abstract int appendBytes(int var1, byte[] var2);

    public abstract void writeBytes(int var1, byte[] var2);

    public abstract int ensureCapacity(int var1, int var2);

    public class AppenderStream
    extends DataOutputStream {
        private int myRecordId;

        public AppenderStream(int recordId) {
            super(new ByteArrayOutputStream());
            this.myRecordId = recordId;
        }

        @Override
        public void close() throws IOException {
            super.close();
            this.myRecordId = AbstractStorage.this.appendBytes(this.myRecordId, ((ByteArrayOutputStream)this.out).toByteArray());
        }

        public int getRecordId() {
            return this.myRecordId;
        }
    }

    public class StorageDataOutput
    extends DataOutputStream
    implements RecordDataOutput {
        private int myRecordId;

        public StorageDataOutput(int recordId) {
            super(new ByteArrayOutputStream());
            this.myRecordId = recordId;
        }

        @Override
        public void close() throws IOException {
            super.close();
            AbstractStorage.this.writeBytes(this.myRecordId, ((ByteArrayOutputStream)this.out).toByteArray());
        }

        @Override
        public int getRecordId() {
            return this.myRecordId;
        }
    }
}

