/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.openapi.util.Condition;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.Query;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.jetbrains.annotations.NotNull;

public class FilteredQuery<T>
implements Query<T> {
    private final Query<T> myOriginal;
    private final Condition<T> myFilter;

    public FilteredQuery(Query<T> original, Condition<T> filter) {
        this.myOriginal = original;
        this.myFilter = filter;
    }

    @Override
    public T findFirst() {
        CommonProcessors.FindFirstProcessor processor = new CommonProcessors.FindFirstProcessor();
        this.forEach((Processor<T>)processor);
        return processor.getFoundValue();
    }

    @Override
    public boolean forEach(final @NotNull Processor<T> consumer) {
        if (consumer == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/FilteredQuery.forEach must not be null");
        }
        this.myOriginal.forEach(new Processor<T>(){

            @Override
            public boolean process(T t) {
                if (!FilteredQuery.this.myFilter.value(t)) {
                    return true;
                }
                return consumer.process(t);
            }
        });
        return true;
    }

    @Override
    @NotNull
    public Collection<T> findAll() {
        final ArrayList result = new ArrayList();
        this.forEach((Processor<T>)new Processor<T>(){

            @Override
            public boolean process(T t) {
                result.add(t);
                return true;
            }
        });
        ArrayList arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/FilteredQuery.findAll must not return null");
        }
        return arrayList;
    }

    @Override
    public T[] toArray(T[] a) {
        return this.findAll().toArray(a);
    }

    @Override
    public Iterator<T> iterator() {
        return this.findAll().iterator();
    }
}

