/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.copyright.pattern;

import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.maddyhome.idea.copyright.pattern.DateInfo;

public class FileInfo {
    private final PsiFile file;

    public FileInfo(PsiFile file) {
        this.file = file;
    }

    public String getPathName() {
        return this.getVirtualFile() != null ? this.getVirtualFile().getPath() : "";
    }

    public String getFileName() {
        return this.getVirtualFile() != null ? this.getVirtualFile().getName() : "";
    }

    public String getClassName() {
        if (this.file instanceof PsiJavaFile) {
            return ((PsiJavaFile)this.file).getClasses()[0].getName();
        }
        return this.getFileName();
    }

    public String getQualifiedClassName() {
        if (this.file instanceof PsiJavaFile) {
            return ((PsiJavaFile)this.file).getClasses()[0].getQualifiedName();
        }
        return this.getPathName();
    }

    public DateInfo getLastModified() {
        if (this.getVirtualFile() != null) {
            return new DateInfo(this.getVirtualFile().getTimeStamp());
        }
        return new DateInfo();
    }

    private VirtualFile getVirtualFile() {
        return this.file.getVirtualFile();
    }
}

