/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.refactoring.inline;

import com.intellij.codeInsight.TargetElementUtil;
import com.intellij.lang.refactoring.InlineHandler;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.help.HelpManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.inline.InlineOptionsDialog;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrBlockStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrIfStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrOpenBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.branch.GrReturnStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrApplicationStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrAssignmentExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrUnaryExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrCallExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrMethodCallExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameter;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMember;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrTypeElement;
import org.jetbrains.plugins.groovy.refactoring.GroovyRefactoringBundle;
import org.jetbrains.plugins.groovy.refactoring.GroovyRefactoringUtil;
import org.jetbrains.plugins.groovy.refactoring.inline.InlineMethodConflictSolver;

public class GroovyInlineMethodUtil {
    private static String myErrorMessage = "ok";
    public static final String REFACTORING_NAME = GroovyRefactoringBundle.message("inline.method.title", new Object[0]);

    private GroovyInlineMethodUtil() {
    }

    @Nullable
    public static InlineHandler.Settings inlineMethodSettings(GrMethod method, Editor editor, boolean invokedOnReference) {
        PsiReference reference;
        Project project = method.getProject();
        if (method.isConstructor()) {
            String message = GroovyRefactoringBundle.message("refactoring.cannot.be.applied.to.constructors", REFACTORING_NAME);
            GroovyInlineMethodUtil.showErrorMessage(message, project, editor);
            return null;
        }
        PsiReference psiReference = reference = editor != null ? TargetElementUtil.findReference((Editor)editor, (int)editor.getCaretModel().getOffset()) : null;
        if (!invokedOnReference || reference == null) {
            String message = GroovyRefactoringBundle.message("multiple.method.inline.is.not.suppored", REFACTORING_NAME);
            GroovyInlineMethodUtil.showErrorMessage(message, project, editor);
            return null;
        }
        PsiElement element = reference.getElement();
        if (!(element.getContainingFile() instanceof GroovyFile) || GroovyInlineMethodUtil.isStaticMethod(method) || !GroovyInlineMethodUtil.areInSameClass(element, method)) {
            // empty if block
        }
        if (!(element instanceof GrExpression) || !(element.getParent() instanceof GrCallExpression)) {
            String message = GroovyRefactoringBundle.message("refactoring.is.available.only.for.method.calls", REFACTORING_NAME);
            GroovyInlineMethodUtil.showErrorMessage(message, project, editor);
            return null;
        }
        GrCallExpression call = (GrCallExpression)element.getParent();
        if (PsiTreeUtil.getParentOfType((PsiElement)element, GrParameter.class) != null) {
            String message = GroovyRefactoringBundle.message("refactoring.is.not.supported.in.parameter.initializers", REFACTORING_NAME);
            GroovyInlineMethodUtil.showErrorMessage(message, project, editor);
            return null;
        }
        GroovyRefactoringUtil.highlightOccurrences(project, editor, new GrExpression[]{call});
        if (method.getBlock() == null) {
            String message = method.hasModifierProperty("abstract") ? GroovyRefactoringBundle.message("refactoring.cannot.be.applied.to.abstract.methods", REFACTORING_NAME) : GroovyRefactoringBundle.message("refactoring.cannot.be.applied.no.sources.attached", REFACTORING_NAME);
            GroovyInlineMethodUtil.showErrorMessage(message, project, editor);
            return null;
        }
        if (GroovyInlineMethodUtil.hasBadReturns(method) && !GroovyInlineMethodUtil.isTailMethodCall(call)) {
            String message = GroovyRefactoringBundle.message("refactoring.is.not.supported.when.return.statement.interrupts.the.execution.flow", REFACTORING_NAME);
            GroovyInlineMethodUtil.showErrorMessage(message, project, editor);
            return null;
        }
        return GroovyInlineMethodUtil.inlineMethodDialogResult(method, project, invokedOnReference);
    }

    static boolean isTailMethodCall(GrCallExpression call) {
        GrMethod method;
        GrStatement stmt = call;
        PsiElement parent = call.getParent();
        if (parent instanceof GrReturnStatement) {
            stmt = (GrReturnStatement)parent;
            parent = parent.getParent();
        }
        if (parent instanceof GrOpenBlock && parent.getParent() instanceof GrMethod) {
            GrStatement[] statements = ((GrOpenBlock)parent).getStatements();
            return statements.length > 0 && stmt == statements[statements.length - 1];
        }
        if (parent instanceof GrClosableBlock) {
            GrStatement[] statements = ((GrClosableBlock)parent).getStatements();
            return statements.length > 0 && stmt == statements[statements.length - 1];
        }
        if (stmt instanceof GrReturnStatement && (method = (GrMethod)PsiTreeUtil.getParentOfType((PsiElement)stmt, GrMethod.class)) != null) {
            Collection<GrReturnStatement> returnStatements = GroovyRefactoringUtil.findReturnStatements(method);
            return returnStatements.contains(stmt) && !GroovyInlineMethodUtil.hasBadReturns(method);
        }
        return false;
    }

    @Nullable
    private static InlineHandler.Settings inlineMethodDialogResult(GrMethod method, Project project, boolean invokedOnReference) {
        Application application = ApplicationManager.getApplication();
        if (!application.isUnitTestMode()) {
            final InlineMethodDialog dialog = new InlineMethodDialog(project, method, invokedOnReference, GroovyInlineMethodUtil.checkMethodForRecursion(method));
            dialog.show();
            if (!dialog.isOK()) {
                WindowManager.getInstance().getStatusBar(project).setInfo(GroovyRefactoringBundle.message("press.escape.to.remove.the.highlighting", new Object[0]));
                return null;
            }
            return new InlineHandler.Settings(){

                public boolean isOnlyOneReferenceToInline() {
                    return dialog.isInlineThisOnly();
                }
            };
        }
        return new InlineHandler.Settings(){

            public boolean isOnlyOneReferenceToInline() {
                return true;
            }
        };
    }

    private static boolean hasBadReturns(GrMethod method) {
        Collection<GrReturnStatement> returnStatements = GroovyRefactoringUtil.findReturnStatements(method);
        GrOpenBlock block = method.getBlock();
        if (block == null || returnStatements.size() == 0) {
            return false;
        }
        boolean checked = GroovyInlineMethodUtil.checkTailOpenBlock(block, returnStatements);
        return !checked || !returnStatements.isEmpty();
    }

    public static boolean checkTailIfStatement(GrIfStatement ifStatement, Collection<GrReturnStatement> returnStatements) {
        GrStatement thenBranch = ifStatement.getThenBranch();
        GrStatement elseBranch = ifStatement.getElseBranch();
        if (elseBranch == null) {
            return false;
        }
        boolean tb = false;
        boolean eb = false;
        if (thenBranch instanceof GrReturnStatement) {
            tb = returnStatements.remove(thenBranch);
        } else if (thenBranch instanceof GrBlockStatement) {
            tb = GroovyInlineMethodUtil.checkTailOpenBlock(((GrBlockStatement)thenBranch).getBlock(), returnStatements);
        }
        if (elseBranch instanceof GrReturnStatement) {
            eb = returnStatements.remove(elseBranch);
        } else if (elseBranch instanceof GrBlockStatement) {
            eb = GroovyInlineMethodUtil.checkTailOpenBlock(((GrBlockStatement)elseBranch).getBlock(), returnStatements);
        }
        return tb && eb;
    }

    private static boolean checkTailOpenBlock(GrOpenBlock block, Collection<GrReturnStatement> returnStatements) {
        if (block == null) {
            return false;
        }
        GrStatement[] statements = block.getStatements();
        if (statements.length == 0) {
            return false;
        }
        GrStatement last = statements[statements.length - 1];
        if (last instanceof GrReturnStatement && returnStatements.contains(last)) {
            returnStatements.remove(last);
            return true;
        }
        if (last instanceof GrIfStatement) {
            return GroovyInlineMethodUtil.checkTailIfStatement((GrIfStatement)last, returnStatements);
        }
        return false;
    }

    private static void showErrorMessage(String message, Project project, Editor editor) {
        Application application = ApplicationManager.getApplication();
        myErrorMessage = message;
        if (!application.isUnitTestMode()) {
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message, (String)REFACTORING_NAME, (String)"refactoring.inlineMethod");
        }
    }

    @Nullable
    static String getInvokedResult() {
        Application application = ApplicationManager.getApplication();
        if (application.isUnitTestMode()) {
            String message = myErrorMessage;
            myErrorMessage = "ok";
            return message;
        }
        return null;
    }

    static boolean isStaticMethod(@NotNull GrMethod method) {
        if (method == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/refactoring/inline/GroovyInlineMethodUtil.isStaticMethod must not be null");
        }
        return method.hasModifierProperty("static");
    }

    static boolean areInSameClass(PsiElement element, GrMethod method) {
        PsiElement parent;
        for (parent = element; parent != null && !(parent instanceof PsiClass) && !(parent instanceof PsiFile); parent = parent.getParent()) {
        }
        if (parent instanceof PsiClass) {
            PsiClass methodClass = method.getContainingClass();
            return parent == methodClass;
        }
        if (parent instanceof GroovyFile) {
            PsiElement mParent = method.getParent();
            return mParent instanceof GroovyFile && mParent == parent;
        }
        return false;
    }

    public static Collection<ReferenceExpressionInfo> collectReferenceInfo(GrMethod method) {
        ArrayList<ReferenceExpressionInfo> list = new ArrayList<ReferenceExpressionInfo>();
        GroovyInlineMethodUtil.collectReferenceInfoImpl(list, method, method);
        return list;
    }

    private static void collectReferenceInfoImpl(Collection<ReferenceExpressionInfo> infos, PsiElement elem, GrMethod method) {
        PsiElement declaration;
        GrReferenceExpression expr;
        PsiReference ref;
        if (elem instanceof GrReferenceExpression && (ref = (expr = (GrReferenceExpression)elem).getReference()) != null && (declaration = ref.resolve()) instanceof GrMember) {
            int offsetInMethod = expr.getTextRange().getStartOffset() - method.getTextRange().getStartOffset();
            GrMember member = (GrMember)declaration;
            infos.add(new ReferenceExpressionInfo(expr, offsetInMethod, member, member.getContainingClass()));
        }
        for (PsiElement element : elem.getChildren()) {
            GroovyInlineMethodUtil.collectReferenceInfoImpl(infos, element, method);
        }
    }

    public static boolean hasNoSideEffects(GrExpression qualifier) {
        if (!(qualifier instanceof GrReferenceExpression)) {
            return false;
        }
        GrExpression qual = ((GrReferenceExpression)qualifier).getQualifierExpression();
        return qual == null || GroovyInlineMethodUtil.hasNoSideEffects(qual);
    }

    static void addQualifiersToInnerReferences(GrMethod method, Collection<ReferenceExpressionInfo> infos, @NotNull GrExpression qualifier) throws IncorrectOperationException {
        if (qualifier == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of org/jetbrains/plugins/groovy/refactoring/inline/GroovyInlineMethodUtil.addQualifiersToInnerReferences must not be null");
        }
        HashSet<GrReferenceExpression> exprs = new HashSet<GrReferenceExpression>();
        for (ReferenceExpressionInfo info : infos) {
            GrReferenceExpression refExpr;
            PsiReference ref = method.findReferenceAt(info.offsetInMethod);
            if (ref == null || !(ref.getElement() instanceof GrReferenceExpression) || (refExpr = (GrReferenceExpression)ref.getElement()).getQualifierExpression() != null) continue;
            exprs.add(refExpr);
        }
        GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance(qualifier.getProject());
        for (GrReferenceExpression expr : exprs) {
            GrExpression qual = factory.createExpressionFromText(qualifier.getText());
            if (!(qual instanceof GrReferenceExpression)) continue;
            expr.setQualifierExpression((GrReferenceExpression)qual);
        }
    }

    private static boolean checkMethodForRecursion(GrMethod method) {
        return GroovyInlineMethodUtil.checkCalls(method.getBlock(), method);
    }

    private static boolean checkCalls(PsiElement scope, PsiMethod method) {
        PsiElement resolved;
        GrExpression expression;
        PsiMethod refMethod;
        if (scope instanceof GrMethodCallExpression ? method.equals(refMethod = ((GrMethodCallExpression)scope).resolveMethod()) : scope instanceof GrApplicationStatement && (expression = ((GrApplicationStatement)scope).getFunExpression()) instanceof GrReferenceExpression && method.equals(resolved = ((GrReferenceExpression)expression).resolve())) {
            return true;
        }
        for (PsiElement child = scope.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (!GroovyInlineMethodUtil.checkCalls(child, method)) continue;
            return true;
        }
        return false;
    }

    public static void replaceParametersWithArguments(GrCallExpression call, GrMethod method) throws IncorrectOperationException {
        GrArgumentList argumentList = call.getArgumentList();
        if (argumentList == null) {
            GroovyInlineMethodUtil.setDefaultValuesToParameters(method, null, call);
            return;
        }
        ArrayList<GrExpression> exprs = new ArrayList<GrExpression>();
        exprs.addAll(Arrays.asList(argumentList.getExpressionArguments()));
        exprs.addAll(Arrays.asList(call.getClosureArguments()));
        boolean firstParamIsMap = argumentList.getNamedArguments().length > 0;
        GrParameter[] parameters = method.getParameters();
        if (parameters.length == 0) {
            return;
        }
        GrParameter firstParam = parameters[0];
        while (exprs.size() > parameters.length - (firstParamIsMap ? 1 : 0)) {
            exprs.remove(exprs.size() - 1);
        }
        int nonDefault = 0;
        for (GrParameter parameter : parameters) {
            if (firstParam == parameter && firstParamIsMap || parameter.getDefaultInitializer() != null) continue;
            ++nonDefault;
        }
        nonDefault = exprs.size() - nonDefault;
        HashSet<String> nameFilter = new HashSet<String>();
        for (GrParameter parameter : parameters) {
            GrExpression initializer;
            if (firstParam == parameter && firstParamIsMap || (initializer = parameter.getDefaultInitializer()) == null) continue;
            if (nonDefault > 0) {
                --nonDefault;
                continue;
            }
            nameFilter.add(parameter.getName());
        }
        GroovyInlineMethodUtil.setDefaultValuesToParameters(method, nameFilter, call);
        GroovyInlineMethodUtil.setValuesToParameters(method, call, exprs, nameFilter, firstParamIsMap);
    }

    private static void setDefaultValuesToParameters(GrMethod method, Collection<String> nameFilter, GrCallExpression call) throws IncorrectOperationException {
        GrParameter[] parameters;
        if (nameFilter == null) {
            nameFilter = new ArrayList<String>();
            for (GrParameter parameter : method.getParameters()) {
                nameFilter.add(parameter.getName());
            }
        }
        for (GrParameter parameter : parameters = method.getParameters()) {
            GrExpression initializer = parameter.getDefaultInitializer();
            if (!nameFilter.contains(parameter.getName()) || initializer == null) continue;
            GroovyInlineMethodUtil.replaceAllOccurrencesWithExpression(method, call, initializer, parameter);
        }
    }

    private static void setValuesToParameters(GrMethod method, GrCallExpression call, List<GrExpression> values, Set<String> nameFilter, boolean firstParamIsMap) throws IncorrectOperationException {
        GrParameter[] parameters;
        if (nameFilter == null) {
            nameFilter = new HashSet<String>();
        }
        if ((parameters = method.getParameters()).length == 0) {
            return;
        }
        int i = firstParamIsMap ? 1 : 0;
        for (GrExpression value : values) {
            while (i < parameters.length && nameFilter.contains(parameters[i].getName())) {
                ++i;
            }
            if (i < parameters.length) {
                GrParameter parameter = parameters[i];
                GroovyInlineMethodUtil.replaceAllOccurrencesWithExpression(method, call, value, parameter);
            }
            ++i;
        }
    }

    private static void replaceAllOccurrencesWithExpression(GrMethod method, GrCallExpression call, GrExpression oldExpression, GrParameter parameter) {
        Collection refs = ReferencesSearch.search((PsiElement)parameter, (SearchScope)GlobalSearchScope.projectScope((Project)parameter.getProject()), (boolean)false).findAll();
        GroovyPsiElementFactory elementFactory = GroovyPsiElementFactory.getInstance(call.getProject());
        GrExpression expression = elementFactory.createExpressionFromText(oldExpression.getText());
        if (!GroovyInlineMethodUtil.canReplaceAllReferencesWithExpression(refs, oldExpression)) {
            String oldName = parameter.getName();
            String newName = InlineMethodConflictSolver.suggestNewName(oldName, method, call, new String[0]);
            expression = elementFactory.createExpressionFromText(newName);
            GrOpenBlock body = method.getBlock();
            GrStatement[] statements = body.getStatements();
            GrStatement anchor = null;
            if (statements.length > 0) {
                anchor = statements[0];
            }
            body.addStatementBefore(elementFactory.createStatementFromText(GroovyInlineMethodUtil.createVariableDefinitionText(parameter, oldExpression, newName)), anchor);
        }
        for (PsiReference ref : refs) {
            PsiElement element = ref.getElement();
            if (!(element instanceof GrReferenceExpression)) continue;
            ((GrReferenceExpression)element).replaceWithExpression(expression, true);
        }
    }

    private static String createVariableDefinitionText(GrParameter parameter, GrExpression expression, String varName) {
        PsiModifierList modifierList = parameter.getModifierList();
        String modifiers = modifierList != null ? modifierList.getText().trim() : "";
        GrTypeElement typeElement = parameter.getTypeElementGroovy();
        String type = typeElement != null ? typeElement.getText() : "";
        if (modifiers.length() == 0 && type.length() == 0) {
            modifiers = "def";
        }
        return modifiers + " " + type + " " + varName + " =  " + expression.getText();
    }

    private static boolean containsWriteAccess(Collection<PsiReference> refs) {
        for (PsiReference ref : refs) {
            PsiElement element = ref.getElement();
            PsiElement parent = element.getParent();
            if (parent instanceof GrAssignmentExpression && ((GrAssignmentExpression)parent).getLValue() == element) {
                return true;
            }
            if (!(parent instanceof GrUnaryExpression)) continue;
            return true;
        }
        return false;
    }

    private static boolean canReplaceAllReferencesWithExpression(Collection<PsiReference> refs, GrExpression expression) {
        if (GroovyInlineMethodUtil.containsWriteAccess(refs)) {
            boolean isFinal;
            PsiElement resolved;
            if (expression instanceof GrReferenceExpression && (resolved = ((GrReferenceExpression)expression).resolve()) instanceof GrVariable && !(resolved instanceof PsiField) && !(isFinal = ((GrVariable)resolved).hasModifierProperty("final"))) {
                PsiReference lastRef = Collections.max(ReferencesSearch.search((PsiElement)resolved, (SearchScope)resolved.getResolveScope()).findAll(), new Comparator<PsiReference>(){

                    @Override
                    public int compare(PsiReference o1, PsiReference o2) {
                        return o1.getElement().getTextRange().getStartOffset() - o2.getElement().getTextRange().getStartOffset();
                    }
                });
                return lastRef.getElement() == expression;
            }
            return false;
        }
        return true;
    }

    static class InlineMethodDialog
    extends InlineOptionsDialog {
        public static final String REFACTORING_NAME = GroovyRefactoringBundle.message("inline.method.title", new Object[0]);
        private final boolean myAllowInlineThisOnly;
        private final PsiMethod myMethod;

        public InlineMethodDialog(Project project, PsiMethod method, boolean invokedOnReference, boolean allowInlineThisOnly) {
            super(project, true, (PsiElement)method);
            this.myMethod = method;
            this.myAllowInlineThisOnly = allowInlineThisOnly;
            this.myInvokedOnReference = invokedOnReference;
            this.setTitle(REFACTORING_NAME);
            this.init();
        }

        protected String getBorderTitle() {
            return GroovyRefactoringBundle.message("inline.method.border.title", new Object[0]);
        }

        protected String getNameLabelText() {
            return GroovyRefactoringBundle.message("inline.method.label", GroovyRefactoringUtil.getMethodSignature(this.myMethod));
        }

        protected String getInlineAllText() {
            return this.myMethod.isWritable() ? GroovyRefactoringBundle.message("all.invocations.and.remove.the.method", new Object[0]) : GroovyRefactoringBundle.message("all.invocations.in.project", new Object[0]);
        }

        protected String getInlineThisText() {
            return GroovyRefactoringBundle.message("this.invocation.only.and.keep.the.method", new Object[0]);
        }

        protected boolean isInlineThis() {
            return false;
        }

        protected void doAction() {
            if (this.getOKAction().isEnabled()) {
                this.close(0);
            }
        }

        protected void doHelpAction() {
            HelpManager.getInstance().invokeHelp("refactoring.inlineMethod");
        }

        protected boolean canInlineThisOnly() {
            return this.myAllowInlineThisOnly;
        }
    }

    static class ReferenceExpressionInfo {
        public final PsiMember declaration;
        public final GrReferenceExpression expression;
        public final int offsetInMethod;
        public final PsiClass containingClass;

        @Nullable
        public String getPresentation() {
            return this.declaration.getName();
        }

        public boolean isStatic() {
            return this.declaration.hasModifierProperty("static");
        }

        public ReferenceExpressionInfo(GrReferenceExpression expression, int offsetInMethod, PsiMember declaration, PsiClass containingClass) {
            this.expression = expression;
            this.offsetInMethod = offsetInMethod;
            this.declaration = declaration;
            this.containingClass = containingClass;
        }
    }
}

