/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.intentions.conversions;

import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.intentions.base.Intention;
import org.jetbrains.plugins.groovy.intentions.base.IntentionUtils;
import org.jetbrains.plugins.groovy.intentions.base.PsiElementPredicate;
import org.jetbrains.plugins.groovy.intentions.conversions.IndexingMethodConversionPredicate;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrMethodCallExpression;

public class IndexingMethodConversionIntention
extends Intention {
    @Override
    @NotNull
    public PsiElementPredicate getElementPredicate() {
        IndexingMethodConversionPredicate indexingMethodConversionPredicate = new IndexingMethodConversionPredicate();
        if (indexingMethodConversionPredicate == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/intentions/conversions/IndexingMethodConversionIntention.getElementPredicate must not return null");
        }
        return indexingMethodConversionPredicate;
    }

    @Override
    public void processIntention(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/intentions/conversions/IndexingMethodConversionIntention.processIntention must not be null");
        }
        GrMethodCallExpression callExpression = (GrMethodCallExpression)element;
        GrArgumentList argList = callExpression.getArgumentList();
        GrExpression[] arguments = argList.getExpressionArguments();
        GrReferenceExpression methodExpression = (GrReferenceExpression)callExpression.getInvokedExpression();
        IElementType referenceType = methodExpression.getDotTokenType();
        String methodName = methodExpression.getName();
        GrExpression qualifier = methodExpression.getQualifierExpression();
        if ("getAt".equals(methodName) || "get".equals(methodName)) {
            IntentionUtils.replaceExpression(qualifier.getText() + '[' + arguments[0].getText() + ']', callExpression);
        } else {
            IntentionUtils.replaceExpression(qualifier.getText() + '[' + arguments[0].getText() + "]=" + arguments[1].getText(), callExpression);
        }
    }
}

