/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.doc;

import com.intellij.CommonBundle;
import com.intellij.openapi.help.HelpManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import java.io.File;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.plugins.groovy.doc.GroovyDocBundle;
import org.jetbrains.plugins.groovy.doc.GroovyDocConfiguration;
import org.jetbrains.plugins.groovy.doc.GroovyDocGenerationPanel;

public final class GenerateGroovyDocDialog
extends DialogWrapper {
    private final Project myProject;
    private final GroovyDocConfiguration myConfiguration;
    private final GroovyDocGenerationPanel myPanel;

    public GenerateGroovyDocDialog(Project project, GroovyDocConfiguration configuration) {
        super(project, true);
        this.myProject = project;
        this.myConfiguration = configuration;
        this.setOKButtonText(GroovyDocBundle.message("groovydoc.generate.start.button", new Object[0]));
        this.setTitle(GroovyDocBundle.message("groovydoc.generate.title", new Object[0]));
        this.myPanel = new GroovyDocGenerationPanel();
        this.init();
        this.myPanel.reset(configuration);
    }

    protected JComponent createCenterPanel() {
        return this.myPanel.getPanel();
    }

    protected Action[] createActions() {
        return new Action[]{this.getOKAction(), this.getCancelAction(), this.getHelpAction()};
    }

    protected void doOKAction() {
        this.myPanel.apply(this.myConfiguration);
        if (this.checkOutputDirectory(this.myConfiguration.OUTPUT_DIRECTORY) && this.checkInputDirectory(this.myConfiguration.INPUT_DIRECTORY)) {
            this.close(0);
        }
    }

    protected void doHelpAction() {
        HelpManager.getInstance().invokeHelp("editing.groovydocGeneration");
    }

    private boolean checkOutputDirectory(String outputDirectory) {
        if (outputDirectory == null || outputDirectory.trim().length() == 0) {
            Messages.showMessageDialog((Project)this.myProject, (String)GroovyDocBundle.message("groovydoc.generate.output.directory.not.specified", new Object[0]), (String)CommonBundle.getErrorTitle(), (Icon)Messages.getErrorIcon());
            return false;
        }
        File outputDir = new File(outputDirectory);
        if (!outputDir.exists()) {
            int choice = Messages.showOkCancelDialog((Project)this.myProject, (String)GroovyDocBundle.message("groovydoc.generate.output.directory.not.exists", outputDirectory), (String)GroovyDocBundle.message("groovydoc.generate.message.title", new Object[0]), (Icon)Messages.getWarningIcon());
            if (choice != 0) {
                return false;
            }
            if (!outputDir.mkdirs()) {
                Messages.showMessageDialog((Project)this.myProject, (String)GroovyDocBundle.message("groovydoc.generate.output.directory.creation.failed", outputDirectory), (String)CommonBundle.getErrorTitle(), (Icon)Messages.getErrorIcon());
                return false;
            }
        } else if (!outputDir.isDirectory()) {
            Messages.showMessageDialog((Project)this.myProject, (String)GroovyDocBundle.message("groovydoc.generate.output.not.a.directory", outputDirectory), (String)CommonBundle.getErrorTitle(), (Icon)Messages.getErrorIcon());
            return false;
        }
        return true;
    }

    private boolean checkInputDirectory(String inputDirectory) {
        if (inputDirectory == null || inputDirectory.trim().length() == 0) {
            Messages.showMessageDialog((Project)this.myProject, (String)GroovyDocBundle.message("groovydoc.generate.input.directory.not.specified", new Object[0]), (String)CommonBundle.getErrorTitle(), (Icon)Messages.getErrorIcon());
            return false;
        }
        File outputDir = new File(inputDirectory);
        if (!outputDir.exists()) {
            int choice = Messages.showOkCancelDialog((Project)this.myProject, (String)GroovyDocBundle.message("groovydoc.generate.input.directory.not.exists", inputDirectory), (String)GroovyDocBundle.message("groovydoc.generate.message.title", new Object[0]), (Icon)Messages.getWarningIcon());
            if (choice != 0) {
                return false;
            }
            if (!outputDir.mkdirs()) {
                Messages.showMessageDialog((Project)this.myProject, (String)GroovyDocBundle.message("groovydoc.generate.input.directory.creation.failed", inputDirectory), (String)CommonBundle.getErrorTitle(), (Icon)Messages.getErrorIcon());
                return false;
            }
        } else if (!outputDir.isDirectory()) {
            Messages.showMessageDialog((Project)this.myProject, (String)GroovyDocBundle.message("groovydoc.generate.input.not.a.directory", inputDirectory), (String)CommonBundle.getErrorTitle(), (Icon)Messages.getErrorIcon());
            return false;
        }
        return true;
    }
}

