/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.debugger;

import com.intellij.debugger.NoDataException;
import com.intellij.debugger.PositionManager;
import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.CompoundPositionManager;
import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.jdi.VirtualMachineProxy;
import com.intellij.debugger.requests.ClassPrepareRequestor;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.impl.DirectoryIndex;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Processor;
import com.intellij.util.Query;
import com.intellij.util.containers.HashSet;
import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.Location;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.request.ClassPrepareRequest;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.GroovyFileTypeLoader;
import org.jetbrains.plugins.groovy.extensions.debugger.ScriptPositionManagerHelper;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFileBase;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.impl.GroovyPsiManager;

public class GroovyPositionManager
implements PositionManager {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.debugger.engine.PositionManagerImpl");
    private final DebugProcess myDebugProcess;

    public GroovyPositionManager(DebugProcess debugProcess) {
        this.myDebugProcess = debugProcess;
    }

    public DebugProcess getDebugProcess() {
        return this.myDebugProcess;
    }

    @NotNull
    public List<Location> locationsOfLine(ReferenceType type, SourcePosition position) throws NoDataException {
        List<Location> list;
        try {
            List<Location> locations;
            int line = position.getLine() + 1;
            List<Location> list2 = locations = this.getDebugProcess().getVirtualMachineProxy().versionHigher("1.4") ? type.locationsOfLine("Java", null, line) : type.locationsOfLine(line);
            if (locations == null || locations.isEmpty()) {
                throw new NoDataException();
            }
            list = locations;
        }
        catch (AbsentInformationException e) {
            throw new NoDataException();
        }
        if (list == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/debugger/GroovyPositionManager.locationsOfLine must not return null");
        }
        return list;
    }

    @Nullable
    private static GroovyPsiElement findReferenceTypeSourceImage(SourcePosition position) {
        PsiFile file = position.getFile();
        if (!(file instanceof GroovyFileBase)) {
            return null;
        }
        PsiElement element = file.findElementAt(position.getOffset());
        if (element == null) {
            return null;
        }
        return (GroovyPsiElement)PsiTreeUtil.getParentOfType((PsiElement)element, (Class[])new Class[]{GrClosableBlock.class, GrTypeDefinition.class});
    }

    @Nullable
    private static GrTypeDefinition findEnclosingTypeDefinition(SourcePosition position) {
        PsiFile file = position.getFile();
        if (!(file instanceof GroovyFileBase)) {
            return null;
        }
        PsiElement element = file.findElementAt(position.getOffset());
        while ((element = PsiTreeUtil.getParentOfType((PsiElement)element, GrTypeDefinition.class)) != null && ((GrTypeDefinition)element).isAnonymous()) {
        }
        return (GrTypeDefinition)element;
    }

    public ClassPrepareRequest createPrepareRequest(final ClassPrepareRequestor requestor, final SourcePosition position) throws NoDataException {
        String qName = GroovyPositionManager.getOuterClassName(position);
        if (qName != null) {
            return this.myDebugProcess.getRequestsManager().createClassPrepareRequest(requestor, qName);
        }
        qName = GroovyPositionManager.findEnclosingName(position);
        if (qName == null) {
            throw new NoDataException();
        }
        ClassPrepareRequestor waitRequestor = new ClassPrepareRequestor(){

            public void processClassPrepare(DebugProcess debuggerProcess, ReferenceType referenceType) {
                CompoundPositionManager positionManager = ((DebugProcessImpl)debuggerProcess).getPositionManager();
                if (positionManager.locationsOfLine(referenceType, position).size() > 0) {
                    requestor.processClassPrepare(debuggerProcess, referenceType);
                } else {
                    List positionClasses = positionManager.getAllClasses(position);
                    if (positionClasses.contains(referenceType)) {
                        requestor.processClassPrepare(debuggerProcess, referenceType);
                    }
                }
            }
        };
        return this.myDebugProcess.getRequestsManager().createClassPrepareRequest(waitRequestor, qName + "$*");
    }

    @Nullable
    private static String findEnclosingName(final SourcePosition position) {
        return (String)ApplicationManager.getApplication().runReadAction((Computable)new Computable<String>(){

            @Nullable
            public String compute() {
                GrTypeDefinition typeDefinition = GroovyPositionManager.findEnclosingTypeDefinition(position);
                if (typeDefinition != null) {
                    return typeDefinition.getQualifiedName();
                }
                return GroovyPositionManager.getScriptQualifiedName(position);
            }
        });
    }

    @Nullable
    private static String getOuterClassName(final SourcePosition position) {
        return (String)ApplicationManager.getApplication().runReadAction((Computable)new Computable<String>(){

            @Nullable
            public String compute() {
                GroovyPsiElement sourceImage = GroovyPositionManager.findReferenceTypeSourceImage(position);
                if (sourceImage instanceof GrTypeDefinition) {
                    return GroovyPositionManager.getClassNameForJvm((GrTypeDefinition)sourceImage);
                }
                if (sourceImage == null) {
                    return GroovyPositionManager.getScriptQualifiedName(position);
                }
                return null;
            }
        });
    }

    private static String getClassNameForJvm(PsiClass typeDefinition) {
        PsiClass psiClass = typeDefinition.getContainingClass();
        if (psiClass != null) {
            return GroovyPositionManager.getClassNameForJvm(psiClass) + "$" + typeDefinition.getName();
        }
        for (ScriptPositionManagerHelper helper : (ScriptPositionManagerHelper[])ScriptPositionManagerHelper.EP_NAME.getExtensions()) {
            String s = helper.customizeClassName(typeDefinition);
            if (s == null) continue;
            return s;
        }
        return typeDefinition.getQualifiedName();
    }

    @Nullable
    private static String getScriptQualifiedName(SourcePosition position) {
        PsiFile file = position.getFile();
        if (file instanceof GroovyFile) {
            return GroovyPositionManager.getScriptFQName((GroovyFile)file);
        }
        return null;
    }

    public SourcePosition getSourcePosition(Location location) throws NoDataException {
        if (location == null) {
            throw new NoDataException();
        }
        PsiFile psiFile = this.getPsiFileByLocation(this.getDebugProcess().getProject(), location);
        if (psiFile == null) {
            throw new NoDataException();
        }
        int lineNumber = this.calcLineIndex(location);
        if (lineNumber < 0) {
            throw new NoDataException();
        }
        return SourcePosition.createFromLine((PsiFile)psiFile, (int)lineNumber);
    }

    private int calcLineIndex(Location location) {
        LOG.assertTrue(this.myDebugProcess != null);
        if (location == null) {
            return -1;
        }
        try {
            return location.lineNumber() - 1;
        }
        catch (InternalError e) {
            return -1;
        }
    }

    @Nullable
    private PsiFile getPsiFileByLocation(final Project project, Location location) {
        PsiClass clazz;
        String qName;
        if (location == null) {
            return null;
        }
        ReferenceType refType = location.declaringType();
        if (refType == null) {
            return null;
        }
        String originalQName = refType.name().replace('/', '.');
        int dollar = originalQName.indexOf(36);
        String runtimeName = qName = dollar >= 0 ? originalQName.substring(0, dollar) : originalQName;
        for (ScriptPositionManagerHelper helper : (ScriptPositionManagerHelper[])ScriptPositionManagerHelper.EP_NAME.getExtensions()) {
            if (!helper.isAppropriateRuntimeName(runtimeName)) continue;
            qName = helper.getOriginalScriptName(refType, runtimeName);
            break;
        }
        GlobalSearchScope searchScope = this.myDebugProcess.getSearchScope();
        PsiClass[] classes = GroovyPsiManager.getInstance(project).getNamesCache().getClassesByFQName(qName, searchScope);
        PsiClass psiClass = clazz = classes.length == 1 ? classes[0] : null;
        if (clazz != null) {
            return clazz.getContainingFile();
        }
        DirectoryIndex directoryIndex = DirectoryIndex.getInstance((Project)project);
        int dotIndex = qName.lastIndexOf(".");
        String packageName = dotIndex > 0 ? qName.substring(0, dotIndex) : "";
        Query query = directoryIndex.getDirectoriesByPackageName(packageName, true);
        final String fileNameWithoutExtension = dotIndex > 0 ? qName.substring(dotIndex + 1) : qName;
        final Set<String> extensions = GroovyPositionManager.getAllGroovyFileExtensions();
        final Ref result = new Ref();
        query.forEach((Processor)new Processor<VirtualFile>(){

            public boolean process(VirtualFile vDir) {
                for (String extension : extensions) {
                    PsiFile psiFile;
                    VirtualFile vFile = vDir.findChild(fileNameWithoutExtension + "." + extension);
                    if (vFile == null || !((psiFile = PsiManager.getInstance((Project)project).findFile(vFile)) instanceof GroovyFileBase)) continue;
                    result.set((Object)psiFile);
                    return false;
                }
                return true;
            }
        });
        PsiFile res = (PsiFile)result.get();
        if (res != null) {
            return res;
        }
        if (StringUtil.isEmpty((String)packageName)) {
            ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)project).getFileIndex();
            for (String extension : extensions) {
                for (PsiFile file : FilenameIndex.getFilesByName((Project)project, (String)(runtimeName + "." + extension), (GlobalSearchScope)GlobalSearchScope.projectScope((Project)project))) {
                    VirtualFile vFile = file.getVirtualFile();
                    if (!(file instanceof GroovyFile) || vFile == null || fileIndex.isInSource(vFile)) continue;
                    for (PsiClass aClass : ((GroovyFile)file).getClasses()) {
                        if (!qName.equals(aClass.getQualifiedName())) continue;
                        return file;
                    }
                }
            }
        }
        for (ScriptPositionManagerHelper helper : (ScriptPositionManagerHelper[])ScriptPositionManagerHelper.EP_NAME.getExtensions()) {
            PsiFile file;
            if (!helper.isAppropriateRuntimeName(runtimeName) || (file = helper.getExtraScriptIfNotFound(refType, runtimeName, project)) == null) continue;
            return file;
        }
        return null;
    }

    private static Set<String> getAllGroovyFileExtensions() {
        HashSet extensions = new HashSet();
        extensions.addAll(GroovyFileTypeLoader.getAllGroovyExtensions());
        extensions.add("gvy");
        extensions.add("gy");
        extensions.add("gsh");
        return extensions;
    }

    @NotNull
    public List<ReferenceType> getAllClasses(final SourcePosition position) throws NoDataException {
        List result = (List)ApplicationManager.getApplication().runReadAction((Computable)new Computable<List<ReferenceType>>(){

            public List<ReferenceType> compute() {
                GroovyPsiElement sourceImage = GroovyPositionManager.findReferenceTypeSourceImage(position);
                String scriptName = GroovyPositionManager.getScriptQualifiedName(position);
                if (sourceImage instanceof GrTypeDefinition) {
                    String qName = GroovyPositionManager.getClassNameForJvm((GrTypeDefinition)sourceImage);
                    if (qName != null) {
                        return GroovyPositionManager.this.myDebugProcess.getVirtualMachineProxy().classesByName(qName);
                    }
                } else if (sourceImage == null) {
                    if (scriptName != null) {
                        return GroovyPositionManager.this.myDebugProcess.getVirtualMachineProxy().classesByName(scriptName);
                    }
                } else {
                    GrTypeDefinition typeDefinition = GroovyPositionManager.findEnclosingTypeDefinition(position);
                    String enclosingName = typeDefinition != null ? typeDefinition.getQualifiedName() : scriptName;
                    if (enclosingName == null) {
                        return Collections.emptyList();
                    }
                    List outers = GroovyPositionManager.this.myDebugProcess.getVirtualMachineProxy().classesByName(enclosingName);
                    ArrayList<ReferenceType> result = new ArrayList<ReferenceType>(outers.size());
                    for (ReferenceType outer : outers) {
                        ReferenceType nested = GroovyPositionManager.this.findNested(outer, sourceImage, position);
                        if (nested == null) continue;
                        result.add(nested);
                    }
                    return result;
                }
                return Collections.emptyList();
            }
        });
        if (result == null || result.isEmpty()) {
            throw new NoDataException();
        }
        List list = result;
        if (list == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/debugger/GroovyPositionManager.getAllClasses must not return null");
        }
        return list;
    }

    private static String getScriptFQName(GroovyFile groovyFile) {
        String plainName;
        VirtualFile vFile = groovyFile.getVirtualFile();
        assert (vFile != null);
        String packageName = groovyFile.getPackageName();
        String fileName = plainName = vFile.getNameWithoutExtension();
        if (groovyFile.isScript()) {
            for (ScriptPositionManagerHelper helper : (ScriptPositionManagerHelper[])ScriptPositionManagerHelper.EP_NAME.getExtensions()) {
                if (!helper.isAppropriateScriptFile(groovyFile)) continue;
                fileName = helper.getRuntimeScriptName(plainName, groovyFile);
                break;
            }
        }
        String qName = packageName.length() > 0 ? packageName + "." + fileName : fileName;
        return qName;
    }

    @Nullable
    private ReferenceType findNested(ReferenceType fromClass, GroovyPsiElement toFind, SourcePosition classPosition) {
        VirtualMachineProxy vmProxy = this.myDebugProcess.getVirtualMachineProxy();
        if (fromClass.isPrepared()) {
            List nestedTypes = vmProxy.nestedTypes(fromClass);
            for (ReferenceType nested : nestedTypes) {
                ReferenceType found = this.findNested(nested, toFind, classPosition);
                if (found == null) continue;
                return found;
            }
            try {
                int lineNumber = classPosition.getLine() + 1;
                if (fromClass.locationsOfLine(lineNumber).size() > 0) {
                    return fromClass;
                }
                Iterator<Location> i$ = fromClass.allLineLocations().iterator();
                if (i$.hasNext()) {
                    Location location = i$.next();
                    SourcePosition candidateFirstPosition = SourcePosition.createFromLine((PsiFile)toFind.getContainingFile(), (int)(location.lineNumber() - 1));
                    if (toFind.equals(GroovyPositionManager.findReferenceTypeSourceImage(candidateFirstPosition))) {
                        return fromClass;
                    }
                }
            }
            catch (AbsentInformationException ignored) {
                // empty catch block
            }
        }
        return null;
    }
}

