/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.config.ui;

import com.intellij.facet.impl.ui.FacetContextChangeListener;
import com.intellij.facet.impl.ui.FacetEditorContextBase;
import com.intellij.facet.ui.FacetConfigurationQuickFix;
import com.intellij.facet.ui.FacetEditorContext;
import com.intellij.facet.ui.FacetEditorValidator;
import com.intellij.facet.ui.FacetValidatorsManager;
import com.intellij.facet.ui.ValidationResult;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.roots.ui.configuration.LibraryTableModifiableModelProvider;
import com.intellij.openapi.roots.ui.configuration.ProjectStructureConfigurable;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.LibraryTableEditor;
import com.intellij.openapi.roots.ui.configuration.projectRoot.LibrariesContainer;
import com.intellij.openapi.roots.ui.configuration.projectRoot.ModuleStructureConfigurable;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.ListSeparator;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.Function;
import com.intellij.util.Icons;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.containers.hash.HashSet;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.config.LibraryManager;

public class ManagedLibrariesEditor {
    private JButton myAddButton;
    private JButton myRemoveButton;
    private JList myLibraryList;
    private JButton myModuleDeps;
    private JPanel myComponent;
    private final FacetEditorContext myEditorContext;
    private final FacetValidatorsManager myValidatorsManager;
    private final DefaultListModel myListModel;
    private final LibrariesContainer myLibrariesContainer;
    private final LibraryManager[] myManagers;
    private final Module myModule;

    public ManagedLibrariesEditor(FacetEditorContext editorContext, FacetValidatorsManager validatorsManager, ExtensionPointName<? extends LibraryManager> epName) {
        this.myEditorContext = editorContext;
        this.myValidatorsManager = validatorsManager;
        this.$$$setupUI$$$();
        this.myModule = this.myEditorContext.getModule();
        this.myLibrariesContainer = this.getFacetEditorContext().getContainer();
        this.myManagers = (LibraryManager[])epName.getExtensions();
        this.myListModel = new DefaultListModel();
        this.setUpLibraryList();
        this.installPopup();
        this.installButtonListeners(editorContext);
        this.getFacetEditorContext().addFacetContextChangeListener(new FacetContextChangeListener(){

            public void moduleRootsChanged(ModifiableRootModel rootModel) {
                ManagedLibrariesEditor.this.updateLibraryList();
            }

            public void facetModelChanged(@NotNull Module module) {
                if (module == null) {
                    throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/config/ui/ManagedLibrariesEditor$1.facetModelChanged must not be null");
                }
            }
        });
    }

    private void installButtonListeners(final FacetEditorContext editorContext) {
        this.myAddButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ManagedLibrariesEditor.this.performAddAction(ManagedLibrariesEditor.this.myAddButton);
            }
        });
        this.myRemoveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ManagedLibrariesEditor.this.deleteSelectedLibraries();
            }
        });
        this.myModuleDeps.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ModuleStructureConfigurable.getInstance((Project)editorContext.getProject()).selectOrderEntry(ManagedLibrariesEditor.this.myModule, null);
            }
        });
    }

    public void shouldHaveLibrary(final Condition<Library> filter, final String errorMessage) {
        this.myValidatorsManager.registerValidator(new FacetEditorValidator(){

            public ValidationResult check() {
                for (ManagedLibrary library : ManagedLibrariesEditor.this.getUsedLibraries()) {
                    if (!filter.value((Object)library.library)) continue;
                    return ValidationResult.OK;
                }
                return new ValidationResult(errorMessage, new FacetConfigurationQuickFix(){

                    public void run(JComponent place) {
                        ManagedLibrariesEditor.this.performAddAction(place);
                    }
                });
            }
        }, new JComponent[0]);
    }

    public FacetEditorContextBase getFacetEditorContext() {
        return (FacetEditorContextBase)this.myEditorContext;
    }

    public JPanel getComponent() {
        return this.myComponent;
    }

    private void performAddAction(JComponent component) {
        Set<ManagedLibrary> managed = this.getUsedLibraries();
        Set usedLibraries = ContainerUtil.map2Set(managed, (Function)new Function<ManagedLibrary, Library>(){

            public Library fun(ManagedLibrary managedLibrary) {
                return managedLibrary.library;
            }
        });
        MultiMap libs = new MultiMap();
        ArrayList toAdd = CollectionFactory.arrayList();
        THashMap separators = CollectionFactory.newTroveMap();
        for (Library library : this.myLibrariesContainer.getAllLibraries()) {
            LibraryManager manager;
            if (usedLibraries.contains(library) || (manager = ManagedLibrariesEditor.findManagerFor(library, this.myManagers, this.myLibrariesContainer)) == null) continue;
            libs.putValue((Object)manager, (Object)new ManagedLibrary(library, manager));
        }
        for (LibraryManager libraryManager : this.myManagers) {
            boolean separatorSet = false;
            for (ManagedLibrary library : libs.get((Object)libraryManager)) {
                if (!separatorSet) {
                    separators.put(library, new ListSeparator(libraryManager.getLibraryCategoryName()));
                    separatorSet = true;
                }
                toAdd.add(library);
            }
            if (!separatorSet) {
                separators.put(libraryManager, new ListSeparator(libraryManager.getLibraryCategoryName()));
            }
            toAdd.add(libraryManager);
        }
        JBPopupFactory.getInstance().createListPopup((ListPopupStep)new ManagedLibrariesPopupStep(toAdd, (Map<Object, ListSeparator>)separators)).showUnderneathOf((Component)component);
    }

    private void deleteSelectedLibraries() {
        HashSet toDelete = new HashSet();
        for (Object value : this.myLibraryList.getSelectedValues()) {
            toDelete.add(((ManagedLibrary)value).library);
        }
        this.doRemoveLibraries((Set<Library>)toDelete);
        this.updateLibraryList();
    }

    private void doRemoveLibraries(Set<Library> toDelete) {
        ModifiableRootModel rootModel = this.myEditorContext.getModifiableRootModel();
        for (OrderEntry entry : rootModel.getOrderEntries()) {
            Library library;
            if (!(entry instanceof LibraryOrderEntry) || (library = ((LibraryOrderEntry)entry).getLibrary()) == null || !toDelete.remove(library)) continue;
            rootModel.removeOrderEntry(entry);
        }
    }

    private void setUpLibraryList() {
        this.myLibraryList.setModel(this.myListModel);
        this.myLibraryList.setCellRenderer(new ColoredListCellRenderer(){

            protected void customizeCellRenderer(JList list, Object value, int index, boolean selected, boolean hasFocus) {
                ManagedLibrary ml = (ManagedLibrary)value;
                this.setIcon(ml.manager.getIcon());
                this.append(ml.getLibraryName());
                String version = ml.version;
                if (StringUtil.isNotEmpty((String)version)) {
                    this.append(" (version " + version + ")", SimpleTextAttributes.GRAY_ITALIC_ATTRIBUTES);
                }
            }
        });
        this.myLibraryList.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                ManagedLibrariesEditor.this.myRemoveButton.setEnabled(ManagedLibrariesEditor.this.hasSelection());
            }
        });
    }

    private void installPopup() {
        DefaultActionGroup actionGroup = new DefaultActionGroup();
        actionGroup.add((AnAction)this.addShortcut("EditSource", new ManagedLibraryAction("&Edit library...", false){

            public void actionPerformed(AnActionEvent e) {
                Object value = ManagedLibrariesEditor.this.myLibraryList.getSelectedValue();
                if (value instanceof ManagedLibrary) {
                    Library library = ((ManagedLibrary)value).library;
                    LibraryTable table = library.getTable();
                    if (table == null) {
                        return;
                    }
                    LibraryTableModifiableModelProvider provider = ProjectStructureConfigurable.getInstance((Project)ManagedLibrariesEditor.this.myModule.getProject()).getContext().createModifiableModelProvider(table.getTableLevel(), false);
                    LibraryTableEditor.editLibrary((LibraryTableModifiableModelProvider)provider, (Library)library).openDialog((Component)ManagedLibrariesEditor.this.myComponent, Collections.singletonList(library), true);
                }
            }
        }));
        actionGroup.add((AnAction)this.addShortcut("GotoDeclaration", new ManagedLibraryAction("&Show in module dependencies", false){

            public void actionPerformed(AnActionEvent e) {
                Object value = ManagedLibrariesEditor.this.myLibraryList.getSelectedValue();
                if (value instanceof ManagedLibrary) {
                    for (OrderEntry entry : ManagedLibrariesEditor.this.myEditorContext.getModifiableRootModel().getOrderEntries()) {
                        LibraryOrderEntry orderEntry;
                        if (!(entry instanceof LibraryOrderEntry) || !((ManagedLibrary)value).library.equals((orderEntry = (LibraryOrderEntry)entry).getLibrary())) continue;
                        ModuleStructureConfigurable.getInstance((Project)ManagedLibrariesEditor.this.myEditorContext.getProject()).selectOrderEntry(ManagedLibrariesEditor.this.myModule, (OrderEntry)orderEntry);
                        return;
                    }
                }
            }
        }));
        actionGroup.add((AnAction)this.addShortcut("$Delete", new ManagedLibraryAction("R&emove...", true){

            public void actionPerformed(AnActionEvent e) {
                ManagedLibrariesEditor.this.deleteSelectedLibraries();
            }
        }));
        PopupHandler.installPopupHandler((JComponent)this.myLibraryList, (ActionGroup)actionGroup, (String)"unknown", (ActionManager)ActionManager.getInstance());
    }

    private ManagedLibraryAction addShortcut(String fromAction, ManagedLibraryAction action) {
        action.registerCustomShortcutSet(ActionManager.getInstance().getAction(fromAction).getShortcutSet(), this.myLibraryList);
        return action;
    }

    private boolean hasSelection() {
        return this.myLibraryList.getSelectedIndices().length > 0;
    }

    private Set<ManagedLibrary> getUsedLibraries() {
        LinkedHashSet<ManagedLibrary> libraries = new LinkedHashSet<ManagedLibrary>();
        for (OrderEntry entry : this.myEditorContext.getModifiableRootModel().getOrderEntries()) {
            LibraryManager manager;
            Library library;
            if (!(entry instanceof LibraryOrderEntry) || (library = ((LibraryOrderEntry)entry).getLibrary()) == null || (manager = ManagedLibrariesEditor.findManagerFor(library, this.myManagers, this.myLibrariesContainer)) == null) continue;
            libraries.add(new ManagedLibrary(library, manager));
        }
        return libraries;
    }

    @Nullable
    public static LibraryManager findManagerFor(@NotNull Library library, LibraryManager[] managers, LibrariesContainer container) {
        if (library == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/config/ui/ManagedLibrariesEditor.findManagerFor must not be null");
        }
        for (LibraryManager manager : managers) {
            String name = library.getName();
            if (name == null || !manager.managesName(name) || !manager.managesLibrary(library, container)) continue;
            return manager;
        }
        for (LibraryManager manager : managers) {
            if (!manager.managesLibrary(library, container)) continue;
            return manager;
        }
        return null;
    }

    @Nullable
    public Library findUsedLibrary(Class<?> managedBy) {
        for (ManagedLibrary library : this.getUsedLibraries()) {
            if (!managedBy.isInstance(library.manager)) continue;
            return library.library;
        }
        return null;
    }

    public void updateLibraryList() {
        this.myListModel.clear();
        HashSet usedManagers = new HashSet();
        for (ManagedLibrary library : this.getUsedLibraries()) {
            this.myListModel.addElement(library);
            usedManagers.add(library.manager);
        }
        this.myValidatorsManager.validate();
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JList jList;
        JButton jButton;
        JButton jButton2;
        JButton jButton3;
        JPanel jPanel;
        this.myComponent = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(4, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(0, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myAddButton = jButton3 = new JButton();
        jButton3.setText("Add...");
        jButton3.setMnemonic('A');
        jButton3.setDisplayedMnemonicIndex(0);
        jPanel2.add((Component)jButton3, new GridConstraints(0, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(3, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myRemoveButton = jButton2 = new JButton();
        ((Component)jButton2).setEnabled(false);
        jButton2.setText("Remove");
        jButton2.setMnemonic('E');
        jButton2.setDisplayedMnemonicIndex(1);
        jPanel2.add((Component)jButton2, new GridConstraints(1, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        this.myModuleDeps = jButton = new JButton();
        jButton.setText("View classpath");
        jButton.setMnemonic('V');
        jButton.setDisplayedMnemonicIndex(0);
        jPanel2.add((Component)jButton, new GridConstraints(2, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        JScrollPane jScrollPane = new JScrollPane();
        jPanel.add((Component)jScrollPane, new GridConstraints(0, 0, 1, 1, 0, 3, 7, 7, new Dimension(300, 150), null, null));
        this.myLibraryList = jList = new JList();
        jScrollPane.setViewportView(jList);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myComponent;
    }

    private abstract class ManagedLibraryAction
    extends AnAction
    implements DumbAware {
        private final boolean myOnMultiSelection;

        protected ManagedLibraryAction(String text, boolean onMultiSelection) {
            super(text);
            this.myOnMultiSelection = onMultiSelection;
        }

        public void update(AnActionEvent e) {
            int selCount = ManagedLibrariesEditor.this.myLibraryList.getSelectedIndices().length;
            e.getPresentation().setEnabled(this.myOnMultiSelection ? selCount > 0 : selCount == 1);
        }
    }

    private class ManagedLibrariesPopupStep
    extends BaseListPopupStep<Object> {
        private final Map<Object, ListSeparator> mySeparators;

        public ManagedLibrariesPopupStep(List<Object> toAdd, Map<Object, ListSeparator> separators) {
            super(null, toAdd);
            this.mySeparators = separators;
        }

        /*
         * Enabled aggressive block sorting
         */
        @NotNull
        public String getTextFor(Object value) {
            String string;
            if (value instanceof ManagedLibrary) {
                ManagedLibrary ml = (ManagedLibrary)value;
                String name = ml.getLibraryName();
                String version = ml.version;
                if (!(StringUtil.isNotEmpty((String)version) ? (string = name + " (version " + version + ")") != null : (string = name) != null)) throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/config/ui/ManagedLibrariesEditor$ManagedLibrariesPopupStep.getTextFor must not return null");
                return string;
            }
            string = ((LibraryManager)value).getAddActionText();
            if (string != null) return string;
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/config/ui/ManagedLibrariesEditor$ManagedLibrariesPopupStep.getTextFor must not return null");
        }

        public Icon getIconFor(Object value) {
            if (value instanceof ManagedLibrary) {
                return Icons.LIBRARY_ICON;
            }
            return ((LibraryManager)value).getIcon();
        }

        public ListSeparator getSeparatorAbove(Object value) {
            return this.mySeparators.get(value);
        }

        public PopupStep onChosen(final Object selectedValue, boolean finalChoice) {
            return this.doFinalStep(new Runnable(){

                @Override
                public void run() {
                    LibraryManager manager;
                    Library library;
                    if (selectedValue instanceof ManagedLibrary) {
                        ManagedLibrary managedLibrary = (ManagedLibrary)selectedValue;
                        ManagedLibrariesPopupStep.this.addLibraryCheckingExistings(managedLibrary.manager, managedLibrary.library);
                    } else if (selectedValue instanceof LibraryManager && (library = (manager = (LibraryManager)selectedValue).createLibrary(ManagedLibrariesEditor.this.myEditorContext)) != null) {
                        ManagedLibrariesPopupStep.this.addLibraryCheckingExistings(manager, library);
                    }
                    ManagedLibrariesEditor.this.updateLibraryList();
                }
            });
        }

        private void addLibraryCheckingExistings(LibraryManager manager, Library library) {
            for (ManagedLibrary existing : ManagedLibrariesEditor.this.getUsedLibraries()) {
                if (existing.manager != manager) continue;
                String message = "There is already a " + manager.getLibraryCategoryName() + " library";
                String version = manager.getLibraryVersion(existing.library, ManagedLibrariesEditor.this.myLibrariesContainer);
                if (StringUtil.isNotEmpty((String)version)) {
                    message = message + " of version " + version;
                }
                message = message + ".\n Do you want to replace the existing one?";
                String replace = "&Replace";
                int result = Messages.showDialog((Component)ManagedLibrariesEditor.this.myComponent, (String)message, (String)"Library already exists", (String[])new String[]{"&Replace", "&Add", "&Cancel"}, (int)0, null);
                if (result == 2 || result < 0) {
                    return;
                }
                if (result != 0) continue;
                ManagedLibrariesEditor.this.doRemoveLibraries((Set)new THashSet(Arrays.asList(existing.library)));
            }
            ManagedLibrariesEditor.this.myEditorContext.getModifiableRootModel().addLibraryEntry(library);
        }
    }

    private class ManagedLibrary {
        final Library library;
        final LibraryManager manager;
        @Nullable
        final String version;

        private ManagedLibrary(@NotNull Library library, LibraryManager manager) {
            if (library == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/config/ui/ManagedLibrariesEditor$ManagedLibrary.<init> must not be null");
            }
            if (manager == null) {
                throw new IllegalArgumentException("Argument 1 for @NotNull parameter of org/jetbrains/plugins/groovy/config/ui/ManagedLibrariesEditor$ManagedLibrary.<init> must not be null");
            }
            this.library = library;
            this.manager = manager;
            this.version = manager.getLibraryVersion(library, ManagedLibrariesEditor.this.myLibrariesContainer);
        }

        public String getLibraryName() {
            String s = this.library.getName();
            return s == null ? "<noname>" : s;
        }
    }
}

